import {html} from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
  return html`<!--_html_template_start_--><style include="cr-shared-style md-select cros-color-overrides">
  cr-dialog {
    --cr-dialog-width: 416px;
  }

  .advanced-settings {
    font-size: 0.625rem;
    font-weight: 500;
    line-height: 10px;
    --cr-section-padding: 4px;
    --cr-section-min-height: 45px;
  }

  .cr-row-line {
    --cr-section-min-height: 0px;
  }

  .dropdown-section {
    margin-bottom: var(--cr-form-field-bottom-spacing);
    padding-top: 13px;
  }

  .select-field {
    width: 100%;
  }

  .checkbox-section {
    --cr-checkbox-label-padding-start: 11px;
    margin-bottom: 14px;
  }

  .default-apn-info {
    display: flex;
    margin-bottom: -5px;
    padding-top: 10px;
  }

  .default-apn-info span {
    font-size: 0.6875rem; /* 11px */
  }

  .checkbox-text-area {
    margin: 5px 0;
  }

  iron-icon[icon='cr:info-outline'] {
    --iron-icon-width: 1rem;
    --iron-icon-height: 1rem;
    --iron-icon-fill-color: var(--cr-secondary-text-color);
    margin-inline-end: 8px;
  }

  .visually-hidden {
    clip: rect(0 0 0 0);
    clip-path: inset(50%);
    height: 1px;
    overflow: hidden;
    position: absolute;
    white-space: nowrap;
    width: 1px;
  }
</style>
<cr-dialog id="apnDetailDialog" show-on-attach>
  <div id="apnDetailDialogTitle" slot="title" aria-live="polite">
    [[getDialogTitle_(mode)]]
  </div>
  <div slot="body">
    <cr-input id="apnInput" value="{{apn_}}" label="[[i18n('apn')]]"
        type="text" invalid="[[isApnInputInvalid_]]"
        error-message="[[getApnErrorMessage_(isApnInputInvalid_, apn_,
            isMaxApnInputLengthReached_)]]"
        disabled="[[isUiElementDisabled_(UiElement.INPUT, mode)]]">
    </cr-input>
    <cr-input id="usernameInput" value="{{username_}}"
        label="[[i18n('OncCellular-APN-Username')]]" type="text"
        disabled="[[isUiElementDisabled_(UiElement.INPUT, mode)]]">
    </cr-input>
    <cr-input id="passwordInput" value="{{password_}}"
        label="[[i18n('OncCellular-APN-Password')]]" type="password"
        disabled="[[isUiElementDisabled_(UiElement.INPUT, mode)]]">
    </cr-input>
    <cr-expand-button id="advancedSettingsBtn"
        class="advanced-settings cr-row"
        expanded="{{advancedSettingsExpanded_}}"
        aria-describedby="apnDetailDialogTitle">
      <div>[[i18n('apnDetailAdvancedSettings')]]</div>
    </cr-expand-button>
    <iron-collapse opened="[[advancedSettingsExpanded_]]">
      <div id="authenticationTypeSelection" class="dropdown-section">
        <div id="authenticationTypeLabel" class="cr-form-field-label">
          [[i18n('apnDetailAuthType')]]
        </div>
        <select id="authTypeDropDown" class="select-field md-select"
            value="{{selectedAuthType_::change}}"
            disabled="[[isUiElementDisabled_(UiElement.INPUT, mode)]]"
            aria-labelledby="authenticationTypeLabel">
          <template is="dom-repeat"
              items="[[AuthenticationTypes]]">
            <option value="[[item]]"
                selected="[[isSelectedAuthType_(item)]]">
              [[getAuthTypeLocalizedLabel_(item)]]
            </option>
          </template>
        </select>
      </div>
      <div id="apnDetailApnTypesLabel" class="cr-form-field-label">
        [[i18n('apnDetailApnTypes')]]
      </div>
      <div id="checkboxContainer" class="checkbox-section">
        <cr-checkbox id="apnDefaultTypeCheckbox"
            aria-describedby="apnDetailApnTypesLabel"
            disabled="[[isUiElementDisabled_(UiElement.INPUT, mode)]]"
            checked="{{isDefaultApnType_}}">
          <div id="apnDefaultTypelabel" class="checkbox-text-area">
            [[i18n('apnDetailApnTypeDefault')]]
          </div>
        </cr-checkbox>
        <cr-checkbox id="apnAttachTypeCheckbox"
            disabled="[[isUiElementDisabled_(UiElement.INPUT, mode)]]"
            aria-describedby="apnDetailApnTypesLabel"
            checked="{{isAttachApnType_}}">
          <div id="apnAttachTypeLabel" class="checkbox-text-area">
            [[i18n('apnDetailApnTypeAttach')]]
          </div>
        </cr-checkbox>
        <template is="dom-if" if="[[shouldShowApnTypeErrorMessage_]]" restamp>
          <div id="defaultApnRequiredInfo" class="default-apn-info">
            <iron-icon icon="cr:info-outline"></iron-icon>
            <span aria-live="polite">[[i18n('apnDetailDefaultApnRequired')]]</span>
          </div>
        </template>
      </div>
      <div id="ipTypeSelection" class="dropdown-section">
        <div id="ipTypeLabel" class="cr-form-field-label">
          [[i18n('apnDetailIpType')]]
        </div>
        <select id="ipTypeDropDown" class="md-select select-field"
            value="{{selectedIpType_::change}}"
            disabled="[[isUiElementDisabled_(UiElement.INPUT, mode)]]"
            aria-labelledby="ipTypeLabel">
          <template is="dom-repeat"
              items="[[IpTypes]]">
            <option value="[[item]]"
                selected="[[isSelectedIpType_(item)]]">
              [[getIpTypeLocalizedLabel_(item)]]
            </option>
          </template>
        </select>
      </div>
    </iron-collapse>
    <div class="cr-row-line cr-row"></div>
  </div>
  <div slot="button-container">
    <template is="dom-if"
        if="[[isUiElementVisible_(UiElement.ACTION_BUTTON, mode)]]" restamp>
      <cr-button id="apnDetailCancelBtn" class="cancel-button"
          on-click="onCancelClicked_">
        [[i18n('apnDetailDialogCancel')]]
      </cr-button>
      <cr-button id="apnDetailActionBtn" class="action-button"
          on-click="onActionButtonClicked_"
          disabled="[[isUiElementDisabled_(UiElement.ACTION_BUTTON, mode,
              apn_, isApnInputInvalid_, shouldShowApnTypeErrorMessage_,
              isDefaultApnType_, isAttachApnType_)]]">
        [[getActionButtonTitle_(mode)]]
      </cr-button>
      <template is="dom-if" if="[[shouldAnnounceA11yActionButtonState_]]"
          restamp>
        <span id="actionButtonEnabledA11yText"
            class="visually-hidden" role="alert">
          [[actionButtonEnabledA11yText_]]
        </span>
      </template>
    </template>
    <template is="dom-if"
        if="[[isUiElementVisible_(UiElement.DONE_BUTTON, mode)]]" restamp>
      <cr-button id="apnDoneBtn" class="action-button"
          aria-describedby="apnInput usernameInput
              authenticationTypeSelection checkboxContainer ipTypeSelection"
          on-click="onCancelClicked_">
        [[i18n('apnDetailDialogDone')]]
      </cr-button>
    </template>
  </div>
</cr-dialog><!--_html_template_end_-->`;
}