import {html} from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
  return html`<!--_html_template_start_--><style include="network-shared">
  div {
    color: var(--cr-secondary-text-color);
  }

  #apnDescription {
    align-items: flex-start;
    display: flex;
    flex-direction: column;
    justify-content: center;
    margin-inline-end: 40px;
    min-height: var(--cr-section-min-height);
    padding: 0 var(--cr-section-padding) 10px var(--cr-section-padding);
  }

  iron-list {
    display: block;
    padding: 0 0 0 var(--cr-section-padding);
  }

  apn-list-item {
    align-items: center;
    border-top: var(--cr-separator-line);
    display: flex;
    min-height: var(--settings-row-min-height);
    padding: 0 20px 0 0;
  }

  #errorMessageContainer {
    display: flex;
    margin: 30px;
    margin-inline-end: 80px;
  }

  iron-icon[icon='cr20:warning'] {
    --iron-icon-width: 1rem;
    --iron-icon-height: 1rem;
    --iron-icon-fill-color: var(--cros-text-color-warning);
    margin-inline-end: 18px;
  }

  #zeroStateContent {
    border-top: var(--cr-separator-line);
    display: flex;
    margin-inline-end: 40px;
    padding: 10px var(--cr-section-padding) 10px var(--cr-section-padding);
  }

  iron-icon[icon='cr:info-outline'] {
    --iron-icon-width: 1rem;
    --iron-icon-height: 1rem;
    --iron-icon-fill-color: var(--cr-secondary-text-color);
    margin-inline-end: 10px;
  }
</style>
<div id="apnDescription" class="property-box" aria-live="assertive">
  <template is="dom-if" if="[[!shouldOmitLinks]]" restamp>
    <localized-link
        id="descriptionWithLink"
        localized-string="[[i18nAdvanced('apnSettingsDescriptionWithLink')]]">
    </localized-link>
  </template>
  <template is="dom-if" if="[[shouldOmitLinks]]" restamp>
    <div id="descriptionNoLink" aria-live="polite">
      [[i18n('apnSettingsDescriptionNoLink')]]
    </div>
  </template>
  <template is="dom-if"
      if="[[shouldShowErrorMessage_(managedCellularProperties,
          errorState)]]" restamp>
    <div id="errorMessageContainer">
      <span><iron-icon icon="cr20:warning"></iron-icon></span>
      <span id="errorMessage">
        [[getErrorMessage_(managedCellularProperties, errorState)]]
      </span>
    </div>
  </template>
</div>

<template is="dom-if"
    if="[[shouldShowZeroStateContent_(managedCellularProperties, errorState)]]"
    restamp>
  <div id="zeroStateContent">
    <span><iron-icon icon="cr:info-outline"></iron-icon></span>
      <localized-link
          id="apnSettingsZeroStateDescriptionWithAddLink"
          on-link-clicked="onZeroStateCreateApnLinkClicked_"
          localized-string="[[i18nAdvanced('apnSettingsZeroStateDescriptionWithAddLink')]]">
      </localized-link>
  </div>
</template>

<iron-list items="[[apns_]]"
    on-show-apn-detail-dialog="onShowApnDetailDialog_">
  <template>
    <apn-list-item
        apn="[[item]]"
        is-apn-connected="[[isApnConnected_(index, managedCellularProperties)]]"
        should-disallow-disabling-removing="[[shouldDisallowDisablingRemoving_(item)]]"
        should-disallow-enabling="[[shouldDisallowEnabling_(item)]]"
        should-disallow-apn-modification="[[shouldDisallowApnModification]]"
        guid="[[guid]]"
        item-index="[[index]]"
        list-size="[[apns_.length]]"
        portal-state="[[portalState]]">
    </apn-list-item>
  </template>
</iron-list>

<template is="dom-if" if="[[shouldShowApnDetailDialog_]]" restamp>
  <apn-detail-dialog id="apnDetailDialog"
      mode="[[apnDetailDialogMode_]]"
      guid="[[guid]]"
      apn-list="[[getCustomApnList_(managedCellularProperties)]]"
      on-close="onApnDetailDialogClose_">
  </apn-detail-dialog>
</template>

<template is="dom-if" if="[[shouldShowApnSelectionDialog_]]" restamp>
  <apn-selection-dialog
      should-omit-links="[[shouldOmitLinks]]"
      guid="[[guid]]"
      apn-list="[[getValidDatabaseApnList_(managedCellularProperties)]]"
      on-close="onApnSelectionDialogClose_">
  </apn-selection-dialog>
</template><!--_html_template_end_-->`;
}