import {html} from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
  return html`<!--_html_template_start_--><style include="network-shared">
  :host {
    box-sizing: border-box;
    flex: 1;
    font-family: inherit;
    font-size: 100%;
    /* Specifically for Mac OSX, harmless elsewhere. */
    line-height: 154%;
    min-height: var(--cr-section-min-height);
    padding: 0;
  }

  :host(:not([embedded])) {
    padding: 0 var(--cr-section-padding);
  }

  :host([is-disabled_]) #apnName {
    opacity: var(--cr-disabled-opacity);
  }

  #labelWrapper {
    flex: 1;
    flex-basis: 0.000000001px;
    padding-bottom: var(--cr-section-vertical-padding);
    padding-top: var(--cr-section-vertical-padding);
    text-align: start;
  }

  #label,
  #subLabel {
    display: flex;
  }

  #subLabel {
    color: var(--cros-text-color-positive);
  }

  #subLabel[warning] {
    color: var(--cros-text-color-warning);
  }

  #autoDetected {
    color: var(--cr-secondary-text-color);
    margin-inline-start: 10px;
  }
</style>

<div id="labelWrapper">
  <div id="label" aria-hidden="true">
    <div id="apnName">[[getApnDisplayName_(apn)]]</div>
    <div id="autoDetected" hidden="[[apn.id]]">
      [[i18n('apnAutoDetected')]]
    </div>
  </div>
  <div id="subLabel" class="cr-secondary-text" aria-hidden="true"
      hidden="[[!isApnConnected]]"
      warning$="[[isPortalStateNoInternet_(portalState)]]">
    [[getSublabel_(isApnConnected, portalState)]]
  </div>
</div>
<cr-icon-button id="actionMenuButton" class="icon-more-vert"
    on-click="onMenuButtonClicked_"
    title="[[i18n('apnMoreActionsTitle', apn.accessPointName)]]"
    focus-row-control focus-type="menu"
    aria-label="[[getAriaLabel_(apn, itemIndex, listSize, isApnConnected,
        isDisabled_)]]">
</cr-icon-button>

<cr-action-menu id="dotsMenu">
  <button id="detailsButton" class="dropdown-item"
      on-click="onDetailsClicked_">
    [[getDetailsMenuItemLabel_(apn, shouldDisallowApnModification)]]
  </button>
  <template is="dom-if" if="[[shouldShowDisableMenuItem_(apn)]]" restamp>
    <button id="disableButton" class="dropdown-item"
        on-click="onDisableClicked_"
        disabled="[[shouldDisallowApnModification]]">
      [[i18n('apnMenuDisable')]]
    </button>
  </template>
  <template is="dom-if" if="[[shouldShowEnableMenuItem_(apn)]]" restamp>
    <button id="enableButton" class="dropdown-item"
        on-click="onEnableClicked_"
        disabled="[[shouldDisallowApnModification]]">
      [[i18n('apnMenuEnable')]]
    </button>
  </template>
  <template is="dom-if" if="[[shouldShowRemoveMenuItem_(apn)]]" restamp>
    <button id="removeButton" class="dropdown-item"
        on-click="onRemoveClicked_"
        disabled="[[shouldDisallowApnModification]]">
      [[i18n('apnMenuRemove')]]
    </button>
  </template>
</cr-action-menu><!--_html_template_end_-->`;
}