import {html} from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
  return html`<!--_html_template_start_--><style include="network-shared md-select">
  :host {
    --cr-property-box-width: 200px;
  }

  cr-button {
    margin: 4px 0;
  }

  #attachApnPropertyRow {
    display: flex;
    min-height: 0;
    padding-bottom: 20px;
    padding-top: 8px;
    width: var(--cr-property-box-width);
  }

  #attachApnDescription {
    display: flex;
  }

  #attachApnTooltip {
    --cr-icon-size: 16px;
    margin-inline-start: 6px;
  }
</style>
<div class="property-box">
  <div class="start">[[i18n('networkAccessPoint')]]</div>
  <select id="selectApn" class="md-select" on-change="onSelectApnChange_"
      value="[[selectedApn_]]"
      disabled="[[isDisabled_(disabled, selectedApn_)]]"
      aria-label="[[i18n('networkAccessPoint')]]">
    <template is="dom-repeat" items="[[apnSelectList_]]">
      <option value="[[item.name]]">
        [[apnDesc_(item)]]
      </option>
    </template>
  </select>
</div>

<template is="dom-if" if="[[showOtherApn_(selectedApn_)]]">
  <div id="otherApnProperties" class="property-box single-column indented">
    <network-property-list-mojo on-property-change="onOtherApnChange_"
        fields="[[otherApnFields_]]" property-dict="[[otherApn_]]"
        edit-field-types="[[otherApnEditTypes_]]" prefix="cellular.apn."
        disabled="[[disabled]]">
    </network-property-list-mojo>
    <div id="attachApnPropertyRow" class="property-box horizontal center">
      <div id="attachApnDescription" class="start" aria-hidden="true">
        <span id="attachApnTitle">[[i18n('OncCellular-APN-Attach')]]</span>
        <cr-tooltip-icon id="attachApnTooltip" tooltip-position="right"
            icon-class="cr:help-outline"
            tooltip-text="[[i18n('OncCellular-APN-Attach_TooltipText')]]">
        </cr-tooltip-icon>
      </div>
      <cr-toggle id="attachApnControl" aria-labelledby="attachApnTitle"
          aria-describedby="attachApnTooltip"
          checked="{{isAttachApnToggleEnabled_}}"
          disabled="[[disabled]]">
      </cr-toggle>
    </div>
    <cr-button id="saveButton" class="action-button"
        on-click="onSaveOtherTap_" disabled="[[disabled]]">
      [[i18n('save')]]
    </cr-button>
  </div>
</template>
<!--_html_template_end_-->`;
}