import {html} from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
  return html`<!--_html_template_start_--><style include="network-shared">
  :host {
    cursor: pointer;
  }
  :host([disabled]) {
    cursor: initial;
  }
  cr-policy-network-indicator-mojo {
    --cr-tooltip-icon-margin-start: var(--cr-controlled-by-spacing);
  }
  cr-policy-network-indicator-mojo.left {
    margin-inline-end: var(--cr-controlled-by-spacing);
  }
  div.property-box {
    width: 100%;
  }
  #sub-label {
    font-size: 0.75rem;
  }
</style>

<div class="property-box">
  <div class="start">
    <div aria-hidden="true">[[label]]</div>
    <div id="sub-label" class="cr-secondary-text" aria-hidden="true">
      [[subLabel]]
    </div>
  </div>
  <template is="dom-if" if="[[policyOnLeft]]">
    <cr-policy-network-indicator-mojo class="left"
        property="[[property]]">
    </cr-policy-network-indicator-mojo>
  </template>
  <cr-toggle checked="{{checked}}"
      disabled="[[getDisabled_(disabled, property)]]"
      aria-label$="[[label]]" aria-describedby="sub-label">
  </cr-toggle>
  <template is="dom-if" if="[[!policyOnLeft]]">
    <cr-policy-network-indicator-mojo
        property="[[property]]">
    </cr-policy-network-indicator-mojo>
  </template>
</div>
<!--_html_template_end_-->`;
}