import {html} from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
  return html`<!--_html_template_start_--><style include="cr-hidden-style">
  :host {
    display: inline-flex;
    overflow: hidden;
    padding: 2px;
    position: relative;
  }

  #icon {
    background: var(--network-icon-fill-color, var(--cros-icon-color-primary, rgba(0, 0, 0, 0.65)));
    height: 20px;
    width: 20px;
  }

  /* Upper-left corner */
  #technology {
    --iron-icon-fill-color: var(--cros-icon-color-secondary);
    height: 20px;
    left: 0;
    position: absolute;
    top: 1px;
    width: 20px;
  }

  :host-context([dir='rtl']) #technology {
    left: auto;
    right: 4px;
  }

  /* Lower-right corner */
  #secure {
    --iron-icon-fill-color: var(--cros-icon-color-secondary);
    height: 8px;
    left: 16px;
    position: absolute;
    top: 16px;
    width: 8px;
  }

  :host-context([dir='rtl']) #secure {
    left: auto;
    right: 0;
  }

  /* Upper-left corner */
  #roaming {
    -webkit-mask: url(//resources/ash/common/network/roaming_badge.svg);
    background-color: var(--cros-icon-color-secondary);
    height: 8px;
    left: 3px;
    position: absolute;
    top: 4px;
    width: 8px;
  }

  :host-context([dir='rtl']) #roaming {
    left: auto;
    right: 16px;
  }

  /* Images */
  #icon.ethernet {
    -webkit-mask: url(//resources/ash/common/network/ethernet.svg);
  }

  #icon.vpn {
    -webkit-mask: url(//resources/ash/common/network/vpn.svg);
  }

  /* Wi-Fi images */
  #icon.wifi-not-connected {
    -webkit-mask: url(//resources/ash/common/network/wifi_0_with_x.svg);
  }

  #icon.wifi-no-network,
  #icon.wifi-0 {
    -webkit-mask: url(//resources/ash/common/network/wifi_0.svg);
  }

  #icon.wifi-1 {
    -webkit-mask: url(//resources/ash/common/network/wifi_1.svg);
  }

  #icon.wifi-2 {
    -webkit-mask: url(//resources/ash/common/network/wifi_2.svg);
  }

  #icon.wifi-3 {
    -webkit-mask: url(//resources/ash/common/network/wifi_3.svg);
  }

  #icon.wifi-4 {
    -webkit-mask: url(//resources/ash/common/network/wifi_4.svg);
  }

  #icon.wifi-off {
    -webkit-mask: url(//resources/ash/common/network/wifi_off.svg);
  }

  #icon.wifi-connecting {
    animation: wifi-levels 750ms infinite;
    animation-direction: alternate;
    animation-timing-function: steps(4, end);
  }

  @keyframes wifi-levels {
    0% {
      -webkit-mask: url(//resources/ash/common/network/wifi_0.svg);
    }
    25% {
      -webkit-mask: url(//resources/ash/common/network/wifi_1.svg);
    }
    50% {
      -webkit-mask: url(//resources/ash/common/network/wifi_2.svg);
    }
    75% {
      -webkit-mask: url(//resources/ash/common/network/wifi_3.svg);
    }
    100% {
      -webkit-mask: url(//resources/ash/common/network/wifi_4.svg);
    }
  }

  /* Hotspot images */
  #icon.hotspot-on {
    -webkit-mask: url(//resources/ash/common/hotspot/hotspot.svg);
  }

  #icon.hotspot-off {
    -webkit-mask: url(//resources/ash/common/hotspot/hotspot-off.svg);
  }

  #icon.hotspot-0 {
    -webkit-mask: url(//resources/ash/common/hotspot/hotspot_dot.svg);
  }

  #icon.hotspot-1 {
    -webkit-mask: url(//resources/ash/common/hotspot/hotspot_inner.svg);
  }

  #icon.hotspot-2 {
    -webkit-mask: url(//resources/ash/common/hotspot/hotspot.svg);
  }

  #icon.hotspot-connecting {
    animation: hotspot-levels 1500ms infinite;
    animation-direction: alternate;
    animation-timing-function: steps(4, end);
  }

  @keyframes hotspot-levels {
    0% {
      -webkit-mask: url(//resources/ash/common/hotspot/hotspot_dot.svg);
    }
    50% {
      -webkit-mask: url(//resources/ash/common/hotspot/hotspot_inner.svg);
    }
    100% {
      -webkit-mask: url(//resources/ash/common/hotspot/hotspot.svg);
    }
  }

  /* Cellular images */
  #icon.cellular-not-connected {
    -webkit-mask: url(//resources/ash/common/network/cellular_0_with_x.svg);
  }

  #icon.cellular-not-activated {
    -webkit-mask: url(//resources/ash/common/network/cellular_unactivated.svg);
  }

  #icon.cellular-no-network,
  #icon.cellular-0 {
    -webkit-mask: url(//resources/ash/common/network/cellular_0.svg);
  }

  #icon.cellular-1 {
    -webkit-mask: url(//resources/ash/common/network/cellular_1.svg);
  }

  #icon.cellular-2 {
    -webkit-mask: url(//resources/ash/common/network/cellular_2.svg);
  }

  #icon.cellular-3 {
    -webkit-mask: url(//resources/ash/common/network/cellular_3.svg);
  }

  #icon.cellular-4 {
    -webkit-mask: url(//resources/ash/common/network/cellular_4.svg);
  }

  #icon.cellular-off {
    -webkit-mask: url(//resources/ash/common/network/cellular_off.svg);
  }

  #icon.cellular-locked {
    -webkit-mask: url(//resources/ash/common/network/cellular_locked.svg);
  }

  #icon.cellular-carrier-locked {
    -webkit-mask: url(//resources/ash/common/network/cellular_carrier_locked.svg);
  }

  #icon.cellular-connecting {
    animation: cellular-levels 750ms infinite;
    animation-direction: alternate;
    animation-timing-function: steps(4, end);
  }

  @keyframes cellular-levels {
    0% {
      -webkit-mask: url(//resources/ash/common/network/cellular_0.svg);
    }
    25% {
      -webkit-mask: url(//resources/ash/common/network/cellular_1.svg);
    }
    50% {
      -webkit-mask: url(//resources/ash/common/network/cellular_2.svg);
    }
    75% {
      -webkit-mask: url(//resources/ash/common/network/cellular_3.svg);
    }
    100% {
      -webkit-mask: url(//resources/ash/common/network/cellular_4.svg);
    }
  }
</style>
<template is="dom-if" if="[[showIcon_(networkState, hotspotInfo)]]" restamp>
  <div id="icon"
      class$="[[getIconClass_(networkState, deviceState, isListItem, hotspotInfo)]]">
  </div>
  <iron-icon id="technology"
      hidden="[[!showTechnology_(networkState, showTechnologyBadge, hotspotInfo)]]"
      icon="[[getTechnology_(networkState, hotspotInfo)]]">
  </iron-icon>
  <iron-icon id="secure" hidden="[[!showSecure_(networkState, hotspotInfo)]]"
      icon="network8:badge-secure">
  </iron-icon>
  <div id="roaming" hidden="[[!showRoaming_(networkState, hotspotInfo)]]"></div>
</template>
<!--_html_template_end_-->`;
}