import {html} from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
  return html`<!--_html_template_start_--><style include="network-shared">
  :host {
    display: block;
  }

  :host([allow-error-message]) #input {
    --cr-input-error-display: block;
    margin-bottom: 0;
  }

  #container {
    align-items: center;
    display: flex;
    flex-direction: row;
  }

  cr-input {
    flex: 1;
  }

  paper-tooltip {
    --paper-tooltip-min-width: 0px;
  }

  cr-policy-network-indicator-mojo {
    --cr-tooltip-icon-margin-start: var(--cr-controlled-by-spacing);
  }
</style>

<div id="container">
  <cr-input id="input" label="[[label]]" value="{{value}}"
      disabled="[[getDisabled_(disabled, property)]]"
      type="[[getInputType_(showPassword)]]"
      on-mousedown="onMousedown_"
      on-touchstart="onMousedown_"
      on-keydown="onKeydown_"
      invalid="[[invalid]]"
      readonly="[[readonly]]"
      aria-label="[[ariaLabel]]"
      error-message="[[errorMessage]]">
    <template is="dom-if" if="[[showPasswordIcon_(showPolicyIndicator_,
        managedProperties)]]" restamp>
      <div slot="suffix">
        <cr-icon-button id="icon"
            class$="[[getIconClass_(showPassword)]]"
            aria-describedby="passwordVisibilityTooltip"
            on-click="onShowPasswordTap_"
            on-touchend="onShowPasswordTap_">
        </cr-icon-button>
        <paper-tooltip id="passwordVisibilityTooltip"
            for="icon"
            position="[[tooltipPosition_]]"
            fit-to-visible-bounds role="tooltip">
          [[getShowPasswordTitle_(showPassword)]]
        </paper-tooltip>
      </div>
    </template>
  </cr-input>
  <template is="dom-if" if="[[showPolicyIndicator_]]" restamp>
    <cr-policy-network-indicator-mojo
        property="[[property]]" tooltip-position="left">
    </cr-policy-network-indicator>
  </template>
</div>
<!--_html_template_end_-->`;
}