import {html} from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
  return html`<!--_html_template_start_--><style include="network-shared cr-hidden-style iron-flex iron-flex-alignment md-select">
  network-proxy-input {
    margin-bottom: 10px;
  }

  network-proxy-exclusions {
    margin: 10px 0;
  }

  #addException {
    margin-top: 10px;
  }

  #manualProxy {
    padding-inline-start: var(--cr-section-padding);
  }

  #proxyType  {
    width: 320px;
  }

</style>

<!-- Proxy type dropdown -->
<div class="property-box">
  <div class="start">[[i18n('networkProxyConnectionType')]]</div>
  <select id="proxyType" class="md-select" on-change="onTypeChange_"
      value="[[proxy_.type.activeValue]]"
      disabled="[[!isEditable_('type', managedProperties, editable,
          useSharedProxies)]]"
      aria-label="[[i18n('networkProxyConnectionType')]]">
    <template is="dom-repeat" items="[[proxyTypes_]]">
      <option value="[[item]]">[[getProxyTypeDesc_(item)]]</option>
    </template>
  </select>
</div>

<!-- Autoconfiguration (PAC) -->
<div class="property-box indented"
    hidden$="[[!matches_(proxy_.type.activeValue, 'PAC')]]">
  <cr-input id="pacInput" class="flex"
      label="[[i18n('networkProxyAutoConfig')]]"
      value="{{proxy_.pac.activeValue}}" on-change="onPacChange_"
      disabled="[[!isEditable_('pac', managedProperties, editable,
          useSharedProxies)]]">
  </cr-input>
</div>

<!-- Web Proxy Auto Discovery (WPAD) -->
<div class="property-box indented"
    hidden$="[[!matches_(proxy_.type.activeValue, 'WPAD')]]">
  <div>[[i18n('networkProxyWpad')]]</div>
  <div class="middle">[[wpad_]]</div>
</div>

<!-- Manual -->
<div class="property-box indented"
    hidden$="[[!matches_(proxy_.type.activeValue, 'Manual')]]">
  <div id="networkProxyToggleLabel" class="flex">
    [[i18n('networkProxyUseSame')]]
  </div>
  <cr-toggle checked="{{useSameProxy_}}"
      disabled="[[!isEditable_('type', managedProperties, editable,
          useSharedProxies)]]"
      aria-labelledby="networkProxyToggleLabel">
  </cr-toggle>
</div>

<div id="manualProxy" class="layout vertical start"
    hidden$="[[!matches_(proxy_.type.activeValue, 'Manual')]]">
  <div hidden$="[[!useSameProxy_]]" class="layout vertical">
    <network-proxy-input
        id="sameProxyInput"
        on-proxy-input-change="onProxyInputChange_"
        editable="[[isEditable_('manual.httpProxy.host', managedProperties,
            editable, useSharedProxies)]]"
        value="{{proxy_.manual.httpProxy}}"
        label="[[i18n('networkProxy')]]">
    </network-proxy-input>
  </div>
  <div hidden$="[[useSameProxy_]]" class="layout vertical">
    <network-proxy-input
      id="httpProxyInput"
        on-proxy-input-change="onProxyInputChange_"
        editable="[[isEditable_('manual.httpProxy.host', managedProperties,
            editable, useSharedProxies)]]"
        value="{{proxy_.manual.httpProxy}}"
        label="[[i18n('networkProxyHttp')]]">
    </network-proxy-input>
    <network-proxy-input
        id="secureHttpProxyInput"
        on-proxy-input-change="onProxyInputChange_"
        editable="[[isEditable_('manual.secureHttpProxy.host',
            managedProperties, editable, useSharedProxies)]]"
        value="{{proxy_.manual.secureHttpProxy}}"
        label="[[i18n('networkProxyShttp')]]">
    </network-proxy-input>
    <network-proxy-input
        id="socksProxyInput"
        on-proxy-input-change="onProxyInputChange_"
        editable="[[isEditable_('manual.socks.host', managedProperties,
            editable, useSharedProxies)]]"
        value="{{proxy_.manual.socks}}"
        label="[[i18n('networkProxySocks')]]">
    </network-proxy-input>
  </div>

  <div hidden="[[!isEditable_('type', managedProperties, editable,
      useSharedProxies)]]">
    <div>[[i18n('networkProxyExceptionList')]]</div>
    <network-proxy-exclusions
        on-proxy-exclusions-change="onProxyExclusionsChange_"
        exclusions="{{proxy_.excludeDomains.activeValue}}"
        editable="[[isEditable_('excludeDomains', managedProperties,
            editable, useSharedProxies)]]">
    </network-proxy-exclusions>
    <div id="addException" class="layout horizontal center">
      <cr-input id="proxyExclusion" class="flex"
          value="{{proxyExclusionInputValue_}}"
          aria-label="[[i18n('networkProxyExceptionInputA11yLabel')]]"
          on-keypress="onAddProxyExclusionKeypress_">
        <cr-button id="proxyExclusionButton"
            on-click="onAddProxyExclusionClicked_"
            slot="suffix"
            disabled="[[shouldProxyExclusionButtonBeDisabled_(
                proxyExclusionInputValue_)]]">
          [[i18n('networkProxyAddException')]]
        </cr-button>
      </cr-input>
    </div>
  </div>

  <cr-button id="saveManualProxy"
      on-click="onSaveProxyClicked_" class="action-button"
      disabled="[[!isSaveManualProxyEnabled_(managedProperties,
          proxyIsUserModified_, proxy_.*)]]">
    [[i18n('save')]]
  </cr-button>
</div>
<!--_html_template_end_-->`;
}