import {html} from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
  return html`<!--_html_template_start_--><style include="network-shared cr-hidden-style iron-flex">
  #container {
    align-self: stretch;
    border: 1px solid lightgrey;
    height: 100px;
    margin-top: 10px;
    overflow-y: auto;
    padding: 5px;
  }

  cr-icon-button {
    --cr-icon-button-margin-end: 0;
  }
</style>
<div id="container">
  <template is="dom-repeat" items="[[exclusions]]">
    <div class="layout horizontal center">
      <div class="flex">[[item]]</div>
      <cr-icon-button class="icon-clear" hidden="[[!editable]]"
          title="[[i18n('networkProxyExceptionRemoveA11yLabel', item)]]"
          on-click="onRemoveTap_">
      </cr-icon-button>
    </div>
  </template>
</div>
<!--_html_template_end_-->`;
}