import {html} from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
  return html`<!--_html_template_start_--><style>
  :host {
    display: inline-flex;
    position: relative;
  }

  paper-progress {
    --paper-progress-active-color: var(--cros-icon-color-prominent);
    height: 1px;
    position: absolute;
    width: 100%;
  }

  #networkList {
    flex: 1;
  }
</style>
<template is="dom-if" if="[[showScanProgress]]" restamp>
  <paper-progress indeterminate hidden$="[[!isScanOngoing_]]">
  </paper-progress>
</template>
<network-list id="networkList"
    on-selected="onNetworkListItemSelected_"
    networks="[[networkStateList_]]" custom-items="[[customItems]]"
    show-buttons="[[showButtons]]"
    show-technology-badge="[[showTechnologyBadge]]"
    no-bottom-scroll-border="[[noBottomScrollBorder]]"
    activation-unavailable="[[activationUnavailable]]"
    device-state="[[cellularDeviceState_]]"
    global-policy="[[globalPolicy_]]">
</network-list>
<!--_html_template_end_-->`;
}