import {html} from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
  return html`<!--_html_template_start_--><style include="cr-shared-style">
  :host {
    align-items: center;
    background: var(--navigation-view-panel-bg-color);
    display: flex;
    height: var(--navigation-view-panel-toolbar-height, 56px);
    width: 100%;
  }

  :host-context(body.jelly-enabled) #title {
    font: var(--cros-title-1-font);
  }

  :host([is-narrow]) #leftContent {
    padding-inline-start: 14px;
  }

  :host([is-narrow]) #title {
    margin-inline-start: 8px;
  }

  :host(:not([is-narrow])) #leftContent {
    padding-inline-start: 20px;
  }

  :host([has-search][is-narrow]) #container {
    grid-template-columns: 0 1fr;
  }

  :host([has-search][is-narrow]) #mainContent {
    margin-inline-start: 48px;
  }

  #leftContent {
    align-items: center;
    display: flex;
  }

  #title {
    color: var(--cros-text-color-secondary);
    font-family: Roboto;
    font-size: 16px;
    font-weight: 500;
    letter-spacing: 0.25px;
  }

  #container {
    display: grid;
    grid-template-columns: var(--columns-nav);
    margin-top:12px;
    width: 100%;
  }
</style>
<div id="container">
  <div id="leftContent">
    <template is="dom-if" if="[[isNarrow]]">
      <cr-icon-button id="menuButton" class="no-overlap"
          iron-icon="cr20:menu" on-click="onMenuTap_"
          aria-label="[[title]]"
          title="[[title]]">
      </cr-icon-button>
    </template>
    <h1 id="title" part="title"
        hidden="[[shouldHideTitle_(isNarrow, hasSearch)]]">
      [[title]]
    </h1>
  </div>
  <div id="mainContent"><slot name="toolbar-main"></slot></div>
</div>
<!--_html_template_end_-->`;
}