import {html} from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
  return html`<!--_html_template_start_--><style include="cr-shared-style cros-color-overrides">
  /**
    * It's important that buttons are square (have same height and width) so
    * paper-ripple looks nice
    */
  :host {
    --dark-primary-opacity: 0.87;
    --dark-secondary-opacity: 0.54;
    --pin-button-horizontal-margin: 12px;
    --pin-button-size: 48px;
    outline: none;
  }

  #root {
    align-items: center;
    display: flex;
    flex-direction: column;
    min-height: 0;
    user-select: none;
  }

  #rowsContainer {
    direction: ltr;
    display: flex;
    flex-direction: column;
  }

  .row {
    align-items: center;
    display: flex;
    flex-direction: row;
    margin-bottom: 8px;
    min-height: 0;
  }

  :host([enable-password]) #pinInputDiv {
    display: none;
  }

  .bottom-row {
    margin-bottom: 0;
  }

  #backspaceButton {
    --cr-icon-button-fill-color: var(--pin-keyboard-backspace-color,
                                      var(--cros-icon-color-primary));
    --cr-icon-button-size: 48px;
    --cr-icon-button-transition: none;
    height: var(--pin-button-size);
    margin: 0 var(--pin-button-horizontal-margin);
    opacity: var(--pin-keyboard-backspace-opacity, --dark-primary-opacity);
    width: var(--pin-button-size);
  }

  :host-context(.jelly-enabled) #backspaceButton {
    --cr-icon-button-fill-color: var(--cros-sys-on_surface);
  }

  #backspaceButton[disabled] {
    opacity: 0.34;
  }

  .digit-button {
    align-items: center;
    border: 0;
    box-shadow: none;
    box-sizing: border-box;
    display: flex;
    flex-direction: column;
    font-weight: 400;
    height: var(--pin-button-size);
    margin: 0 var(--pin-button-horizontal-margin);
    min-height: 0;
    min-width: 0;
    opacity: 0.87;
    padding: 0;
    width: var(--pin-button-size);

    --ink-color: var(--cros-ripple-color);
    --paper-ripple-opacity: 1;
  }

  :host-context(.jelly-enabled) cr-button.digit-button {
    --ink-color: var(--cros-sys-ripple_neutral_on_subtle);
  }

  :host-context(.focus-outline-visible) .digit-button:focus {
    font-weight: 500;
  }

  .digit-button inner-text {
    font-family: 'Roboto';
  }

  :host-context(.jelly-enabled) .digit-button inner-text {
    font-family: var(--cros-display-6-font-family);
    font-size: var(--cros-display-6-font-size);
    font-weight: var(--cros-display-6-font-weight);
    line-height: var(--cros-display-6-line-height);
  }

  /* TODO(https://crbug.com/1307255): Figure out how to use variables of the
                                      cr-button component to add hovering
                                      effect */
  cr-button {
    background-color: var(--cros-icon-button-background-color);
    border-radius: 50%;
  }

  :host-context(.jelly-enabled) cr-button.digit-button {
    background-color: var(--cros-sys-surface3);
  }

  cr-button:hover {
    background-color: var(--cros-highlight-color-focus);
  }

  :host-context(.jelly-enabled) cr-button.digit-button:hover {
    background-color: var(--cros-sys-hover_on_subtle);
  }

  cr-icon-button#backspaceButton {
    background-color: var(--cros-icon-button-background-color);
    border-radius: 50%;
  }

  cr-icon-button#showPinButton {
    --cr-icon-button-icon-size: 20px;
    --cr-icon-button-size: 32px;
    --cr-icon-button-margin-start: 0;
    --cr-icon-button-margin-end: 0;
  }

  :host-context(.jelly-enabled) cr-icon-button#backspaceButton {
    background-color: var(--cros-sys-surface3);
  }

  cr-icon-button#backspaceButton:hover {
    background-color: var(--cros-highlight-color-focus);
  }

  :host-context(.jelly-enabled) cr-icon-button#backspaceButton:hover {
    background-color: var(--cros-sys-hover_on_subtle);
  }

  inner-text.letter {
    color: var(--pin-keyboard-letter-color,
                var(--cros-text-color-secondary));
    font-size: 12px;
  }

  /**
    * This is needed to align button "1" without text similar to the
    * buttons with text
    */
  inner-text.letter.empty {
    visibility: hidden;
  }

  .number {
    color: var(--pin-keyboard-number-color, var(--cros-text-color-primary));
    font-size: 20px;
  }

  :host-context(.jelly-enabled) .number {
    color: var(--cros-sys-on_surface);
  }

  #pinInput::part(input) {
    font-size: 18px;
  }

  #pinInput {
    --cr-input-error-display: none;
    --cr-input-letter-spacing: var(--pin-keyboard-input-letter-spacing,
                                    18px);
    --cr-input-padding-end: 0;
    --cr-input-padding-start: 0;
    --cr-search-field-placeholder-color:
        var(--cros-textfield-input-color-disabled);
    background-color: var(--cros-textfield-background-color);
    border: 0;
    box-sizing: border-box;
    color: var(--cros-textfield-input-color);
    font-face: Roboto-Regular;
    font-size: 13px;
    left: 0;
    opacity: var(--dark-secondary-opacity);
    outline: 0;
    position: relative;
    text-align: center;
    margin-top: 8px;
    width: var(--pin-keyboard-pin-input-width, 200px);
  }

  #pinInput[make-contrast] {
    opacity: var(--dark-primary-opacity);
  }

  #pinInput[is-input-rtl] {
    direction: rtl;
  }

  :host-context(.jelly-enabled) cr-input#pinInput {
    --cr-input-background-color: var(--cros-sys-input_field_on_shaded);
  }

  /* Ensure that all children of cr-button do not consume events. This
    * simplifies the event handler code. */
  cr-button * {
    pointer-events: none;
  }
</style>

<div id="root" on-click="onRootClick_">
  <div id="pinInputDiv">
    <cr-input
        id="pinInput"
        type="[[getPinInputType(isPinVisible_)]]"
        value="{{value}}"
        is-input-rtl$="[[isInputRtl_(value)]]" aria-label="[[ariaLabel]]"
        make-contrast$="[[hasInputOrFocus_(value, focused_)]]"
        invalid="[[hasError]]"
        placeholder="[[getInputPlaceholder_(enablePassword,
            enablePlaceholder)]]" inputmode="none"
        on-keydown="onInputKeyDown_" force-underline="true"
        disabled="[[disabled]]">
        <cr-icon-button id="showPinButton" slot="inline-suffix"
        hidden="[[!enableVisibilityIcon]]"
        title="[[getShowHideButtonLabel(isPinVisible_)]]"
        iron-icon="[[getShowHideButtonIcon(isPinVisible_)]]"
        on-click="onPinShowHideButtonClick"></cr-icon-button>
    </cr-input>
    <slot select="[problem]"></slot>
  </div>
  <div id="rowsContainer">
    <div class="row">
      <cr-button class="digit-button" on-click="onNumberClick_" value="1"
          id="digitButton1" disabled="[[disabled]]" circle-ripple
          custom-tab-index="-1">
        <inner-text class="number">[[i18n('pinKeyboard1')]]</inner-text>
      </cr-button>
      <cr-button class="digit-button" on-click="onNumberClick_" value="2"
          id="digitButton2" disabled="[[disabled]]" circle-ripple
          custom-tab-index="-1">
        <inner-text class="number">[[i18n('pinKeyboard2')]]</inner-text>
      </cr-button>
      <cr-button class="digit-button" on-click="onNumberClick_" value="3"
          id="digitButton3" disabled="[[disabled]]" circle-ripple
          custom-tab-index="-1">
        <inner-text class="number">[[i18n('pinKeyboard3')]]</inner-text>
      </cr-button>
    </div>
    <div class="row">
      <cr-button class="digit-button" on-click="onNumberClick_" value="4"
          id="digitButton4" disabled="[[disabled]]" circle-ripple
          custom-tab-index="-1">
        <inner-text class="number">[[i18n('pinKeyboard4')]]</inner-text>
      </cr-button>
      <cr-button class="digit-button" on-click="onNumberClick_" value="5"
          id="digitButton5" disabled="[[disabled]]" circle-ripple
          custom-tab-index="-1">
        <inner-text class="number">[[i18n('pinKeyboard5')]]</inner-text>
      </cr-button>
      <cr-button class="digit-button" on-click="onNumberClick_" value="6"
          id="digitButton6" disabled="[[disabled]]" circle-ripple
          custom-tab-index="-1">
        <inner-text class="number">[[i18n('pinKeyboard6')]]</inner-text>
      </cr-button>
    </div>
    <div class="row">
      <cr-button class="digit-button" on-click="onNumberClick_" value="7"
          id="digitButton7" disabled="[[disabled]]" circle-ripple
          custom-tab-index="-1">
        <inner-text class="number">[[i18n('pinKeyboard7')]]</inner-text>
      </cr-button>
      <cr-button class="digit-button" on-click="onNumberClick_" value="8"
          id="digitButton8" disabled="[[disabled]]" circle-ripple
          custom-tab-index="-1">
        <inner-text class="number">[[i18n('pinKeyboard8')]]</inner-text>
      </cr-button>
      <cr-button class="digit-button" on-click="onNumberClick_" value="9"
          id="digitButton9" disabled="[[disabled]]" circle-ripple
          custom-tab-index="-1">
        <inner-text class="number">[[i18n('pinKeyboard9')]]</inner-text>
      </cr-button>
    </div>
    <div class="row bottom-row">
      <cr-icon-button id="backspaceButton"
          disabled$="[[!hasInput_(value)]]"
          iron-icon="pin-keyboard:backspace"
          on-click="onBackspaceClick_"
          on-pointerdown="onBackspacePointerDown_"
          on-pointerout="clearAndReset_"
          on-pointerup="onBackspacePointerUp_"
          on-contextmenu="onBackspaceContextMenu_"
          title="[[i18n('pinKeyboardDeleteAccessibleName')]]"
          custom-tab-index="-1">
      </cr-icon-button>
      <cr-button class="digit-button" on-click="onNumberClick_" value="0"
          id="digitButton0" disabled="[[disabled]]" circle-ripple
          custom-tab-index="-1">
        <inner-text class="number">[[i18n('pinKeyboard0')]]</inner-text>
      </cr-button>
      <div class="digit-button"></div>
    </div>
  </div>
</div>

<!-- TODO(crbug.com/40464949): Use i18n instead of string literals. Figure out
                             what i18n to use for keypad, ie, does 1 ABC make
                             sense in every scenario? -->
<!--_html_template_end_-->`;
}