// Copyright 2023 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import { assert } from 'chrome://resources/js/assert.js';
/**
 * @fileoverview defines the actions to change SeaPen state.
 */
export var SeaPenActionName;
(function (SeaPenActionName) {
    SeaPenActionName["BEGIN_SEARCH_SEA_PEN_THUMBNAILS"] = "begin_search_sea_pen_thumbnails";
    SeaPenActionName["BEGIN_LOAD_RECENT_SEA_PEN_IMAGES"] = "begin_load_recent_sea_pen_images";
    SeaPenActionName["BEGIN_LOAD_RECENT_SEA_PEN_IMAGE_DATA"] = "begin_load_recent_sea_pen_image_data";
    SeaPenActionName["BEGIN_LOAD_SELECTED_RECENT_SEA_PEN_IMAGE"] = "begin_load_selected_recent_sea_pen_image";
    SeaPenActionName["SET_THUMBNAIL_RESPONSE_STATUS_CODE"] = "set_thumbnail_response_status_code";
    SeaPenActionName["BEGIN_SELECT_SEA_PEN_THUMBNAIL"] = "begin_select_sea_pen_thumbnail";
    SeaPenActionName["CLEAR_CURRENT_SEA_PEN_QUERY"] = "clear_current_sea_pen_query";
    SeaPenActionName["CLEAR_SEA_PEN_THUMBNAILS"] = "clear_sea_pen_thumbnails";
    SeaPenActionName["CLEAR_SEA_PEN_THUMBNAILS_LOADING"] = "clear_sea_pen_thumbnails_loading";
    SeaPenActionName["END_SELECT_SEA_PEN_THUMBNAIL"] = "end_select_sea_pen_thumbnail";
    SeaPenActionName["BEGIN_SELECT_RECENT_SEA_PEN_IMAGE"] = "begin_select_recent_sea_pen_image";
    SeaPenActionName["END_SELECT_RECENT_SEA_PEN_IMAGE"] = "end_select_recent_sea_pen_image";
    SeaPenActionName["SET_CURRENT_SEA_PEN_QUERY"] = "set_current_sea_pen_query";
    SeaPenActionName["SET_SEA_PEN_THUMBNAILS"] = "set_sea_pen_thumbnails";
    SeaPenActionName["SET_RECENT_SEA_PEN_IMAGES"] = "set_recent_sea_pen_images";
    SeaPenActionName["SET_RECENT_SEA_PEN_IMAGE_DATA"] = "set_recent_sea_pen_image_data";
    SeaPenActionName["SET_SELECTED_RECENT_SEA_PEN_IMAGE"] = "set_selected_recent_sea_pen_image";
    SeaPenActionName["SET_SHOULD_SHOW_SEA_PEN_INTRODUCTION_DIALOG"] = "set_should_show_sea_pen_introduction_dialog";
    SeaPenActionName["SET_SHOULD_SHOW_SEA_PEN_FREEFORM_INTRODUCTION_DIALOG"] = "set_should_show_sea_pen_freeform_introduction_dialog";
    SeaPenActionName["DISMISS_SEA_PEN_ERROR_ACTION"] = "dismiss_sea_pen_error";
    SeaPenActionName["SET_SEA_PEN_FULLSCREEN_STATE"] = "set_sea_pen_fullscreen_state";
    SeaPenActionName["SET_SEA_PEN_TEXT_QUERY_HISTORY"] = "set_sea_pen_text_query_history";
})(SeaPenActionName || (SeaPenActionName = {}));
export function beginSearchSeaPenThumbnailsAction(query) {
    return {
        query: query,
        name: SeaPenActionName.BEGIN_SEARCH_SEA_PEN_THUMBNAILS,
    };
}
/**
 * Sets the currently searched Sea Pen query.
 */
export function setCurrentSeaPenQueryAction(query) {
    return { name: SeaPenActionName.SET_CURRENT_SEA_PEN_QUERY, query };
}
/**
 * Sets the generated thumbnails for the given prompt text.
 */
export function setSeaPenThumbnailsAction(query, thumbnails) {
    return { name: SeaPenActionName.SET_SEA_PEN_THUMBNAILS, query, thumbnails };
}
/**
 * Begins load recent sea pen images.
 */
export function beginLoadRecentSeaPenImagesAction() {
    return {
        name: SeaPenActionName.BEGIN_LOAD_RECENT_SEA_PEN_IMAGES,
    };
}
/**
 * Sets the recent sea pen images.
 */
export function setRecentSeaPenImagesAction(recentImages) {
    return {
        name: SeaPenActionName.SET_RECENT_SEA_PEN_IMAGES,
        recentImages,
    };
}
/**
 * Begins load the recent sea pen image data.
 */
export function beginLoadRecentSeaPenImageDataAction(id) {
    return {
        name: SeaPenActionName.BEGIN_LOAD_RECENT_SEA_PEN_IMAGE_DATA,
        id,
    };
}
/**
 * Sets the recent sea pen image data.
 */
export function setRecentSeaPenImageDataAction(id, data) {
    return {
        name: SeaPenActionName.SET_RECENT_SEA_PEN_IMAGE_DATA,
        id,
        data,
    };
}
/**
 * Begins selecting a recent Sea Pen image.
 */
export function beginSelectRecentSeaPenImageAction(id) {
    return {
        name: SeaPenActionName.BEGIN_SELECT_RECENT_SEA_PEN_IMAGE,
        id,
    };
}
/**
 * Ends selecting a recent Sea Pen image.
 */
export function endSelectRecentSeaPenImageAction(id, success) {
    return {
        name: SeaPenActionName.END_SELECT_RECENT_SEA_PEN_IMAGE,
        id,
        success,
    };
}
/**
 * Begins loading the selected recent Sea Pen image.
 */
export function beginLoadSelectedRecentSeaPenImageAction() {
    return { name: SeaPenActionName.BEGIN_LOAD_SELECTED_RECENT_SEA_PEN_IMAGE };
}
/**
 * Sets the selected recent Sea Pen image.
 * Key is the id of the thumbnail that was used to generate this image.
 */
export function setSelectedRecentSeaPenImageAction(key) {
    return {
        name: SeaPenActionName.SET_SELECTED_RECENT_SEA_PEN_IMAGE,
        key,
    };
}
export function setSeaPenTextQueryHistory(history) {
    return {
        name: SeaPenActionName.SET_SEA_PEN_TEXT_QUERY_HISTORY,
        history,
    };
}
export function setThumbnailResponseStatusCodeAction(thumbnailResponseStatusCode) {
    return {
        name: SeaPenActionName.SET_THUMBNAIL_RESPONSE_STATUS_CODE,
        thumbnailResponseStatusCode,
    };
}
export function beginSelectSeaPenThumbnailAction(thumbnail) {
    return {
        name: SeaPenActionName.BEGIN_SELECT_SEA_PEN_THUMBNAIL,
        thumbnail,
    };
}
export function endSelectSeaPenThumbnailAction(thumbnail, success) {
    return {
        name: SeaPenActionName.END_SELECT_SEA_PEN_THUMBNAIL,
        thumbnail,
        success,
    };
}
export function clearCurrentSeaPenQueryAction() {
    return { name: SeaPenActionName.CLEAR_CURRENT_SEA_PEN_QUERY };
}
export function clearSeaPenThumbnailsAction() {
    return { name: SeaPenActionName.CLEAR_SEA_PEN_THUMBNAILS };
}
export function clearSeaPenThumbnailsLoadingAction() {
    return { name: SeaPenActionName.CLEAR_SEA_PEN_THUMBNAILS_LOADING };
}
/**
 * Sets the boolean that determines whether to show the Sea Pen introduction
 * dialog.
 */
export function setShouldShowSeaPenIntroductionDialogAction(shouldShowDialog) {
    assert(typeof shouldShowDialog === 'boolean');
    return {
        name: SeaPenActionName.SET_SHOULD_SHOW_SEA_PEN_INTRODUCTION_DIALOG,
        shouldShowDialog,
    };
}
/**
 * Sets the boolean that determines whether to show the Sea Pen freeform
 * introduction dialog.
 */
export function setShouldShowSeaPenFreeformIntroductionDialogAction(shouldShowFreeformDialog) {
    assert(typeof shouldShowFreeformDialog === 'boolean');
    return {
        name: SeaPenActionName.SET_SHOULD_SHOW_SEA_PEN_FREEFORM_INTRODUCTION_DIALOG,
        shouldShowFreeformDialog,
    };
}
export function dismissSeaPenErrorAction() {
    return { name: SeaPenActionName.DISMISS_SEA_PEN_ERROR_ACTION };
}
/**
 * Enables/disables the fullscreen preview mode for wallpaper.
 */
export function setSeaPenFullscreenStateAction(state) {
    return { name: SeaPenActionName.SET_SEA_PEN_FULLSCREEN_STATE, state };
}
