import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_--><style include="common wallpaper sea-pen">:host{overflow:hidden}iron-list{width:100%}#seaPenImagesHeading{margin-top:10px;padding-top:14px}.thumbnail-item-container,.thumbnail-placeholder-container{box-sizing:border-box;height:240px;overflow:hidden;width:calc(100% / 2 - 0.5px)}.thumbnail-placeholder-container{padding:calc(var(--personalization-app-grid-item-spacing) / 2)}.thumbnail-placeholder{background-color:var(--personalization-app-grid-item-background-color);border-radius:var(--personalization-app-grid-item-border-radius);height:100%}.feedback-icon-container{align-items:flex-end;bottom:10px;display:flex;justify-content:flex-end;height:48px;position:absolute;right:10px;opacity:0;width:88px;z-index:2}.thumbnail-item-container:hover>.feedback-icon-container,.thumbnail-item-container:focus-within>.feedback-icon-container{opacity:1}sea-pen-image-loading{left:50%;position:absolute;top:50%;transform:translate(-50%,-50%);z-index:1}wallpaper-grid-item[aria-disabled='true']::part(image){filter:grayscale(80%)}.feedback-icon-container-inner{align-items:flex-end;background-color:var(--cros-bg-color);border-bottom-right-radius:var(--personalization-app-grid-item-border-radius);border-top-left-radius:24px;bottom:0;display:flex;gap:16px;height:36px;justify-content:flex-end;position:absolute;right:0;width:76px}div[class^="feedback-icon-container-shadow"]{height:12px;overflow:hidden;position:absolute;width:12px}div[class^="feedback-icon-container-shadow"]::before{border-bottom-right-radius:100%;bottom:0;box-shadow:0px 12px 0px 12px var(--cros-bg-color);content:'';height:100%;position:absolute;right:0;width:100%}.feedback-icon-container-shadow-left{bottom:0;right:76px}.feedback-icon-container-shadow-top{bottom:36px;right:0}wallpaper-grid-item[data-sea-pen-image],div.loading-placeholder{position:absolute}div.loading-placeholder{box-sizing:border-box;border:2px solid transparent;height:100%;padding:calc(var(--personalization-app-grid-item-spacing) / 2);width:100%}div.loading-placeholder sparkle-placeholder{border-radius:var(--personalization-app-grid-item-border-radius)}.sea-pen-image[aria-selected='true']::part(ironIcon){--iron-icon-height:24px;--iron-icon-width:24px;left:-4px;top:-4px}#historyTitle{color:var(--cros-sys-on_surface);display:flex;font:var(--cros-body-0-font);height:24px;margin-block-start:0;margin-block-end:0;padding:6px 10px 6px}#historyTooltip{--iron-icon-fill-color:var(--cros-sys-secondary);--iron-icon-stroke-color:var(--cros-sys-secondary);--iron-icon-width:16px;height:24px;margin-inline-start:4px}.query-history.wallpaper-collections-heading{cursor:pointer;font-weight:600;height:auto;margin:6px 10px;max-width:100%;overflow:hidden;padding:0;width:fit-content}iron-icon[icon^='personalization-shared:refresh']{transform:rotateY(180deg)}.illustration-container .zero-state-message{top:-25px}</style>
<p id="generatedImageText" hidden>
  [[i18n('seaPenAriaDescriptionGeneratedImage')]]
</p>
<template is="dom-if" if="[[showError_]]" restamp>
  <sea-pen-error thumbnail-response-status-code="[[thumbnailResponseStatusCode_]]"></sea-pen-error>
</template>
<template is="dom-if" if="[[!showError_]]" restamp>
  <template is="dom-if" if="[[shouldShowZeroState_(thumbnailsLoading_, thumbnails_)]]">
    <div class="illustration-container" aria-live="polite">
      <sea-pen-zero-state-svg></sea-pen-zero-state-svg>
      <p class="zero-state-message illustration-message">[[i18n('seaPenZeroStateMessage')]]</p>
    </div>
  </template>
  <template is="dom-if" if="[[shouldShowImageThumbnails_(thumbnailsLoading_, thumbnails_)]]" restamp>
    <template is="dom-if" if="[[shouldShowImagesHeading_(isSeaPenTextInputEnabled_, templateId)]]">
      <h2 id="seaPenImagesHeading" class="wallpaper-collections-heading">
        [[getPoweredByGoogleMessage_()]]
      </h2>
    </template>
    <template is="dom-if" if="[[!!latestTextQuery_]]">
      <h3 id="latestTextQueryHeading"
          class="wallpaper-collections-heading query-history"
          on-click="onLatestTextQueryClicked_"
          on-keypress="onLatestTextQueryClicked_"
          role="button"
          tabindex="0">
        [[latestTextQuery_]]
      </h3>
    </template>
    <iron-list id="grid"
        items="[[tiles_]]"
        grid
        aria-label$="[[i18n('seaPenFreeformResultsLabel')]]"
        aria-setsize$="[[tiles_.length]]"
        role="listbox">
      <template>
        <div class="thumbnail-item-container">
          <template
              is="dom-if"
              if="[[isThumbnailPendingSelected_(item, pendingSelected_)]]"
              restamp>
            <sea-pen-image-loading></sea-pen-image-loading>
          </template>
          <div class="loading-placeholder">
            <sparkle-placeholder index="[[index]]"
                active="[[thumbnailsLoading_]]">
            </sparkle-placeholder>
          </div>
          <p hidden id="latestTextQueryDescription">
            [[getAriaDescription_(item, currentSelected_, pendingSelected_)]]
          </p>
          <wallpaper-grid-item
              class="sea-pen-image fade-in-900ms"
              hidden$="[[!isTileVisible_(item, thumbnailsLoading_)]]"
              disabled="[[isThumbnailPendingSelected_(item, pendingSelected_)]]"
              index="[[index]]"
              data-sea-pen-image
              aria-describedby="generatedImageText latestTextQueryDescription latestTextQueryHeading"
              aria-posinset$="[[getAriaIndex_(index)]]"
              on-wallpaper-grid-item-selected="onThumbnailSelected_"
              role="option"
              selected="[[isThumbnailSelected_(item, currentSelected_, pendingSelected_)]]"
              src="[[item.image]]"
              tabindex$="[[tabIndex]]">
          </wallpaper-grid-item>
          <template
              is="dom-if"
              if="[[shouldShowThumbnailFeedback_(isManagedSeaPenFeedbackEnabled_, thumbnailsLoading_)]]"
              restamp>
            <div class="feedback-icon-container">
              <sea-pen-feedback
                  inherit-tab-index="[[tabIndex]]"
                  thumbnail="[[item]]"
                  on-selected-feedback-changed="onSelectedFeedbackChanged_">
              </sea-pen-feedback>
              <div class="feedback-icon-container-shadow-left"></div>
              <div class="feedback-icon-container-shadow-top"></div>
            </div>
          </template>
        </div>
      </template>
    </iron-list>
    <template is="dom-if" if="[[showHistory_]]" restamp>
      <h2 id="historyTitle" aria-describedby="historyTooltip">
        [[i18n('seaPenFreeformPreviousPrompts')]]
        <iron-icon
          role="tooltip"
          id="historyTooltip"
          title="[[i18n('seaPenFreeformPreviousPromptsTooltip')]]"
          icon="sea-pen:info">
      </iron-icon>
      </h2>
      <template as="queryHistoryEntry"
          index-as="queryHistoryIndex"
          is="dom-repeat"
          items="[[textQueryHistory_]]">
        <h3 id$="queryHistoryHeading[[queryHistoryIndex]]"
            class="wallpaper-collections-heading query-history"
            on-click="onHistoryPromptClicked_"
            on-keypress="onHistoryPromptClicked_"
            role="button"
            tabindex="0">
          [[queryHistoryEntry.query]]
        </h3>
        <iron-list id="historyGrid[[queryHistoryIndex]]"
            items="[[queryHistoryEntry.thumbnails]]"
            grid
            aria-label$="[[i18n('seaPenFreeformPreviousPrompts')]]"
            aria-setsize$="[[queryHistoryEntry.thumbnails.length]]"
            role="listbox">
          <template>
            <div class="thumbnail-item-container history-item">
              <template
                  is="dom-if"
                  if="[[isThumbnailPendingSelected_(item, pendingSelected_)]]"
                  restamp>
                <sea-pen-image-loading></sea-pen-image-loading>
              </template>
              <p hidden aria-hidden="true" id$="queryHistoryDescription[[queryHistoryIndex]]-[[index]]">
                [[getAriaDescription_(item, currentSelected_, pendingSelected_)]]
              </p>
              <wallpaper-grid-item
                  class="sea-pen-image fade-in-900ms"
                  disabled="[[isThumbnailPendingSelected_(item, pendingSelected_)]]"
                  index="[[index]]"
                  data-sea-pen-image
                  aria-describedby$="generatedImageText queryHistoryDescription[[queryHistoryIndex]]-[[index]] queryHistoryHeading[[queryHistoryIndex]]"
                  aria-posinset$="[[getAriaIndex_(index)]]"
                  on-wallpaper-grid-item-selected="onThumbnailSelected_"
                  role="option"
                  selected="[[isThumbnailSelected_(item, currentSelected_, pendingSelected_)]]"
                  src="[[item.image]]"
                  tabindex$="[[tabIndex]]">
              </wallpaper-grid-item>
              <template is="dom-if" if="[[isManagedSeaPenFeedbackEnabled_]]" restamp>
                <div class="feedback-icon-container">
                  <sea-pen-feedback
                      inherit-tab-index="[[tabIndex]]"
                      thumbnail="[[item]]"
                      on-selected-feedback-changed="onSelectedFeedbackChanged_">
                  </sea-pen-feedback>
                  <div class="feedback-icon-container-shadow-left"></div>
                  <div class="feedback-icon-container-shadow-top"></div>
                </div>
              </template>
            </div>
          </template>
        </iron-list>
      </template>
    </template>
  </template>
</template>
<!--_html_template_end_-->`;
}
