import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_--><template is="dom-if" if="[[isPersonalizationApp_]]">
  <svg xmlns="http://www.w3.org/2000/svg" width="512" height="236" viewBox="0 0 512 236" fill="none">
    <g clip-path="url(#clip0_2388_22281)">
    <path d="M0 0H512V236H0V0Z" fill="#8EA8FD" fill-opacity="0.3" />
    <g clip-path="url(#clip1_2388_22281)">
    <path d="M512 0H0V236H512V0Z" fill="var(--cros-sys-illo-color1-2)" />
    <rect x="73" y="37.8397" width="253.541" height="253.541" rx="12" transform="rotate(-24.9224 73 37.8397)" fill="var(--cros-sys-illo-base)" />
    <path d="M277.617 184.795C277.139 188.885 276.715 192.854 276.457 196.963C276.209 200.947 275.928 204.804 275.504 208.773C275.143 211.997 274.718 215.466 273.672 217.881" stroke="var(--cros-sys-illo-color1)" stroke-width="3" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round" />
    <path d="M240.5 159C224.5 162.5 217.164 163.149 209 167.999C203.496 171.268 195.789 178.661 189 183.498C182.312 188.263 164.5 195 164.5 195C156 180 173.499 168.5 181.999 173C180 155.998 190.5 147 205.499 150C202 131 237.499 112 250.499 133.999C261.242 152.179 256.5 155.5 240.5 159Z" fill="var(--cros-sys-illo-color1)" />
    <path d="M228.125 147.864C227.81 150.25 223.265 152.951 220.516 148.937C217.767 144.922 221.801 140.104 224.393 141.923L228.125 147.864Z" fill="var(--cros-sys-illo-color1-1)" stroke="var(--cros-sys-illo-color1)" stroke-width="3" stroke-linecap="round" />
    <path d="M245.659 147.244C247.11 148.747 252.646 148.414 253.25 144.291C253.855 140.168 247.764 138.784 246.24 141.306L245.659 147.244Z" fill="var(--cros-sys-illo-color1-1)" stroke="var(--cros-sys-illo-color1)" stroke-width="3" stroke-linecap="round" />
    <path d="M246 157.5L243.433 147C243.433 147 241.401 150.13 237.875 150.63C234.35 151.129 232 149.074 232 149.074V160.5C232 160.5 234.536 160.61 238.733 159.444C242.93 158.279 246 157.5 246 157.5Z" fill="var(--cros-sys-illo-color1-1)" />
    <path d="M243.433 147L244.89 146.644L244.066 143.271L242.175 146.183L243.433 147ZM246 157.5L246.369 158.954L247.81 158.588L247.457 157.144L246 157.5ZM238.733 159.444L239.134 160.89L239.134 160.89L238.733 159.444ZM232 160.5H230.5V161.937L231.935 161.999L232 160.5ZM232 149.074L232.987 147.945L230.5 145.77V149.074H232ZM237.875 150.63L238.086 152.115L238.086 152.115L237.875 150.63ZM241.976 147.356L244.543 157.856L247.457 157.144L244.89 146.644L241.976 147.356ZM246 157.5C245.631 156.046 245.631 156.046 245.631 156.046C245.631 156.046 245.631 156.046 245.631 156.046C245.631 156.046 245.631 156.046 245.63 156.046C245.63 156.046 245.629 156.047 245.628 156.047C245.627 156.047 245.624 156.048 245.621 156.049C245.615 156.05 245.606 156.052 245.594 156.055C245.57 156.062 245.535 156.071 245.488 156.083C245.395 156.106 245.257 156.142 245.08 156.188C244.724 156.279 244.207 156.414 243.558 156.585C242.261 156.927 240.438 157.414 238.332 157.999L239.134 160.89C241.225 160.309 243.035 159.825 244.322 159.486C244.966 159.316 245.478 159.183 245.83 159.092C246.005 159.047 246.141 159.012 246.232 158.989C246.277 158.977 246.312 158.968 246.335 158.963C246.346 158.96 246.355 158.957 246.361 158.956C246.364 158.955 246.366 158.955 246.367 158.954C246.368 158.954 246.368 158.954 246.369 158.954C246.369 158.954 246.369 158.954 246.369 158.954C246.369 158.954 246.369 158.954 246.369 158.954C246.369 158.954 246.369 158.954 246 157.5ZM238.332 157.999C236.32 158.558 234.721 158.807 233.64 158.917C233.1 158.972 232.69 158.992 232.423 158.999C232.289 159.003 232.191 159.003 232.131 159.003C232.101 159.002 232.08 159.002 232.069 159.001C232.064 159.001 232.06 159.001 232.06 159.001C232.059 159.001 232.06 159.001 232.06 159.001C232.061 159.001 232.061 159.001 232.062 159.001C232.063 159.001 232.063 159.001 232.063 159.001C232.064 159.001 232.064 159.001 232.064 159.001C232.064 159.001 232.065 159.001 232 160.5C231.935 161.999 231.936 161.999 231.936 161.999C231.936 161.999 231.937 161.999 231.937 161.999C231.937 161.999 231.938 161.999 231.939 161.999C231.94 161.999 231.942 161.999 231.943 161.999C231.947 161.999 231.951 161.999 231.955 161.999C231.964 162 231.976 162 231.99 162C232.018 162.001 232.056 162.002 232.103 162.002C232.198 162.003 232.331 162.003 232.501 161.998C232.841 161.99 233.327 161.965 233.945 161.901C235.182 161.775 236.949 161.497 239.134 160.89L238.332 157.999ZM233.5 160.5V149.074H230.5V160.5H233.5ZM238.086 152.115C240.241 151.809 241.894 150.709 242.974 149.748C243.519 149.262 243.938 148.795 244.223 148.445C244.366 148.269 244.477 148.121 244.555 148.013C244.594 147.959 244.625 147.915 244.648 147.882C244.659 147.865 244.669 147.851 244.676 147.84C244.679 147.835 244.683 147.83 244.685 147.826C244.686 147.824 244.688 147.823 244.689 147.821C244.689 147.82 244.69 147.82 244.69 147.819C244.69 147.819 244.691 147.818 244.691 147.818C244.691 147.817 244.691 147.817 243.433 147C242.175 146.183 242.175 146.183 242.176 146.182C242.176 146.182 242.176 146.182 242.176 146.181C242.177 146.181 242.177 146.18 242.177 146.18C242.178 146.179 242.178 146.179 242.178 146.178C242.179 146.177 242.179 146.177 242.179 146.178C242.178 146.179 242.175 146.183 242.171 146.189C242.162 146.202 242.146 146.225 242.123 146.258C242.076 146.323 242.001 146.423 241.898 146.549C241.692 146.802 241.382 147.148 240.979 147.507C240.16 148.236 239.035 148.95 237.665 149.144L238.086 152.115ZM237.665 149.144C236.242 149.346 235.058 149.034 234.219 148.666C233.799 148.481 233.473 148.286 233.258 148.142C233.151 148.07 233.074 148.012 233.028 147.976C233.004 147.958 232.989 147.946 232.983 147.941C232.979 147.938 232.978 147.937 232.979 147.937C232.979 147.938 232.98 147.938 232.981 147.94C232.982 147.94 232.983 147.941 232.984 147.942C232.984 147.942 232.985 147.943 232.986 147.943C232.986 147.944 232.986 147.944 232.986 147.944C232.987 147.944 232.987 147.945 232 149.074C231.013 150.203 231.013 150.204 231.014 150.204C231.014 150.204 231.014 150.205 231.015 150.205C231.015 150.206 231.016 150.206 231.017 150.207C231.018 150.208 231.02 150.21 231.022 150.211C231.026 150.215 231.03 150.218 231.035 150.223C231.045 150.231 231.057 150.241 231.072 150.254C231.101 150.278 231.14 150.309 231.188 150.346C231.284 150.421 231.418 150.52 231.586 150.633C231.923 150.859 232.404 151.146 233.013 151.413C234.23 151.947 235.983 152.413 238.086 152.115L237.665 149.144Z" fill="var(--cros-sys-illo-color1)" />
    <circle cx="237" cy="139" r="12.5" fill="var(--cros-sys-illo-color1-1)" stroke="var(--cros-sys-illo-color1)" stroke-width="3" />
    <path d="M238 134.824C239.56 135.377 241.444 134.961 242.521 133.735" stroke="var(--cros-sys-illo-color1)" stroke-width="3" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round" />
    <path d="M245.5 157.43C245.5 157.43 267.48 152.149 281.298 157.429C295.116 162.709 304.904 174.039 304.904 174.039L284.177 196.734L277.844 188.521" stroke="var(--cros-sys-illo-color1)" stroke-width="3" />
    <path d="M232.6 161.997C233.426 161.941 234.052 161.227 233.997 160.4C233.942 159.574 233.227 158.948 232.4 159.003L232.6 161.997ZM189.904 182.519L188.782 181.524C188.351 182.011 188.282 182.72 188.612 183.28L189.904 182.519ZM208.096 213.426L206.803 214.187C207.187 214.838 207.996 215.103 208.69 214.803L208.096 213.426ZM216.055 209.992L217.508 209.619C217.399 209.194 217.11 208.838 216.716 208.645C216.322 208.452 215.863 208.441 215.461 208.614L216.055 209.992ZM220.603 227.734L219.15 228.107C219.347 228.877 220.112 229.36 220.893 229.206L220.603 227.734ZM232.5 160.5C232.4 159.003 232.4 159.003 232.399 159.003C232.399 159.003 232.399 159.003 232.398 159.003C232.398 159.003 232.397 159.003 232.396 159.003C232.394 159.004 232.392 159.004 232.389 159.004C232.383 159.004 232.376 159.005 232.367 159.006C232.348 159.007 232.323 159.009 232.29 159.012C232.224 159.017 232.13 159.025 232.008 159.037C231.763 159.061 231.407 159.1 230.945 159.161C230.021 159.283 228.674 159.492 226.951 159.843C223.504 160.545 218.553 161.816 212.473 164.095L213.527 166.904C219.447 164.684 224.246 163.455 227.549 162.782C229.201 162.446 230.479 162.248 231.336 162.135C231.765 162.079 232.088 162.044 232.301 162.023C232.407 162.013 232.486 162.006 232.536 162.002C232.561 161.999 232.579 161.998 232.589 161.997C232.595 161.997 232.598 161.997 232.6 161.997C232.601 161.996 232.601 161.996 232.601 161.996C232.601 161.996 232.601 161.996 232.601 161.996C232.601 161.996 232.6 161.997 232.6 161.997C232.6 161.997 232.6 161.997 232.5 160.5ZM212.473 164.095C206.226 166.438 200.293 170.828 195.972 174.562C193.798 176.439 192.007 178.173 190.758 179.439C190.133 180.072 189.642 180.59 189.307 180.95C189.139 181.131 189.009 181.272 188.921 181.369C188.877 181.418 188.843 181.456 188.82 181.482C188.808 181.495 188.799 181.505 188.793 181.512C188.789 181.515 188.787 181.518 188.785 181.52C188.784 181.521 188.784 181.522 188.783 181.523C188.783 181.523 188.782 181.523 188.782 181.524C188.782 181.524 188.782 181.524 189.904 182.519C191.027 183.514 191.027 183.514 191.027 183.514C191.027 183.514 191.027 183.514 191.027 183.514C191.027 183.514 191.027 183.514 191.027 183.513C191.028 183.512 191.03 183.511 191.032 183.508C191.037 183.503 191.044 183.495 191.053 183.484C191.073 183.463 191.103 183.43 191.143 183.385C191.223 183.297 191.344 183.165 191.502 182.994C191.82 182.653 192.29 182.157 192.893 181.546C194.099 180.324 195.832 178.647 197.933 176.832C202.159 173.181 207.774 169.062 213.527 166.904L212.473 164.095ZM188.612 183.28L206.803 214.187L209.389 212.665L191.197 181.758L188.612 183.28ZM208.69 214.803L216.649 211.369L215.461 208.614L207.502 212.048L208.69 214.803ZM214.602 210.364L219.15 228.107L222.056 227.362L217.508 209.619L214.602 210.364ZM220.893 229.206L273.194 218.904L272.614 215.96L220.313 226.263L220.893 229.206Z" fill="var(--cros-sys-illo-color1)" />
    <path d="M343.5 108C349 91 320 111 314 93C308 75 353.421 64.2644 334.948 38.6362C316.474 13.008 230.681 41.2026 228.051 78.6597C225.421 116.117 296.461 73.484 298.618 42.5708C303.478 -27.0867 79.4294 28.0422 92.9578 179.495" stroke="url(#paint0_linear_2388_22281)" stroke-width="10" stroke-linecap="round" />
    <path d="M319.971 128.451C319.797 122.034 321.357 117.693 323.406 111.5C324.329 108.709 326.664 106.431 329 110.5C330.692 113.447 330.142 114.088 329.735 117.241C329.445 119.493 333.381 115.056 335.907 120.738C337.17 119.475 340.326 117.581 342.22 126.42C342.22 126.42 344.115 122.633 348.534 124.527C352.954 126.42 353.585 128.946 352.322 131.471C351.06 133.997 347.271 132.103 347.271 132.103C347.271 132.103 345.377 137.785 346.009 142.204C346.64 146.624 347.271 151.675 346.64 157.357C346.009 163.04 340.326 170.616 340.326 170.616C340.326 170.616 339.063 187.031 337.169 195.239C335.275 203.446 325.805 216.705 311.283 214.811C296.762 212.917 285.405 196.499 285.405 196.499L305.405 175.5L309.905 178.5L316.335 161.777L314.44 137.154L319.971 128.451Z" fill="var(--cros-sys-illo-color1-1)" />
    <path d="M319.691 131.317C319.517 124.899 320.451 118.692 322.5 112.499C323.423 109.709 327.262 107.499 328.984 110.5C330.676 113.447 328.812 115.347 328.405 118.499C327.814 123.079 328.893 124.947 328.985 129.499" stroke="var(--cros-sys-illo-color1)" stroke-width="3" stroke-linecap="round" />
    <path d="M329.533 120.38C331.479 117.239 334.348 118.461 335.877 121.256C337.485 124.193 337.412 129.227 337.561 132.489C337.633 134.069 337.905 139.5 333.637 138.512C331.406 137.995 330.918 133.499 330.918 129.951" stroke="var(--cros-sys-illo-color1)" stroke-width="3" stroke-linecap="round" />
    <path d="M336.538 120.745C338.241 119.703 339.224 119.714 340.604 121.538C341.836 123.165 342.422 126.01 342.716 128.024C343.052 130.324 343.439 133.093 342.614 135.213C342.033 136.706 339.905 138 337.906 137" stroke="var(--cros-sys-illo-color1)" stroke-width="3" stroke-linecap="round" />
    <path d="M343.405 125.5C346.15 124 347.262 123.658 349.591 124.986C351.471 126.059 352.704 128.128 352.962 130.231C353.514 134.728 348.16 134.81 347.405 131.5" stroke="var(--cros-sys-illo-color1)" stroke-width="3" stroke-linecap="round" />
    <path d="M347.569 134.177C344.85 142.127 348.634 152.321 346.296 160.515C345.209 164.322 343.254 168.3 339.984 170.615C339.984 170.615 342.218 210.393 317.594 214.181C296.761 215.443 284.905 197.499 284.905 197.499" stroke="var(--cros-sys-illo-color1)" stroke-width="3" stroke-linecap="round" />
    <path d="M305.405 175L310.405 178.5" stroke="var(--cros-sys-illo-color1)" stroke-width="3" />
    <rect x="305" y="151.611" width="53.5843" height="7.0783" rx="3.53915" transform="rotate(-49.8277 305 151.611)" fill="var(--cros-sys-illo-color1)" />
    <path d="M314.6 146.627C314.849 151.271 314.859 156.027 315.961 160.56L330.514 158.619L330.518 158.488C330.628 155.334 330.707 153.049 329.269 150.367C328.182 148.34 325.185 146.777 324.345 144.715C322.487 140.15 324.448 134.974 323.494 130.237C322.825 126.919 319.645 128.304 318.169 130.125C314.568 134.566 314.317 141.344 314.6 146.627Z" fill="var(--cros-sys-illo-color1-1)" />
    <path d="M330.514 158.619C330.625 155.397 330.727 153.086 329.269 150.367C328.182 148.34 325.185 146.777 324.346 144.715C322.487 140.15 324.448 134.974 323.494 130.238C322.825 126.919 319.645 128.305 318.169 130.125C314.568 134.567 314.317 141.344 314.6 146.627C314.849 151.272 314.86 156.027 315.962 160.56L308.757 187.031" stroke="var(--cros-sys-illo-color1)" stroke-width="3" stroke-linecap="round" />
    <path d="M344.863 109.999L339.219 113.2C339.773 114.725 341.153 115.796 342.767 115.955L344.863 109.999Z" fill="var(--cros-sys-illo-color1-1)" stroke="var(--cros-sys-illo-color1-1)" stroke-width="3" stroke-linejoin="round" />
    <path d="M221.904 246V228.899L273.099 218.734L274.5 222L221.904 246Z" fill="var(--cros-sys-illo-color1)" stroke="var(--cros-sys-illo-color1)" stroke-width="3" stroke-linecap="round" />
    <path d="M111.203 182.622C118.766 186.378 126.759 189.372 134.908 191.63C134.908 191.63 156.905 195.5 162.405 195C167.905 194.5 188.905 183.574 188.905 183.574L203.905 207.999C203.905 207.999 186.905 219 167.905 221.999C148.905 224.999 120.405 224.999 120.405 224.999C120.405 224.999 102.906 233 94.9052 230C86.9049 226.999 111.203 220 111.203 220C111.203 220 86.4055 223 84.9049 220.5C82.4649 216.435 90.5508 214.244 93.4052 212.5L81.9055 210.5C81.9055 210.5 79.905 208.5 81.9055 207C83.906 205.5 95.9055 203 95.9055 203C93.229 202.703 81.1263 200.78 85.4053 196.5C87.905 193.999 113.592 191.792 113.592 191.792C110.783 190.826 108.038 189.354 105.749 187.396C104.662 186.439 103.48 185.047 103.79 183.574C104.216 182.147 105.633 181.24 107.081 181.275C108.598 181.47 109.91 181.851 111.203 182.622Z" fill="var(--cros-sys-illo-color1-1)" />
    <path d="M203.773 207.664C185.401 223.278 148.165 223.457 142.085 223.753C134.788 224.108 127.492 224.464 120.218 224.715C112.372 228.355 100.891 230.901 95.9053 230C94.3379 229.716 92.9053 229.5 92.9053 227.5C92.9053 225.5 114.276 221.005 113.405 219.5" stroke="var(--cros-sys-illo-color1)" stroke-width="3" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round" />
    <path d="M111.202 201.761C105.977 203.484 80.0244 203.451 80.7148 209.226C81.4053 215 103.61 209.551 112.905 210" stroke="var(--cros-sys-illo-color1)" stroke-width="3" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round" />
    <path d="M113.261 210.972C108.352 212.822 83.5133 213.011 84.6866 219.211C85.8599 225.412 105.302 218.584 113.024 219.063" stroke="var(--cros-sys-illo-color1)" stroke-width="3" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round" />
    <path d="M122.033 202.133C118.041 199.775 115.095 196.099 113.593 191.792C110.783 190.826 108.038 189.353 105.749 187.395C104.662 186.439 103.48 185.047 103.79 183.574C104.216 182.147 105.633 181.24 107.081 181.275C108.598 181.47 109.91 181.851 111.203 182.622C118.766 186.378 126.759 189.372 134.908 191.63C134.908 191.63 156.905 195.5 162.405 195C167.905 194.5 188.905 183.574 188.905 183.574" stroke="var(--cros-sys-illo-color1)" stroke-width="3" stroke-linecap="round" stroke-linejoin="round" />
    <path d="M112.446 192.617C105.069 192.122 98.0624 192.038 91.1411 194.112C89.0326 194.748 86.764 195.454 85.3768 197.303C84.3753 198.505 84.5257 200.157 85.7278 201.159C86.0984 201.57 86.6744 201.795 87.3405 201.79C88.7428 201.94 90.6683 201.699 91.9053 201.254C96.9084 200.16 106.423 200.828 110.905 201.254" stroke="var(--cros-sys-illo-color1)" stroke-width="3" stroke-linecap="round" stroke-linejoin="round" />
    <path fill-rule="evenodd" clip-rule="evenodd" d="M438.589 32.0815C438.589 34.9461 437.364 37.5247 435.409 39.3218C437.364 41.119 438.589 43.6975 438.589 46.5621C438.589 51.9927 434.186 56.395 428.756 56.395C428.01 56.395 427.284 56.3121 426.586 56.1549C425.048 59.5786 421.609 61.9628 417.612 61.9628C413.616 61.9628 410.177 59.5791 408.639 56.1559C407.942 56.3124 407.217 56.395 406.474 56.395C401.043 56.395 396.641 51.9927 396.641 46.5621C396.641 43.6975 397.866 41.119 399.82 39.3218C397.866 37.5247 396.641 34.9461 396.641 32.0815C396.641 26.6509 401.043 22.2486 406.474 22.2486C407.077 22.2486 407.669 22.303 408.242 22.4073C409.508 18.4392 413.224 15.5654 417.612 15.5654C422 15.5654 425.717 18.4397 426.982 22.4081C427.557 22.3033 428.15 22.2486 428.756 22.2486C434.186 22.2486 438.589 26.6509 438.589 32.0815Z" fill="var(--cros-sys-illo-color4)" />
    <circle cx="417.804" cy="38.9575" r="3.34165" fill="var(--cros-sys-illo-base)" />
    <path d="M387.113 84.9995C391.155 79.44 398.441 70.0844 406.725 70.1468C415.009 70.2092 421.674 76.9753 421.612 85.2593C421.55 93.5434 414.784 100.208 406.5 100.146C398.215 100.084 391.599 92.0335 387.113 84.9995Z" fill="var(--cros-sys-illo-color2)" />
    <circle cx="384" cy="67" r="5" fill="var(--cros-sys-illo-color3)" />
    <path d="M369.5 125.637C369.5 123.462 369.088 121.425 368.263 119.525C367.463 117.625 366.35 115.975 364.925 114.575C363.525 113.15 361.875 112.037 359.975 111.237C358.075 110.412 356.038 110 353.863 110C356.038 110 358.075 109.6 359.975 108.8C361.875 107.975 363.525 106.862 364.925 105.462C366.35 104.037 367.463 102.375 368.263 100.475C369.088 98.575 369.5 96.5375 369.5 94.3625C369.5 96.5375 369.9 98.575 370.7 100.475C371.525 102.375 372.638 104.037 374.038 105.462C375.463 106.862 377.125 107.975 379.025 108.8C380.925 109.6 382.963 110 385.138 110C382.963 110 380.925 110.412 379.025 111.237C377.125 112.037 375.463 113.15 374.038 114.575C372.638 115.975 371.525 117.625 370.7 119.525C369.9 121.425 369.5 123.462 369.5 125.637Z" fill="var(--cros-sys-illo-color1)" />
    </g>
    </g>
    <defs>
    <linearGradient id="paint0_linear_2388_22281" x1="181.704" y1="44.0575" x2="358.915" y2="97.6433" gradientUnits="userSpaceOnUse">
    <stop stop-color="var(--cros-sys-illo-analog)" />
    <stop offset="1" stop-color="var(--cros-sys-illo-complement)" />
    </linearGradient>
    <clipPath id="clip0_2388_22281">
    <path d="M0 0H512V236H0V0Z" fill="var(--cros-sys-illo-base)" />
    </clipPath>
    <clipPath id="clip1_2388_22281">
    <rect width="512" height="236" fill="var(--cros-sys-illo-base)" />
    </clipPath>
    </defs>
    </svg>
</template>
<template is="dom-if" if="[[!isPersonalizationApp_]]">
  <svg xmlns="http://www.w3.org/2000/svg" width="512" height="236" viewBox="0 0 512 236" fill="none">
    <g clip-path="url(#clip0_2388_22241)">
    <path d="M0 0H512V236H0V0Z" fill="#8EA8FD" fill-opacity="0.3" />
    <g clip-path="url(#clip1_2388_22241)">
    <path d="M512 0H0V236H512V0Z" fill="var(--cros-sys-illo-color1-2)" />
    <rect x="115" y="37" width="282" height="172" rx="20" fill="var(--cros-sys-illo-base)" />
    <path fill-rule="evenodd" clip-rule="evenodd" d="M285.923 207H202.465L213.017 187.114C213.248 186.679 213.686 186.392 214.177 186.354L276.055 181.557C276.642 181.512 277.198 181.829 277.458 182.358C278.999 185.496 280.891 191.491 282.665 197.109L282.665 197.11L282.665 197.11L282.819 197.599C283.739 200.513 284.631 203.327 285.441 205.651C285.608 206.128 285.769 206.579 285.923 207Z" fill="var(--cros-sys-illo-color1)" />
    <path d="M144.706 158C158.062 149.522 181.879 133.201 198.842 120.546C248.808 83.2718 302.334 46.5 282.202 27.8189C262.069 9.13781 163.39 40.7894 130.334 61.4452" stroke="url(#paint0_linear_2388_22241)" stroke-width="10" stroke-linecap="round" />
    <path d="M250.775 63.971C250.775 63.971 263.463 61.0605 263.149 57.1839C262.788 53.5421 256.847 53.3082 248.126 58.9544C248.126 58.9544 253.96 49.4655 249.989 47.9567C246.018 46.4479 242.705 57.3643 242.705 57.3643C242.705 57.3643 244.806 45.1926 239.471 45.5863C234.511 45.9417 236.479 58.5393 236.479 58.5393C236.479 58.5393 232.453 45.8462 227.532 48.4203C222.611 50.9943 230.296 60.7062 230.296 60.7062C230.296 60.7062 216.787 44.1571 209.842 50.0809C204.774 54.5861 223.68 66.2131 223.68 66.2131C223.68 66.2131 204.062 57.4949 203.383 64.4625C202.612 70.6729 220.293 71.4656 220.293 71.4656C220.293 71.4656 198.628 72.8442 202.071 78.1627C204.863 82.475 217.692 79.4733 217.692 79.4733C217.692 79.4733 200.442 89.2131 205.149 94.3253C206.874 96.0645 212.63 95.3976 218.791 86.1051C218.791 86.1051 212.897 99.5089 217.195 101.214C223.408 103.719 228.496 86.0281 228.496 86.0281L250.775 63.971Z" fill="var(--cros-sys-illo-color1)" />
    <path d="M165.662 141.933C184.859 110.767 219.415 103.616 234.293 103.937C243.572 103.456 265.393 102.206 278.447 101.051C291.501 99.8969 313.322 118.526 322.601 127.985L332.68 112.594C341.159 114.358 358.692 118.078 360.996 118.847C363.876 119.809 361.956 145.3 356.677 159.248C351.397 173.196 340.839 184.74 322.601 181.373C308.011 178.679 291.245 160.05 284.686 151.072L278.447 182.335L214.616 187.144L213.656 181.373C212.536 192.595 205.689 215.906 187.259 219.369C168.83 222.832 158.143 211.193 155.103 204.94C150.624 196.924 146.464 173.1 165.662 141.933Z" fill="var(--cros-sys-illo-color1-2)" />
    <path d="M286.266 135.821C285.38 140.497 284.566 145.039 283.932 149.754C283.32 154.327 282.679 158.75 281.866 163.292C281.186 166.979 281.866 175.501 277.584 182.068L213.937 186.614" stroke="var(--cros-sys-illo-color1)" stroke-width="3" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round" />
    <path d="M252.017 101.284L249.896 89.3191C249.896 89.3191 247.306 92.6568 243.207 92.9274C239.107 93.1981 236.564 90.7052 236.564 90.7052L235.655 103.496C236.938 105.44 240.756 109.227 245.761 108.823C250.766 108.418 252.017 103.628 252.017 101.284Z" fill="var(--cros-sys-illo-color1-1)" stroke="var(--cros-sys-illo-color1)" stroke-width="3" />
    <path d="M257.039 80.712C256.462 88.8357 249.632 94.887 241.876 94.3358C234.12 93.7847 228.214 86.8283 228.792 78.7047C229.369 70.581 236.199 64.5297 243.955 65.0809C251.711 65.632 257.616 72.5884 257.039 80.712Z" fill="var(--cros-sys-illo-color1-1)" stroke="var(--cros-sys-illo-color1)" stroke-width="3" />
    <path d="M248.827 65.6144C245.106 73.11 234.504 79.6595 229.205 82.3376C227.489 72.7913 227.727 75.5829 229.392 68.0819C231.279 59.5843 248.827 65.6144 248.827 65.6144Z" fill="var(--cros-sys-illo-color1)" />
    <path d="M245.43 80.8105C247.183 81.5767 249.389 81.2511 250.731 79.9257" stroke="var(--cros-sys-illo-color1)" stroke-width="3" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round" />
    <path d="M320.925 128.52C321.481 129.134 322.43 129.181 323.044 128.625C323.658 128.069 323.704 127.12 323.148 126.506L320.925 128.52ZM250.94 102.186C251.176 103.667 251.176 103.667 251.176 103.667C251.176 103.667 251.176 103.667 251.177 103.667C251.177 103.667 251.178 103.667 251.179 103.667C251.182 103.667 251.186 103.666 251.191 103.665C251.202 103.663 251.22 103.661 251.243 103.657C251.29 103.65 251.361 103.639 251.455 103.625C251.643 103.598 251.923 103.557 252.287 103.508C253.014 103.411 254.075 103.278 255.399 103.141C258.047 102.867 261.74 102.574 265.913 102.5C274.316 102.353 284.441 103.101 291.945 106.509L293.185 103.778C285.046 100.081 274.359 99.3514 265.86 99.5009C261.582 99.5762 257.801 99.8761 255.089 100.157C253.733 100.298 252.642 100.434 251.887 100.535C251.51 100.586 251.217 100.628 251.017 100.657C250.917 100.672 250.84 100.684 250.787 100.692C250.761 100.696 250.741 100.699 250.727 100.701C250.72 100.702 250.714 100.703 250.71 100.704C250.709 100.704 250.707 100.704 250.706 100.705C250.705 100.705 250.705 100.705 250.704 100.705C250.704 100.705 250.704 100.705 250.94 102.186ZM291.945 106.509C299.576 109.975 306.817 115.461 312.183 120.125C314.858 122.449 317.049 124.555 318.57 126.077C319.331 126.838 319.923 127.452 320.323 127.875C320.523 128.086 320.675 128.249 320.777 128.359C320.827 128.414 320.865 128.455 320.89 128.482C320.902 128.495 320.912 128.505 320.917 128.512C320.92 128.515 320.922 128.517 320.924 128.519C320.924 128.519 320.925 128.52 320.925 128.52C320.925 128.52 320.925 128.52 320.925 128.52C320.925 128.52 320.925 128.52 322.037 127.513C323.148 126.506 323.148 126.506 323.148 126.505C323.148 126.505 323.147 126.505 323.147 126.505C323.146 126.504 323.145 126.503 323.144 126.502C323.142 126.499 323.139 126.496 323.136 126.492C323.128 126.484 323.117 126.472 323.103 126.456C323.074 126.425 323.033 126.38 322.978 126.321C322.869 126.203 322.709 126.032 322.501 125.812C322.084 125.371 321.473 124.738 320.693 123.957C319.132 122.395 316.889 120.24 314.151 117.86C308.692 113.115 301.198 107.417 293.185 103.778L291.945 106.509Z" fill="var(--cros-sys-illo-color1)" />
    <path d="M361.19 52.0154C356.637 58.0245 351.521 66.3788 349.314 73.4634L340.221 81.0404L333.655 113.701L344.768 118.929L360.443 118.929C360.443 118.929 366.666 116.83 369.478 110.851C372.291 104.871 373.486 99.1108 374.446 94.041C375.406 88.9712 376.147 91.3183 376.147 91.3183C376.147 91.3183 377.725 88.833 380.049 86.5422C382.374 84.2515 385.61 78.575 383.424 74.8708C381.237 71.1667 376.197 75.3619 376.197 75.3619C377.427 64.9865 373.266 65.8794 371.414 66.7889C370.773 59.6306 364.81 63.0143 365.97 60.6588C367.592 57.3629 368.433 56.8669 367.683 53.011C366.647 47.6887 363.242 49.3083 361.19 52.0154Z" fill="var(--cros-sys-illo-color1-1)" />
    <path d="M348.703 74.6201C350.91 67.5356 355.273 58.7791 359.827 52.77C361.879 50.0629 366.903 49.0794 367.666 53.0047C368.416 56.8606 365.667 58.2422 364.045 61.5382C361.689 66.3263 362.171 68.7735 360.571 73.7863" stroke="var(--cros-sys-illo-color1)" stroke-width="3" stroke-linecap="round" />
    <path d="M363.679 64.2864C366.98 61.5774 369.661 63.9858 370.291 67.6135C370.952 71.4269 368.992 76.9059 367.937 80.5288C367.426 82.284 365.696 88.3259 361.396 85.6516C359.148 84.253 357.901 82.5558 358.911 80.529" stroke="var(--cros-sys-illo-color1)" stroke-width="3" stroke-linecap="round" />
    <path d="M371.204 67.3023C373.456 66.7988 376.068 67.6576 376.897 70.1676C377.636 72.4073 376.354 76.0722 375.923 78.3842C375.431 81.0258 374.27 84.3892 372.575 86.4005C371.383 87.816 368.36 88.0143 366.546 86.1739" stroke="var(--cros-sys-illo-color1)" stroke-width="3" stroke-linecap="round" />
    <path d="M376.887 73.7048C377.26 72.6107 380.576 71.9116 382.204 74.299C383.859 76.1737 381.007 83.1725 380.11 85.7971C378.205 91.3754 372.898 89.9423 373.309 86.0401" stroke="var(--cros-sys-illo-color1)" stroke-width="3" stroke-linecap="round" />
    <path d="M376.368 90.1715C374.311 102.293 372.059 108.058 368.509 112.359C365.59 115.895 361.942 115.895 360.442 118.93" stroke="var(--cros-sys-illo-color1)" stroke-width="3" stroke-linecap="round" />
    <path d="M338.441 87.149C336.978 92.3217 335.214 97.5268 334.727 102.897L351.369 106.208L351.422 106.067C352.72 102.658 353.66 100.189 353.089 96.7178C352.657 94.0943 349.962 91.2657 349.814 88.6966C349.486 83.0096 360.585 82.6296 361.309 77.093C361.817 73.213 356.666 72.6734 354.372 74.1136C343.304 73.525 340.104 81.2648 338.441 87.149Z" fill="var(--cros-sys-illo-color1-1)" />
    <path d="M333.655 112.864C337.191 104.782 336.979 92.3214 338.441 87.1487C340.105 81.2645 341.838 75.4669 352.502 74.2228C357.59 73.6289 361.776 73.336 361.268 77.2161C360.543 82.7527 349.487 83.0093 349.815 88.6962C349.963 91.2653 352.657 94.094 353.089 96.7175C353.668 100.236 352.694 102.725 351.369 106.208" stroke="var(--cros-sys-illo-color1)" stroke-width="3" stroke-linecap="round" />
    <path d="M195.763 160.953L189.238 169.893C189.238 169.893 183.845 180.494 192.708 185.219C201.57 189.944 205.294 186.567 205.294 186.567L210.572 180.773C210.572 180.773 217.396 175.591 220.089 171.805C222.782 168.02 225.067 162.253 226.113 156.601C227.16 150.95 235.561 134.262 234.538 130.824C233.515 127.385 230.838 125.111 227.838 128.168C224.837 131.226 220.774 145.994 216.135 144.155C213.539 143.127 211.505 139.055 212.75 136.142C213.73 133.85 217.795 132.926 218.028 130.347C218.559 124.492 214.013 126.936 214.013 126.936C214.013 126.936 227.653 119.603 229.415 116.662C231.177 113.72 229.015 111.651 225.299 111.998C221.583 112.345 207.327 118.222 207.327 118.222C207.327 118.222 196.564 130.335 195.102 137.034C193.64 143.734 195.763 160.953 195.763 160.953Z" fill="var(--cros-sys-illo-color1-1)" />
    <path d="M217.354 145.119C217.354 145.119 217.548 145.182 219.452 144.324C221.356 143.467 223.32 140.951 224.603 136.927C225.886 132.902 226.031 130.643 229.212 128.058C232.393 125.474 234.959 128.389 234.515 132.818C234.311 134.858 230.942 141.294 228.223 148.379C225.038 156.678 227.696 155.061 224.215 163.841C220.734 172.62 219.173 172.471 215.68 175.512C212.188 178.552 210.35 181.769 210.35 181.769" stroke="var(--cros-sys-illo-color1)" stroke-width="3" stroke-linecap="round" stroke-linejoin="round" />
    <path d="M209.624 160.59C209.624 160.59 211.603 156.31 210.809 150.536C210.015 144.762 204.892 141.088 205.386 140.02C205.88 138.952 210.408 136.535 215.568 132.749C217.98 130.979 217.433 128.965 216.596 128.03C215.642 126.964 214.102 127.109 212.438 127.262C209.314 127.549 198.076 129.332 195.072 135.934C192.069 142.536 196.456 157.102 195.105 160.512C193.754 163.921 190.069 167.532 190.069 167.532" stroke="var(--cros-sys-illo-color1)" stroke-width="3" stroke-linecap="round" stroke-linejoin="round" />
    <path d="M196.627 132.853C196.627 132.853 202.451 124.001 204.245 122.616C206.04 121.23 213.98 117.788 217.749 118.376C221.517 118.963 220.929 122.732 219.319 123.719C217.708 124.706 212.353 127.22 212.353 127.22" stroke="var(--cros-sys-illo-color1)" stroke-width="3" stroke-linecap="round" stroke-linejoin="round" />
    <path d="M216.878 144.898C216.878 144.898 214.72 143.324 213.953 141.238C213.186 139.152 212.639 136.59 212.639 136.59" stroke="var(--cros-sys-illo-color1)" stroke-width="3" stroke-linecap="round" stroke-linejoin="round" />
    <path d="M200.246 128.216C200.246 128.216 206.069 119.364 207.864 117.978C209.659 116.593 217.599 113.151 221.367 113.738C225.136 114.326 226.06 118.925 221.367 120.946" stroke="var(--cros-sys-illo-color1)" stroke-width="3" stroke-linecap="round" stroke-linejoin="round" />
    <path d="M220.577 122.882C220.577 122.882 225.232 121.139 226.454 120.151C227.676 119.163 229.713 117.516 229.803 115.961C229.893 114.405 229.114 112.61 225.838 111.89C224.789 111.66 223.083 112.238 221.248 113.13" stroke="var(--cros-sys-illo-color1)" stroke-width="3" stroke-linecap="round" stroke-linejoin="round" />
    <path d="M235.658 103.266L225.343 104.904C188.849 109.727 171.334 128.414 161.599 148.223C151.865 168.032 145.787 198.956 160.59 212.148C172.577 222.831 198.45 226.426 212.007 189.732C213.37 186.043 214.272 181.293 212.007 180.552" stroke="var(--cros-sys-illo-color1)" stroke-width="3" stroke-linecap="round" />
    <path d="M211.237 180.986C211.237 180.986 203.121 192.377 192.296 183.263C185.894 177.872 187.358 171.674 190.193 167.324" stroke="var(--cros-sys-illo-color1)" stroke-width="3" stroke-linecap="round" />
    <path d="M190.195 166.409C190.195 166.409 187.209 165.88 181.056 169.826C174.904 173.772 168.812 177.973 164.739 186.374" stroke="var(--cros-sys-illo-color1)" stroke-width="3" stroke-linecap="round" />
    <path d="M327.323 180.635L327.323 179.135L327.323 180.635ZM361.437 131.554L362.918 131.789L361.437 131.554ZM360.439 119.831L361.652 118.948L361.254 118.402L360.582 118.337L360.439 119.831ZM334.16 112.864L335.3 111.89L335.049 111.596L334.686 111.46L334.16 112.864ZM322.037 129.029L320.835 128.131L320.835 128.131L322.037 129.029ZM309.423 155.992C309.142 156.771 309.546 157.63 310.325 157.911C311.105 158.192 311.964 157.788 312.245 157.008L309.423 155.992ZM282.73 150.871C286.351 156.617 292.828 164.383 300.675 170.728C308.492 177.048 317.888 182.135 327.323 182.135L327.323 179.135C318.905 179.135 310.175 174.551 302.561 168.395C294.978 162.264 288.719 154.748 285.268 149.271L282.73 150.871ZM327.323 182.135C333.489 182.135 338.55 181.1 342.738 178.934C346.941 176.759 350.157 173.498 352.713 169.225C357.762 160.783 360.317 148.211 362.918 131.789L359.955 131.319C357.335 147.859 354.838 159.828 350.139 167.685C347.82 171.562 344.988 174.391 341.359 176.269C337.716 178.155 333.162 179.135 327.323 179.135L327.323 182.135ZM362.918 131.789C363.507 128.074 365.129 123.725 361.652 118.948L359.226 120.713C361.785 124.229 360.649 126.938 359.955 131.319L362.918 131.789ZM360.582 118.337C356.653 117.96 351.23 117.47 346.261 116.464C343.778 115.961 341.457 115.338 339.522 114.557C337.564 113.767 336.136 112.869 335.3 111.89L333.019 113.838C334.31 115.35 336.253 116.474 338.4 117.339C340.569 118.215 343.087 118.882 345.665 119.404C350.818 120.448 356.408 120.951 360.296 121.324L360.582 118.337ZM334.686 111.46C332.898 110.789 331.37 111.594 330.256 112.683C329.172 113.742 328.189 115.32 327.255 116.996C325.304 120.497 323.399 124.7 320.835 128.131L323.238 129.927C325.96 126.285 328.097 121.648 329.875 118.456C330.806 116.785 331.61 115.554 332.352 114.829C333.063 114.134 333.401 114.182 333.633 114.269L334.686 111.46ZM320.835 128.131C320.088 129.13 319.2 130.891 318.272 132.957C317.325 135.067 316.278 137.632 315.222 140.338C313.109 145.751 310.937 151.788 309.423 155.992L312.245 157.008C313.762 152.798 315.921 146.798 318.017 141.429C319.065 138.743 320.091 136.23 321.009 134.185C321.947 132.097 322.715 130.626 323.238 129.927L320.835 128.131Z" fill="var(--cros-sys-illo-color1)" />
    <path d="M365.919 48.1707C365.919 45.1685 365.35 42.356 364.211 39.7333C363.107 37.1106 361.571 34.833 359.604 32.9005C357.671 30.9335 355.394 29.3978 352.771 28.2936C350.149 27.1548 347.336 26.5854 344.334 26.5854C347.336 26.5854 350.149 26.0332 352.771 24.9289C355.394 23.7901 357.671 22.2545 359.604 20.322C361.571 18.355 363.107 16.0601 364.211 13.4374C365.35 10.8148 365.919 8.00228 365.919 5C365.919 8.00228 366.471 10.8148 367.576 13.4374C368.714 16.0601 370.25 18.355 372.182 20.322C374.149 22.2545 376.444 23.7901 379.067 24.9289C381.69 26.0332 384.502 26.5854 387.504 26.5854C384.502 26.5854 381.69 27.1548 379.067 28.2936C376.444 29.3978 374.149 30.9335 372.182 32.9005C370.25 34.833 368.714 37.1106 367.576 39.7333C366.471 42.356 365.919 45.1685 365.919 48.1707Z" fill="var(--cros-sys-illo-color1)" />
    <path d="M337.959 41.7026L332.765 48.2992C332.11 49.1314 332.212 50.3718 332.993 51.0698L339.109 56.5396C339.89 57.238 341.054 57.1296 341.709 56.2975L346.902 49.7007C347.557 48.8686 347.455 47.6281 346.674 46.93L340.559 41.4602C339.778 40.762 338.614 40.8705 337.959 41.7026Z" fill="var(--cros-sys-illo-color5)" />
    <path d="M379.334 52.5C389.834 56.5 395.334 72 379.334 88C361.069 106.265 251.959 197.949 138.669 220.412C92.834 229.5 83.8362 212.556 101.311 192.5C110.489 181.966 125.785 169.886 143.834 158.5" stroke="url(#paint1_linear_2388_22241)" stroke-width="10" stroke-linecap="round" />
    </g>
    </g>
    <defs>
    <linearGradient id="paint0_linear_2388_22241" x1="107.113" y1="140.127" x2="415.568" y2="89.5557" gradientUnits="userSpaceOnUse">
    <stop stop-color="var(--cros-sys-illo-analog)" />
    <stop offset="0.494306" stop-color="var(--cros-sys-illo-muted)" />
    <stop offset="1" stop-color="var(--cros-sys-illo-complement)" />
    </linearGradient>
    <linearGradient id="paint1_linear_2388_22241" x1="106.707" y1="139.805" x2="416.198" y2="88.7541" gradientUnits="userSpaceOnUse">
    <stop stop-color="var(--cros-sys-illo-analog)" />
    <stop offset="0.494306" stop-color="var(--cros-sys-illo-muted)" />
    <stop offset="1" stop-color="var(--cros-sys-illo-complement)" />
    </linearGradient>
    <clipPath id="clip0_2388_22241">
    <path d="M0 0H512V236H0V0Z" fill="var(--cros-sys-illo-base)" />
    </clipPath>
    <clipPath id="clip1_2388_22241">
    <rect width="512" height="236" fill="var(--cros-sys-illo-base)" />
    </clipPath>
    </defs>
  </svg>
</template><!--_html_template_end_-->`;
}
