// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import { SeaPenObserverReceiver } from './sea_pen.mojom-webui.js';
import { setSeaPenTextQueryHistory, setSelectedRecentSeaPenImageAction } from './sea_pen_actions.js';
import { getSeaPenProvider } from './sea_pen_interface_provider.js';
import { getSeaPenStore } from './sea_pen_store.js';
let instance = null;
/**
 * Set up the observer to listen for SeaPen changes.
 */
function initSeaPenObserver(seaPenProvider, target) {
    const receiver = new SeaPenObserverReceiver(target);
    seaPenProvider.setSeaPenObserver(receiver.$.bindNewPipeAndPassRemote());
    return receiver;
}
export class SeaPenObserver {
    constructor() {
        this.receiver_ = initSeaPenObserver(getSeaPenProvider(), this);
    }
    static initSeaPenObserverIfNeeded() {
        if (!instance) {
            instance = new SeaPenObserver();
        }
    }
    onSelectedSeaPenImageChanged(id) {
        const store = getSeaPenStore();
        store.dispatch(setSelectedRecentSeaPenImageAction(id));
    }
    onTextQueryHistoryChanged(entries) {
        const store = getSeaPenStore();
        store.dispatch(setSeaPenTextQueryHistory(entries));
    }
}
