// Copyright 2023 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import { PolymerElement } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
import { I18nMixin } from 'chrome://resources/ash/common/cr_elements/i18n_mixin.js';
import { ListPropertyUpdateMixin } from 'chrome://resources/ash/common/cr_elements/list_property_update_mixin.js';
import { makeStoreClientMixin } from 'chrome://resources/ash/common/cr_elements/store_client/store_client.js';
import { Store } from 'chrome://resources/js/store.js';
import { seaPenReducer } from './sea_pen_reducer.js';
import { emptyState } from './sea_pen_state.js';
export class SeaPenStore extends Store {
    constructor() {
        super(emptyState(), seaPenReducer);
    }
}
let instance = null;
export function setSeaPenStore(store) {
    instance = store;
}
export function getSeaPenStore() {
    return instance || (instance = new SeaPenStore());
}
// SeaPenStoreInterface implements all public methods/properties of
// SeaPenStore, but concrete class types as used in makeStoreClientMixin also
// check private properties. This cast bypasses this.
const SeaPenStoreClientMixin = makeStoreClientMixin(getSeaPenStore);
export const WithSeaPenStore = I18nMixin(ListPropertyUpdateMixin(SeaPenStoreClientMixin(PolymerElement)));
