import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_--><style include="common cros-button-style sea-pen">#container{display:flex;flex-direction:column;height:auto;justify-content:center;margin-block-start:32px;padding-inline:40px;transition:height 300ms cubic-bezier(0,0,0,1)}#placeholder{height:40px}#template{align-items:start;color:var(--cros-text-color-primary);display:flex;flex-flow:row wrap;font:var(--cros-display-6_regular-font);justify-content:center;row-gap:8px}#template .unselected{border-bottom-color:var(--cros-text-color-disabled);color:var(--cros-text-color-disabled)}.chip-container{cursor:pointer;display:grid;grid-template-areas:'chip'}.chip-container[disabled]{cursor:text}.chip-container[disabled]>.chip-text{pointer-events:none}.template-text{padding:0 4px}.chip-text{border:2px solid transparent;border-radius:8px;bottom:2px;grid-area:chip;position:relative}.chip-text:hover{background-color:var(--cros-sys-hover_on_subtle)}.chip-text:focus-visible{background-color:var(--cros-sys-ripple_primary);outline:2px solid var(--cros-sys-focus_ring)}#thumbnailsLoadingText{color:var(--cros-sys-on_primary_container);font:var(--cros-annotation-1-font)}cr-button{font:var(--cros-button-2-font);padding:0px 12px}.dropdown-check{margin-inline-end:16px}button:not([aria-selected='true']) iron-icon.dropdown-check{visibility:hidden}button{font:var(--cros-button-2-font);padding:8px 32px 8px 16px}#freeformInfo{display:flex;flex-flow:row wrap;justify-content:center;padding-bottom:24px;white-space:pre}
</style>
<div id="container" class="main">
  <template is="dom-if" if="[[seaPenUseExptTemplateEnabled_]]">
    <div id="nextTemplate">Using the experimental theme (if available)</div>
  </template>
  <template is="dom-if" if="[[shouldShowOptions_(options_)]]"
      on-dom-change="onSeaPenOptionsDomChanged_">
    <sea-pen-options
        class="fade-in-200ms"
        options="[[options_]]"
        selected-chip="[[selectedChip_]]"
        selected-options="{{selectedOptions_}}"
        on-sea-pen-option-escape="onOptionSelectionDone">
    </sea-pen-options>
  </template>
  <div id="template">
    <template is="dom-repeat" items="[[templateTokens_]]" as="token">
      <template is="dom-if" if="[[isChip_(token)]]">
        <div class$="chip-container [[getChipClassName_(token, selectedChip_)]]"
            disabled$="[[thumbnailsLoading_]]">
          <template is="dom-if" if="[[!thumbnailsLoading_]]" restamp>
            <sea-pen-chip-text
                aria-label$="[[token.translation]]"
                aria-description$="[[getTemplateAriaLabel_(templateTokens_)]]"
                text-animation-enabled="[[shouldEnableTextAnimation(selectedChip_, token)]]"
                chip-text="[[token.translation]]"
                class="chip-text"
                tabindex="0"
                on-click="onClickChip_"
                on-keypress="onClickChip_"
                role="combobox">
              <span aria-hidden="true">[[token.translation]]</span>
            </sea-pen-chip-text>
          </template>
          <template is="dom-if" if="[[thumbnailsLoading_]]" restamp>
            <div class="chip-text">
              [[token.translation]]
            </div>
          </template>
        </div>
      </template>
      <template is="dom-if" if="[[!isChip_(token)]]">
        <div class$="template-text [[getTextClassName_(selectedChip_)]]">
          [[token]]
        </div>
      </template>
    </template>
  </div>
  <div id="searchButtons">
    <template is="dom-if" if="[[thumbnailsLoading_]]">
      <span id="thumbnailsLoadingText" aria-description$="[[getTemplateAriaLabel_(templateTokens_)]]" aria-live="polite">
        [[i18n('seaPenThumbnailsLoading')]]
      </span>
    </template>
    <template is="dom-if" if="[[!thumbnailsLoading_]]" restamp>
      <cr-button
          id="inspire"
          on-click="onClickInspire_"
          on-mouseleave="stopInspireIconAnimation_"
          on-mouseenter="startInspireIconAnimation_">
        <cros-lottie-renderer
            id="inspireMeAnimation"
            slot="prefix-icon"
            asset-url="chrome://resources/ash/common/sea_pen/lightbulb_icon.json"
            loop
            autoplay="[[autoplay_]]"
            dynamic
            aria-hidden>
        </cros-lottie-renderer>
        <iron-icon id="inspireIcon" icon="sea-pen:inspire" slot="prefix-icon"></iron-icon>
        <p>[[i18n('seaPenInspireMeButton')]]</p>
      </cr-button>
      <cr-button
          id="searchButton"
          class="action-button"
          on-click="onClickSearchButton_">
        <iron-icon icon$="[[searchButtonIcon_]]" slot="prefix-icon">
        </iron-icon>
        <p>[[searchButtonText_]]</p>
      </cr-button>
    </template>
  </div>
  <template is="dom-if" if="[[shouldShowFreeformNavigationInfo_(thumbnailsLoading_)]]">
    <div id="freeformInfo"
        inner-h-t-m-l="[[i18nAdvanced('seaPenFreeformNavigationDescription')]]">
    </div>
  </template>
</div>
<!--_html_template_end_-->`;
}
