// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import { FakeMethodResolver } from '../fake_method_resolver.js';
export class FakeAcceleratorFetcher {
    constructor() {
        this.methods = new FakeMethodResolver();
        this.observers = [];
        this.methods.register('fakeMetaKeyToDisplay');
    }
    mockAcceleratorsUpdated(actionId, accelerators) {
        for (const observer of this.observers) {
            observer.onAcceleratorsUpdated(actionId, accelerators);
        }
    }
    observeAcceleratorChanges(_actionIds, observer) {
        this.observers.push(observer);
    }
    setMetaKeyToDisplay(metaKey) {
        this.methods.setResult('fakeMetaKeyToDisplay', metaKey);
    }
    getMetaKeyToDisplay() {
        return this.methods.resolveMethod('fakeMetaKeyToDisplay');
    }
}
