import '//resources/polymer/v3_0/iron-iconset-svg/iron-iconset-svg.js';
import {html} from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';

const template = html`<!-- TODO(dpad): Collapse with keyboard and shortcut customization app icons -->
<iron-iconset-svg name="shortcut-input-keys" size="24">
  <svg>
    <defs>
      <g id="accessibility" viewBox="0 0 20 20">
        <path
          d="M10 5.458a1.8 1.8 0 0 1-1.292-.52 1.787 1.787 0 0 1-.541-1.313c0-.5.18-.924.541-1.27A1.763 1.763 0 0 1 10 1.812c.5 0 .93.18 1.292.541.36.347.541.778.541 1.292 0 .5-.18.93-.541 1.292a1.8 1.8 0 0 1-1.292.52ZM7.417 17.812V8.376H3V6.708h14v1.667h-4.417v9.438h-1.646l-.187-4.646H9.27l-.207 4.646H7.417Z">
        </path>
      </g>
      <g id="arrow-down">
        <path d="M7.41 7.84L12 12.42l4.59-4.58L18 9.25l-6 6-6-6z">
      </g>
      <g id="arrow-left">
        <path d="M15.41 16.09l-4.58-4.59 4.58-4.59L14 5.5l-6 6 6 6z">
      </g>
      <g id="arrow-right">
        <path d="M8.59 16.34l4.58-4.59-4.58-4.59L10 5.75l6 6-6 6z">
      </g>
      <g id="arrow-up">
        <path d="M7.41 15.41L12 10.83l4.59 4.58L18 14l-6-6-6 6z">
      </g>
      <g id="assistant" viewBox="0 0 20 20">
        <path
          d="M6.36364 3C8.77382 3 10.7273 4.95418 10.7273 7.36364C10.7273 9.77309 8.77382 11.7273 6.36364 11.7273C3.95345 11.7273 2 9.77309 2 7.36364C2 4.95418 3.95345 3 6.36364 3Z">
        </path>
        <path
          d="M18 6.99997C18 7.60215 17.5113 8.09088 16.9091 8.09088C16.3069 8.09088 15.8182 7.60215 15.8182 6.99997C15.8182 6.39778 16.3069 5.90906 16.9091 5.90906C17.5113 5.90906 18 6.39778 18 6.99997Z">
        </path>
        <path
          d="M15.8182 9.54547C15.8182 10.7506 14.8414 11.7273 13.6363 11.7273C12.4313 11.7273 11.4545 10.7506 11.4545 9.54547C11.4545 8.34037 12.4313 7.36365 13.6363 7.36365C14.8414 7.36365 15.8182 8.34037 15.8182 9.54547Z">
        </path>
        <path
          d="M13.6363 17.5455C15.0422 17.5455 16.1818 16.4059 16.1818 15C16.1818 13.5942 15.0422 12.4546 13.6363 12.4546C12.2305 12.4546 11.0909 13.5942 11.0909 15C11.0909 16.4059 12.2305 17.5455 13.6363 17.5455Z">
        </path>
      </g>
      <g id="back">
        <path d="M20 11H7.83l5.59-5.59L12 4l-8 8 8 8 1.41-1.41L7.83 13H20v-2z">
      </g>
      <g id="brightness-up-refresh" viewBox="0 0 20 20">
        <g clip-path="url(#a)">
          <path d="m10 18.688 2.52-2.521h3.647V12.52l2.52-2.52-2.52-2.52V3.832H12.52L10 1.313l-2.52 2.52H3.832V7.48L1.313 10l2.52 2.52v3.647H7.48l2.52 2.52Zm0-4.75c-1.097 0-2.028-.382-2.792-1.146-.764-.778-1.146-1.709-1.146-2.792 0-1.097.39-2.028 1.167-2.792.764-.764 1.688-1.146 2.771-1.146 1.097 0 2.028.39 2.792 1.167.764.764 1.146 1.688 1.146 2.771 0 1.097-.382 2.028-1.146 2.792-.778.764-1.709 1.146-2.792 1.146Zm0 2.312-1.813-1.813H5.563v-2.624L3.75 10l1.813-1.813V5.563h2.625L10 3.75l1.813 1.813h2.624v2.625L16.25 10l-1.813 1.813v2.624h-2.624L10 16.25Z"></path>
        </g>
        <defs>
          <clipPath id="a">
            <path d="M20 0H0v20h20z"></path>
          </clipPath>
        </defs>
      </g>
      <g id="camera-access-toggle" viewBox="0 0 20 20">
        <path d="M18 13.9792L15 10.9792V12.8542L13.5 11.3542V5.5H7.625L6.125 4H13.5C13.9167 4 14.2708 4.14583 14.5625 4.4375C14.8542 4.72917 15 5.08333 15 5.5V8.97917L18 5.97917V13.9792ZM16.7292 18.8125L1.16667 3.27083L2.22917 2.20833L17.7917 17.75L16.7292 18.8125ZM4.04167 4.04167L5.5 5.47917H4.5V14.5H13.5V13.4583L15 14.9583C14.8889 15.2361 14.7153 15.4792 14.4792 15.6875C14.2431 15.8958 13.9167 16 13.5 16H4.5C4.09722 16 3.74306 15.8542 3.4375 15.5625C3.14583 15.2708 3 14.9167 3 14.5V5.47917C3 5.11805 3.09722 4.8125 3.29167 4.5625C3.5 4.3125 3.75 4.13889 4.04167 4.04167Z"></path>
      </g>
      <g id="do-not-disturb" viewbox="0 0 20 20">
        <path d="M6 10.875h8v-1.75H6v1.75Zm4 7.292a8.205 8.205 0 0 1-3.188-.625 8.59 8.59 0 0 1-2.604-1.75 8.589 8.589 0 0 1-1.75-2.604A8.204 8.204 0 0 1 1.833 10c0-1.139.209-2.201.625-3.188a8.327 8.327 0 0 1 1.75-2.583 8.112 8.112 0 0 1 2.604-1.75c1-.43 2.063-.646 3.188-.646 1.139 0 2.201.216 3.188.646a7.88 7.88 0 0 1 2.583 1.75 7.82 7.82 0 0 1 1.75 2.604c.43.986.646 2.042.646 3.167a7.974 7.974 0 0 1-.646 3.188c-.417.986-1 1.854-1.75 2.604a8.262 8.262 0 0 1-2.604 1.75 8.053 8.053 0 0 1-3.167.625Zm0-1.73c1.792 0 3.313-.625 4.563-1.875 1.25-1.25 1.874-2.77 1.874-4.562 0-1.792-.625-3.313-1.875-4.563-1.25-1.25-2.77-1.875-4.562-1.875-1.792 0-3.313.626-4.563 1.876-1.25 1.25-1.875 2.77-1.875 4.562 0 1.792.626 3.313 1.876 4.563 1.25 1.25 2.77 1.874 4.562 1.874Z"></path>
      </g>
      <g id="display-brightness-down" viewbox="0 0 20 20">
        <path fill-rule="evenodd"
          d="M9.99982 4.13281L11.7889 5.87499H14.1285V8.15322L15.7799 9.76139L14.1285 11.5036V13.7818H11.7889L9.99982 15.39L8.34836 13.7818H6.00878V11.5036L4.21973 9.76139L6.00878 8.15322V5.87499H8.34836L9.99982 4.13281ZM9.99982 6.41105L8.89883 7.48315H7.66025V8.68928L6.5593 9.76139L7.66025 10.9675V12.0396H8.89883L9.99982 13.2457L11.2384 12.0396H12.3394V10.9675L13.5779 9.76139L12.3394 8.68928V7.48315H11.2384L9.99982 6.41105Z">
      </g>
      <g id="display-brightness-up" viewbox="0 0 20 20">
        <path fill-rule="evenodd"
          d="M10.0686 2.64844L12.2706 4.92667H15.2982V7.87497L17.5002 10.0192L15.2982 12.1634V15.2457H12.2706L10.0686 17.3899L7.72908 15.2457H4.70145V12.1634L2.49951 10.0192L4.70145 7.87497V4.92667H7.72908L10.0686 2.64844ZM10.0686 4.92667L8.2796 6.53484H6.4905V8.27701L4.70145 10.0192L6.4905 11.7614V13.5035H8.2796L10.0686 15.2457L11.7201 13.5035H13.5092V11.7614L15.2982 10.0192L13.5092 8.27701V6.53484H11.7201L10.0686 4.92667Z">
      </g>
      <g id="electronic-privacy-screen" viewbox="0 0 20 20">
        <path fill-rule="evenodd"
          d="M18 3V17H2V3H18ZM16 15H5.07314L15.0731 5H16V15ZM4 10.8284V13.2447L12.2447 5H9.82838L4 10.8284ZM6.99995 5L4 7.99995V5H6.99995Z">
      </g>
      <g id="forward">
        <path d="M12 4l-1.41 1.41L16.17 11H4v2h12.17l-5.58 5.59L12 20l8-8z">
      </g>
      <g id="fullscreen">
        <path d="M7 14H5v5h5v-2H7v-3zm-2-4h2V7h3V5H5v5zm12 7h-3v2h5v-5h-2v3zM14 5v2h3v3h2V5h-5z">
      </g>
      <g id="last-track" viewbox="0 0 20 20">
        <path fill-rule="evenodd" clip-rule="evenodd" d="M16 15L8 10L16 5V15Z"></path>
        <path d="M4 5H6V15H4V5Z"></path>
      </g>
      <g id="keyboard-brightness-down" viewbox="0 0 20 20">
        <path fill-rule="evenodd"
          d="M6.95442 14H13.0455C13.2262 14 13.3915 14.107 13.4723 14.2764L13.9495 15.2764C14.0674 15.5234 13.9718 15.8237 13.7361 15.9472C13.6698 15.9819 13.5968 16 13.5227 16H6.47721C6.21365 16 6 15.7761 6 15.5C6 15.4224 6.01725 15.3458 6.05038 15.2764L6.52759 14.2764C6.60842 14.107 6.77366 14 6.95442 14ZM6 8.37845L4.7111 9.55653L3.08636 8.06095L4.36619 6.88287L6 8.37845ZM3.45455 12V14H1V12H3.45455ZM11 5V7.22176H9V5H11ZM16.9136 8.06463L15.2838 9.56488L14 8.38312L15.6298 6.88287L16.9136 8.06463ZM16.5454 12H19V14H16.5454V12Z">
      </g>
      <g id="keyboard-brightness-toggle" viewbox="0 0 20 20">
        <path d="M 9.15049 2 L 10.8508 2 L 10.8508 7.03443 L 9.15049 7.03443 Z"></path>
        <path d="M 5.74972 12.0689 L 0.649957 12.0689 L 0.649957 10.3903 L 5.74972 10.3903 Z"></path>
        <path d="M 19.3501 12.0689 L 14.2503 12.0689 L 14.2503 10.3903 L 19.3501 10.3903 Z"></path>
        <path d="M 16.1818 3.7734 L 17.3838 4.95997 L 14.0176 8.28251 L 12.8156 7.09593 Z"></path>
        <path
          d="M 13.2192 15.6192 L 14.2571 16.6571 L 15.1208 17.5207 L 15.5999 18 L 16.7468 16.8545 L 11.9673 12.0698 L 12.5323 12.0698 L 12.5323 10.3913 L 10.2887 10.3899 L 3.28479 3.38476 L 2.138 4.52385 L 2.13032 4.53029 Z">
        </path>
      </g>
      <g id="keyboard-brightness-up" viewbox="0 0 20 20">
        <path fill-rule="evenodd"
          d="M6.95442 14H13.0455C13.2262 14 13.3915 14.107 13.4723 14.2764L13.9495 15.2764C14.0674 15.5234 13.9718 15.8237 13.7361 15.9472C13.6698 15.9819 13.5968 16 13.5227 16H6.47721C6.21365 16 6 15.7761 6 15.5C6 15.4224 6.01725 15.3458 6.05038 15.2764L6.52759 14.2764C6.60842 14.107 6.77366 14 6.95442 14ZM6 8.37845L4.7111 9.55653L1.08636 6.06095L2.36619 4.88287L6 8.37845ZM3.45455 12V14H0V12H3.45455ZM11 2V7.22176H9V2H11ZM18.9136 6.06463L15.2838 9.56488L14 8.38312L17.6298 4.88287L18.9136 6.06463ZM16.5454 12H20V14H16.5454V12Z">
      </g>
      <g id="launcher" viewbox="0 0 20 20">
        <path
          d="M10 15C12.7614 15 15 12.7614 15 10C15 7.23858 12.7614 5 10 5C7.23858 5 5 7.23858 5 10C5 12.7614 7.23858 15 10 15Z">
        </path>
        <path fill-rule="evenodd"
          d="M10 18.5C14.6944 18.5 18.5 14.6944 18.5 10C18.5 5.30558 14.6944 1.5 10 1.5C5.30558 1.5 1.5 5.30558 1.5 10C1.5 14.6944 5.30558 18.5 10 18.5ZM17 10C17 13.866 13.866 17 10 17C6.13401 17 3 13.866 3 10C3 6.13401 6.13401 3 10 3C13.866 3 17 6.13401 17 10Z">
        </path>
      </g>
      <g id="launcher-refresh" viewBox="0 0 20 20">
        <g clip-path="url(#a)">
          <path
            d="M10 16.517c-.9 0-1.75-.167-2.55-.5a6.662 6.662 0 0 1-2.067-1.4 6.662 6.662 0 0 1-1.4-2.067 6.57 6.57 0 0 1-.5-2.55c0-.9.167-1.744.5-2.533a6.662 6.662 0 0 1 1.4-2.067A6.3 6.3 0 0 1 7.45 4 6.38 6.38 0 0 1 10 3.483c.822 0 1.6.15 2.333.45.745.29 1.423.7 2.034 1.234l-1.85 1.8a3.886 3.886 0 0 0-1.167-.7A3.443 3.443 0 0 0 10 6c-1.089 0-2.017.394-2.783 1.183A3.932 3.932 0 0 0 6.083 10c0 1.1.378 2.039 1.134 2.817.766.777 1.694 1.166 2.783 1.166.922 0 1.711-.255 2.367-.766a3.11 3.11 0 0 0 1.216-1.984H10V8.817h6.117c.055.233.094.46.116.683.023.211.034.428.034.65 0 1.922-.578 3.467-1.734 4.633-1.144 1.156-2.655 1.734-4.533 1.734Z"></path>
        </g>
        <defs>
          <clipPath id="a">
            <path d="M0 0h20v20H0z"></path>
          </clipPath>
        </defs>
      </g>
      <g id="microphone-mute" viewbox="0 0 20 20">
        <path
          d="M 15.4894 8.94314 L 13.9775 8.94314 C 13.9775 9.69794 13.8293 10.3021 13.5269 10.9057 L 14.5823 11.9623 C 15.187 11.2075 15.4894 10.1509 15.4894 8.94314 Z M 2.96096 2.6036 L 1.90551 3.66019 L 10.9595 12.7171 C 10.6572 12.7171 10.3548 12.8682 10.2065 12.8682 C 8.08988 12.8682 6.28133 11.0569 6.28133 8.94314 L 4.76949 8.94314 C 4.76949 11.6605 6.73206 13.9249 9.4477 14.3773 L 9.4477 16.7928 L 10.9595 16.7928 L 10.9595 14.3773 C 11.4102 14.3773 11.8666 14.2266 12.169 14.0754 L 16.0942 18 L 17.1496 16.9434 Z M 12.4714 8.94314 L 12.4714 4.26379 C 12.4714 2.9054 11.4102 2 10.2065 2 C 8.84865 2 7.94154 3.05659 7.94154 4.26379 L 7.94154 5.16975 L 12.4714 9.69794 C 12.3173 9.5473 12.4714 9.24551 12.4714 8.94314 Z">
        </path>
      </g>
      <g id="next-track" viewbox="0 0 20 20">
        <path fill-rule="evenodd" clip-rule="evenodd" d="M4 15L12 10L4 5V15Z"></path>
        <path d="M16 5H14V15H16V5Z"></path>
      </g>
      <g id="overview" width="20" height="20" viewbox="0 0 20 20">
        <path fill-rule="evenodd"
          d="M0.164062 15.3381H13.1281V4.65625H0.164062V15.3381ZM1.80029 6.28995H11.4919V13.7044H1.80029V6.28995ZM14.803 15.3381H16.4806V4.65625H14.803V15.3381ZM18.1583 4.65625H19.8359V15.3255H18.1583V4.65625Z">
      </g>
      <g id="overview-refresh" viewBox="0 0 20 20">
        <path d="M19.167 9V2.833H9V9h10.167Zm0 8.167V11H13v6.167h6.167ZM7 9V2.833H.834V9H7Zm4 8.167V11H.834v6.167H11Zm6.438-9.896H10.73V4.563h6.708V7.27Zm-12.167 0H2.563V4.563H5.27V7.27Zm4 8.167H2.563v-2.709H9.27v2.709Zm8.167 0H14.73v-2.709h2.708v2.709Z"></path>
      </g>
      <g id="play-pause" viewbox="0 0 20 20">
        <path fill-rule="evenodd" d="M3.53027 13.9683L10.1413 10.0017L3.53027 6.03516V13.9683Z"></path>
        <rect x="11.521" y="5.67969" width="2" height="8.28929"></rect>
        <rect x="14.5444" y="5.67969" width="2" height="8.28929"></rect>
      </g>
      <g id="power">
        <path
          d="M13 3h-2v10h2V3zm4.83 2.17l-1.42 1.42C17.99 7.86 19 9.81 19 12c0 3.87-3.13 7-7 7s-7-3.13-7-7c0-2.19 1.01-4.14 2.58-5.42L6.17 5.17C4.23 6.82 3 9.26 3 12c0 4.97 4.03 9 9 9s9-4.03 9-9c0-2.74-1.23-5.18-3.17-6.83z">
      </g>
      <g id="refresh">
        <path
          d="M17.65 6.35C16.2 4.9 14.21 4 12 4c-4.42 0-7.99 3.58-7.99 8s3.57 8 7.99 8c3.73 0 6.84-2.55 7.73-6h-2.08c-.82 2.33-3.04 4-5.65 4-3.31 0-6-2.69-6-6s2.69-6 6-6c1.66 0 3.14.69 4.22 1.78L13 11h7V4l-2.35 2.35z">
      </g>
      <g id="quick-insert" viewBox="0 0 20 20">
        <g clip-path="url(#a)">
          <path
            d="M9.167 13.042h1.666v-2.209h2.209V9.167h-2.209V6.958H9.167v2.209H6.958v1.666h2.209v2.209ZM10 18.167a1.68 1.68 0 0 1-.667-.125 1.992 1.992 0 0 1-.562-.375l-6.438-6.438a1.815 1.815 0 0 1-.396-.562A1.977 1.977 0 0 1 1.833 10c0-.25.035-.472.105-.667.083-.194.215-.375.395-.541l6.438-6.459c.18-.18.368-.305.562-.375.195-.083.417-.125.667-.125.25 0 .472.042.667.125.194.07.375.195.541.375l6.459 6.438c.18.18.305.368.375.562.083.195.125.417.125.667 0 .25-.042.472-.125.667-.07.194-.195.382-.375.562l-6.459 6.438a1.732 1.732 0 0 1-.541.375 1.68 1.68 0 0 1-.667.125Zm0-1.73L16.438 10 10 3.562 3.562 10 10 16.438Z"></path>
        </g>
        <defs>
          <clipPath id="a">
            <path d="M0 0h20v20H0z"></path>
          </clipPath>
        </defs>
      </g>
      <g id="screen-mirror" viewbox="0 0 20 20">
        <path fill-rule="evenodd" clip-rule="evenodd"
          d="M17.1327 12.0716H15.0166V10.5716H16.6327V5.28516H9.57471V5.97091H8.07471V4.78516C8.07471 4.23287 8.52242 3.78516 9.07471 3.78516H17.1327C17.685 3.78516 18.1327 4.23287 18.1327 4.78516V11.0716C18.1327 11.6239 17.685 12.0716 17.1327 12.0716ZM14.228 15.0129H13.5443V7.49229C13.5443 7.30349 13.4678 7.13257 13.344 7.00884C13.2203 6.88512 13.0494 6.80859 12.8606 6.80859H3.28888C2.91128 6.80859 2.60518 7.11469 2.60518 7.49229V15.0129H1.92149C1.54389 15.0129 1.23779 15.319 1.23779 15.6966C1.23779 16.0742 1.54389 16.3803 1.92149 16.3803H14.228C14.6056 16.3803 14.9117 16.0742 14.9117 15.6966C14.9117 15.319 14.6056 15.0129 14.228 15.0129ZM12.1769 8.17598V12.9618H3.97257V8.17598H12.1769ZM6.70735 15.0129V14.3292H9.44213V15.0129H6.70735Z">
        </path>
      </g>
      <g id="screenshot" viewBox="0 0 20 20">
        <path fill-rule="evenodd" clip-rule="evenodd"
          d="M7.96487 7.55109C8.52146 7.18893 9.17585 6.99562 9.84526 6.99562C10.7429 6.99562 11.6038 7.34288 12.2385 7.96098C12.8732 8.57908 13.2299 9.41741 13.2299 10.2915C13.2299 10.9434 13.0314 11.5806 12.6595 12.1226C12.2876 12.6646 11.759 13.0871 11.1405 13.3366C10.5221 13.586 9.8415 13.6513 9.18495 13.5241C8.52841 13.3969 7.92534 13.083 7.45199 12.6221C6.97865 12.1612 6.65632 11.5739 6.52572 10.9345C6.39513 10.2952 6.46214 9.6325 6.71831 9.03025C6.97448 8.428 7.40828 7.91325 7.96487 7.55109ZM11.1507 9.02033C10.8045 8.68318 10.3349 8.49376 9.84526 8.49376C9.35563 8.49376 8.88608 8.68318 8.53986 9.02033C8.19365 9.35747 7.99915 9.81474 7.99915 10.2915C7.99915 10.7683 8.19365 11.2256 8.53986 11.5627C8.88608 11.8999 9.35563 12.0893 9.84526 12.0893C10.3349 12.0893 10.8045 11.8999 11.1507 11.5627C11.4969 11.2256 11.6914 10.7683 11.6914 10.2915C11.6914 9.81474 11.4969 9.35747 11.1507 9.02033Z">
        </path>
        <path fill-rule="evenodd" clip-rule="evenodd" d="M2 4H18V16.7342H2V4ZM16 14.7866V5.94758H4.00002V14.7866H16Z">
        </path>
      </g>
      <g id="volume-down">
        <path d="M18.5 12c0-1.77-1.02-3.29-2.5-4.03v8.05c1.48-.73 2.5-2.25 2.5-4.02zM5 9v6h4l5 5V4L9 9H5z">
      </g>
      <g id="volume-mute">
        <path
          d="M16.5 12c0-1.77-1.02-3.29-2.5-4.03v2.21l2.45 2.45c.03-.2.05-.41.05-.63zm2.5 0c0 .94-.2 1.82-.54 2.64l1.51 1.51C20.63 14.91 21 13.5 21 12c0-4.28-2.99-7.86-7-8.77v2.06c2.89.86 5 3.54 5 6.71zM4.27 3L3 4.27 7.73 9H3v6h4l5 5v-6.73l4.25 4.25c-.67.52-1.42.93-2.25 1.18v2.06c1.38-.31 2.63-.95 3.69-1.81L19.73 21 21 19.73l-9-9L4.27 3zM12 4L9.91 6.09 12 8.18V4z">
      </g>
      <g id="volume-up">
        <path
          d="M3 9v6h4l5 5V4L7 9H3zm13.5 3c0-1.77-1.02-3.29-2.5-4.03v8.05c1.48-.73 2.5-2.25 2.5-4.02zM14 3.23v2.06c2.89.86 5 3.54 5 6.71s-2.11 5.85-5 6.71v2.06c4.01-.91 7-4.49 7-8.77s-2.99-7.86-7-8.77z">
      </g>
      <g id="plus" viewbox="0 0 16 16">
        <path d="M9 4H7V7H4V9H7V12H9V9H12V7H9V4Z"></path>
      </g>
      <g id="emoji-picker" viewBox="0 0 20 20">
        <path fill-rule="evenodd"
          d="M9.992 2C5.576 2 2 5.584 2 10C2 14.416 5.576 18 9.992 18C14.416 18 18 14.416 18 10C18 5.584 14.416 2 9.992 2ZM10 16.5C6.40875 16.5 3.5 13.5912 3.5 10C3.5 6.40875 6.40875 3.5 10 3.5C13.5912 3.5 16.5 6.40875 16.5 10C16.5 13.5912 13.5912 16.5 10 16.5ZM12.8 9.20005C13.464 9.20005 14 8.66405 14 8.00005C14 7.33605 13.464 6.80005 12.8 6.80005C12.136 6.80005 11.6 7.33605 11.6 8.00005C11.6 8.66405 12.136 9.20005 12.8 9.20005ZM7.2 9.20005C7.864 9.20005 8.4 8.66405 8.4 8.00005C8.4 7.33605 7.864 6.80005 7.2 6.80005C6.536 6.80005 6 7.33605 6 8.00005C6 8.66405 6.536 9.20005 7.2 9.20005ZM9.99999 14C11.864 14 13.448 12.7486 14.088 11H5.91199C6.55199 12.7486 8.13599 14 9.99999 14Z">
        </path>
      </g>
      <g id="dictation-toggle" viewBox="0 0 20 20">
        <path
          d="M5.75 8.02c.403 0 .757-.152 1.063-.457.305-.306.458-.66.458-1.063v-3c0-.417-.153-.77-.458-1.063-.306-.305-.66-.458-1.063-.458-.417 0-.77.153-1.063.458A1.414 1.414 0 0 0 4.23 3.5v3c0 .403.153.757.458 1.063.292.305.646.458 1.063.458Zm9.667 10.21c.514 0 .944-.181 1.291-.543.348-.36.521-.791.521-1.291V3.5c0-.472-.166-.875-.5-1.208A1.681 1.681 0 0 0 15.5 1.77H9V3.5h6.5v13H6.625v-1.438h-1.75v1.334c0 .5.18.93.542 1.291.347.362.77.542 1.27.542h8.73ZM14 15.061V13.5H8.396v1.563H14Zm0-2.562V11h-4v1.5h4Zm-9.125 1.125h1.75v-2.688a3.994 3.994 0 0 0 2.333-1.395A3.864 3.864 0 0 0 9.875 7H8.229c0 .68-.243 1.257-.729 1.73a2.461 2.461 0 0 1-1.75.687c-.694 0-1.278-.23-1.75-.688A2.319 2.319 0 0 1 3.27 7H1.626c0 .958.306 1.806.917 2.542.597.736 1.375 1.201 2.333 1.396v2.687Z">
        </path>
      </g>
      <g id="settings-icon" viewBox="0 0 20 20">
        <path fill-rule="evenodd" clip-rule="evenodd"
          d="M11.6629 19H8.33386C7.66807 19 7.11024 18.5256 7.02926 17.8843L6.78633 16.224C6.54341 16.101 6.30948 15.9693 6.07555 15.8199L4.45604 16.4524C3.82623 16.6808 3.13344 16.4261 2.82754 15.8814L1.18103 13.0966C0.86613 12.5168 1.00109 11.8316 1.50494 11.4451L2.88152 10.3997C2.87252 10.2679 2.86352 10.1362 2.86352 9.99561C2.86352 9.86384 2.87252 9.72328 2.88152 9.59151L1.51393 8.54612C0.983095 8.15081 0.848136 7.43924 1.18103 6.89458L2.84553 4.09224C3.15144 3.54758 3.84423 3.30161 4.45604 3.5388L6.08455 4.18009C6.31848 4.03075 6.5524 3.89897 6.78633 3.77599L7.02926 2.0981C7.11024 1.48316 7.66807 1 8.32487 1H11.6539C12.3197 1 12.8775 1.47438 12.9585 2.11567L13.2014 3.77599C13.4443 3.89897 13.6782 4.03075 13.9122 4.18009L15.5317 3.54758C16.1705 3.31918 16.8633 3.57394 17.1692 4.11859L18.8247 6.91215C19.1486 7.49195 19.0046 8.17716 18.5008 8.56369L17.1332 9.60908C17.1422 9.74085 17.1512 9.87262 17.1512 10.0132C17.1512 10.1537 17.1422 10.2855 17.1332 10.4173L18.5008 11.4627C19.0046 11.858 19.1486 12.5432 18.8337 13.0966L17.1602 15.9253C16.8543 16.47 16.1615 16.716 15.5407 16.4788L13.9212 15.8463C13.6872 15.9956 13.4533 16.1274 13.2194 16.2504L12.9765 17.9283C12.8865 18.5256 12.3287 19 11.6629 19ZM8.81541 16.75H11.1932L11.512 14.6636L11.9686 14.4836C12.3476 14.3364 12.7267 14.1236 13.123 13.8455L13.5107 13.5673L15.5611 14.3527L16.75 12.3891L15.0011 11.0964L15.0614 10.6382C15.0873 10.4255 15.1131 10.2209 15.1131 10C15.1131 9.77909 15.0873 9.56636 15.0614 9.36182L15.0011 8.90364L16.75 7.61091L15.5525 5.64727L13.4935 6.43273L13.1058 6.14636C12.7439 5.88455 12.3563 5.67182 11.96 5.51636L11.512 5.33636L11.1932 3.25H8.81541L8.49665 5.33636L8.04004 5.50818C7.66098 5.66364 7.28191 5.86818 6.88561 6.15455L6.49793 6.42455L4.44751 5.64727L3.25 7.60273L4.99888 8.89545L4.93858 9.35364C4.91273 9.56636 4.88689 9.78727 4.88689 10C4.88689 10.2127 4.90412 10.4336 4.93858 10.6382L4.99888 11.0964L3.25 12.3891L4.4389 14.3527L6.49793 13.5673L6.88561 13.8536C7.25606 14.1236 7.62652 14.3282 8.03143 14.4836L8.48803 14.6636L8.81541 16.75ZM10 12.8125C11.5533 12.8125 12.8125 11.5533 12.8125 10C12.8125 8.4467 11.5533 7.1875 10 7.1875C8.4467 7.1875 7.1875 8.4467 7.1875 10C7.1875 11.5533 8.4467 12.8125 10 12.8125Z">
        </path>
      </g>
      <g id="search" viewBox="0 0 20 20">
        <path fill-rule="evenodd" clip-rule="evenodd"
          d="M17.49 16L13.76 12.27C14.53 11.2 15 9.91 15 8.5C15 4.91 12.09 2 8.5 2C4.91 2 2 4.91 2 8.5C2 12.09 4.91 15 8.5 15C9.91 15 11.2 14.53 12.27 13.76L16 17.49L17.49 16ZM4 8.5C4 6.01 6.01 4 8.5 4C10.99 4 13 6.01 13 8.5C13 10.99 10.99 13 8.5 13C6.01 13 4 10.99 4 8.5Z">
        </path>
      </g>
      <g id="browser-search" viewBox="0 0 20 20">
        <path
          d="M9.82803 18.9771C8.6051 18.9465 7.4586 18.6943 6.38853 18.2204C5.31847 17.7465 4.37834 17.1045 3.56815 16.2943C2.77325 15.4688 2.1465 14.521 1.6879 13.451C1.2293 12.3656 1 11.2115 1 9.98853C1 8.73503 1.2293 7.5656 1.6879 6.48025C2.16178 5.3949 2.81146 4.44713 3.63694 3.63694C4.46242 2.81146 5.41783 2.16943 6.50318 1.71083C7.58853 1.23694 8.75032 1 9.98853 1C12.2204 1 14.1465 1.69554 15.7669 3.08662C17.4025 4.47771 18.4191 6.22802 18.8166 8.33758H16.8675C16.6229 7.23694 16.1338 6.2586 15.4 5.40255C14.6662 4.5465 13.772 3.90446 12.7172 3.47643V3.98089C12.7172 4.43949 12.5567 4.8293 12.2357 5.15032C11.9147 5.45605 11.5325 5.60892 11.0892 5.60892H8.8879V6.70955C8.8879 7.01529 8.78089 7.27516 8.56688 7.48917C8.36815 7.6879 8.11592 7.78726 7.81019 7.78726H6.70955V9.98853H7.78726V12.1439H6.70955L3.06369 8.49809C3.01783 8.74267 2.97962 8.98726 2.94904 9.23185C2.91847 9.47643 2.90318 9.72866 2.90318 9.98853C2.90318 11.9299 3.5758 13.5885 4.92102 14.9643C6.26624 16.3248 7.90191 17.028 9.82803 17.0739V18.9771ZM17.6471 18.4726L14.8268 15.6293C14.521 15.8127 14.2 15.958 13.8637 16.065C13.5427 16.1567 13.1987 16.2025 12.8318 16.2025C11.7312 16.2025 10.7987 15.8204 10.0344 15.056C9.27006 14.2917 8.8879 13.3669 8.8879 12.2815C8.8879 11.1809 9.27006 10.2484 10.0344 9.48408C10.7987 8.71974 11.7312 8.33758 12.8318 8.33758C13.9172 8.33758 14.842 8.71974 15.6064 9.48408C16.3707 10.2484 16.7529 11.1732 16.7529 12.2586C16.7529 12.6408 16.6994 13 16.5924 13.3363C16.5006 13.6726 16.3631 13.986 16.1796 14.2764L19 17.1197L17.6471 18.4726ZM12.8089 14.2994C13.3745 14.2994 13.8561 14.1083 14.2535 13.7261C14.651 13.3287 14.8497 12.8471 14.8497 12.2815C14.8497 11.7159 14.651 11.2344 14.2535 10.8369C13.8713 10.4395 13.3975 10.2408 12.8318 10.2408C12.2662 10.2408 11.7847 10.4395 11.3873 10.8369C10.9898 11.2191 10.7911 11.693 10.7911 12.2586C10.7911 12.8242 10.9822 13.3057 11.3643 13.7032C11.7618 14.1006 12.2433 14.2994 12.8089 14.2994Z">
        </path>
      </g>
      <g id="globe" viewBox="0 0 20 20">
        <path
          d="M9.99987 16.7167C9.07765 16.7167 8.20543 16.5444 7.3832 16.2C6.57209 15.8444 5.86098 15.3611 5.24987 14.75C4.63876 14.1389 4.15543 13.4278 3.79987 12.6167C3.45543 11.7944 3.2832 10.9222 3.2832 9.99999C3.2832 9.07777 3.45543 8.2111 3.79987 7.39999C4.15543 6.57777 4.63876 5.8611 5.24987 5.24999C5.86098 4.63888 6.57209 4.1611 7.3832 3.81666C8.20543 3.4611 9.07765 3.28333 9.99987 3.28333C10.9221 3.28333 11.7888 3.4611 12.5999 3.81666C13.4221 4.1611 14.1388 4.63888 14.7499 5.24999C15.361 5.8611 15.8388 6.57777 16.1832 7.39999C16.5388 8.2111 16.7165 9.07777 16.7165 9.99999C16.7165 10.9222 16.5388 11.7944 16.1832 12.6167C15.8388 13.4278 15.361 14.1389 14.7499 14.75C14.1388 15.3611 13.4221 15.8444 12.5999 16.2C11.7888 16.5444 10.9221 16.7167 9.99987 16.7167ZM9.9832 15.05C10.1499 14.8722 10.3276 14.5278 10.5165 14.0167C10.7054 13.4944 10.8499 12.9389 10.9499 12.35H9.04987C9.14987 12.9389 9.28876 13.4944 9.46654 14.0167C9.64431 14.5278 9.81654 14.8722 9.9832 15.05ZM8.51654 14.8833C8.34987 14.5611 8.21098 14.1833 8.09987 13.75C7.99987 13.3167 7.91098 12.85 7.8332 12.35H5.49987C5.81098 12.9611 6.22765 13.4889 6.74987 13.9333C7.27209 14.3778 7.86098 14.6944 8.51654 14.8833ZM11.4665 14.8833C12.111 14.6944 12.6999 14.3778 13.2332 13.9333C13.7665 13.4889 14.1832 12.9611 14.4832 12.35H12.1665C12.0888 12.85 11.9943 13.3167 11.8832 13.75C11.7721 14.1833 11.6332 14.5611 11.4665 14.8833ZM12.4832 11.1667H15.0999C15.1554 10.9555 15.1943 10.7555 15.2165 10.5667C15.2388 10.3778 15.2499 10.1889 15.2499 9.99999C15.2499 9.79999 15.2388 9.60555 15.2165 9.41666C15.1943 9.22777 15.1554 9.03333 15.0999 8.83333H12.4832C12.5054 9.03333 12.5165 9.23333 12.5165 9.43332C12.5276 9.63332 12.5332 9.83333 12.5332 10.0333C12.5332 10.2222 12.5276 10.4167 12.5165 10.6167C12.5165 10.8055 12.5054 10.9889 12.4832 11.1667ZM8.89987 11.1667H11.0999C11.1221 10.9444 11.1276 10.7389 11.1165 10.55C11.1165 10.3611 11.1165 10.1778 11.1165 9.99999C11.1165 9.8111 11.1165 9.62221 11.1165 9.43332C11.1276 9.24444 11.1221 9.04444 11.0999 8.83333H8.89987C8.87765 9.04444 8.86098 9.24444 8.84987 9.43332C8.84987 9.62221 8.84987 9.8111 8.84987 9.99999C8.84987 10.1778 8.84987 10.3667 8.84987 10.5667C8.86098 10.7555 8.87765 10.9555 8.89987 11.1667ZM4.89987 11.1667H7.49987C7.47765 10.9667 7.46098 10.7667 7.44987 10.5667C7.44987 10.3555 7.44987 10.1555 7.44987 9.96666C7.44987 9.76666 7.44987 9.57221 7.44987 9.38333C7.46098 9.19444 7.47765 9.0111 7.49987 8.83333H4.89987C4.8332 9.04444 4.7832 9.24444 4.74987 9.43332C4.72765 9.6111 4.71654 9.79999 4.71654 9.99999C4.71654 10.1889 4.72765 10.3778 4.74987 10.5667C4.7832 10.7555 4.8332 10.9555 4.89987 11.1667ZM12.1665 7.64999H14.4832C14.1832 7.02777 13.7665 6.49999 13.2332 6.06666C12.6999 5.62221 12.111 5.30555 11.4665 5.11666C11.6332 5.43888 11.7721 5.81666 11.8832 6.24999C11.9943 6.68333 12.0888 7.14999 12.1665 7.64999ZM9.04987 7.64999H10.9499C10.8499 7.04999 10.7054 6.49444 10.5165 5.98333C10.3276 5.47221 10.1499 5.12777 9.9832 4.94999C9.81654 5.12777 9.64431 5.47221 9.46654 5.98333C9.28876 6.49444 9.14987 7.04999 9.04987 7.64999ZM5.49987 7.64999H7.8332C7.91098 7.14999 7.99987 6.68333 8.09987 6.24999C8.21098 5.81666 8.34987 5.43888 8.51654 5.11666C7.86098 5.30555 7.27209 5.62221 6.74987 6.06666C6.22765 6.49999 5.81098 7.02777 5.49987 7.64999Z">
        </path>
      </g>
      <g id="play" viewBox="0 0 20 20">
        <path fill-rule="evenodd" clip-rule="evenodd" d="M6 16L16 10L6 4V16Z"></path>
      </g>
      <g id="pause" viewBox="0 0 20 20">
        <path d="M9 5H6V15H9V5Z"></path>
        <path d="M14 5H11V15H14V5Z"></path>
      </g>
      <g id="fast-forward" viewBox="0 0 20 20">
        <path d="M10 10L4 14V6L10 10Z"></path>
        <path d="M10 10V14L16 10L10 6V10Z"></path>
      </g>
      <g id="calculator" viewBox="0 0 20 20">
        <path
          d="M17 1H3C1.9 1 1 1.9 1 3V17C1 18.1 1.9 19 3 19H17C18.1 19 19 18.1 19 17V3C19 1.9 18.1 1 17 1ZM17 17H3V3H17V17Z">
        </path>
        <path d="M9.25 5.72H4.25V7.22H9.25V5.72Z"></path>
        <path d="M16 13.75H11V15.25H16V13.75Z"></path>
        <path d="M16 11.25H11V12.75H16V11.25Z"></path>
        <path d="M6 16H7.5V14H9.5V12.5H7.5V10.5H6V12.5H4V14H6V16Z"></path>
        <path
          d="M12.09 8.95L13.5 7.54L14.91 8.95L15.97 7.89L14.56 6.47L15.97 5.06L14.91 4L13.5 5.41L12.09 4L11.03 5.06L12.44 6.47L11.03 7.89L12.09 8.95Z">
        </path>
      </g>
      <g id="view-all-apps" viewBox="0 0 20 20" fill="none">
        <!-- Include a <style> to set the stroke color dynamically based on color scheme (light or dark mode) -->
        <style>
          path {
            stroke: var(--cros-text-color-secondary);
            stroke-width: 1.5;
          }
        </style>
        <path
          d="M1.75 3.75H5.41427V7.41427H1.75V3.75ZM8.16787 3.75H11.8321V7.41427H8.16787V3.75ZM14.5857 3.75H18.25V7.41427H14.5857V3.75ZM14.5857 12.5857H18.25V16.25H14.5857V12.5857ZM8.16787 12.5857H11.8321V16.25H8.16787V12.5857ZM1.75 12.5857H5.41427V16.25H1.75V12.5857Z">
        </path>
      </g>
      <g id="lock" viewBox="0 0 20 20">
        <path
          d="M11.75 12.5C11.75 13.4665 10.9665 14.25 10 14.25C9.0335 14.25 8.25 13.4665 8.25 12.5C8.25 11.5335 9.0335 10.75 10 10.75C10.9665 10.75 11.75 11.5335 11.75 12.5Z">
        </path>
        <path fill-rule="evenodd" clip-rule="evenodd"
          d="M14 7H13.5V5C13.5 3.34315 11.6569 2 10 2C8.34315 2 6.5 3.34315 6.5 5V7H6C4.89543 7 4 7.89543 4 9V16C4 17.1046 4.89543 18 6 18H14C15.1046 18 16 17.1046 16 16V9C16 7.89543 15.1046 7 14 7ZM12 5.5V7H8V5.5C8 5 8.5 3.5 10 3.5C11.5 3.5 12 5 12 5.5ZM6 9V16H14V9H6Z">
        </path>
      </g>
      <g id="menu" viewBox="0 0 20 20">
        <path
          d="M7 7.5H13V6H7V7.5ZM7 14H13V12.5H7V14ZM7 10.75H13V9.25H7V10.75ZM4.5 17C4.08333 17 3.72917 16.8542 3.4375 16.5625C3.14583 16.2708 3 15.9167 3 15.5V4.5C3 4.08333 3.14583 3.72917 3.4375 3.4375C3.72917 3.14583 4.08333 3 4.5 3H15.5C15.9167 3 16.2708 3.14583 16.5625 3.4375C16.8542 3.72917 17 4.08333 17 4.5V15.5C17 15.9167 16.8542 16.2708 16.5625 16.5625C16.2708 16.8542 15.9167 17 15.5 17H4.5ZM4.5 15.5H15.5V4.5H4.5V15.5Z">
        </path>
      </g>
      <g id="launch-mail" viewBox="0 0 20 20">
        <path fill-rule="evenodd" clip-rule="evenodd"
          d="M16 4H4C2.9 4 2 4.9 2 6V14C2 15.1 2.9 16 4 16H16C17.1 16 18 15.1 18 14V6C18 4.9 17.1 4 16 4ZM15.5 6L10 9.5L4.5 6H15.5ZM4 14V8L10 12L16 8V14H4Z">
        </path>
      </g>
      <g id="browser-home" viewBox="0 0 20 20">
        <path fill-rule="evenodd" clip-rule="evenodd"
          d="M10 2L17 8V17H3V8L10 2ZM12 15V11H8V15H5V8.91987L10 4.63416L15 8.91987V15H12Z">
        </path>
      </g>
    </defs>
  </svg>
</iron-iconset-svg>
`;
document.head.appendChild(template.content);
