import {html} from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
  return html`<!--_html_template_start_--><style>
  .flex-row {
    display: flex;
    flex-direction: row;
    justify-content: center;
  }

  #confirmContainer {
    display: flex;
    flex-direction: row;
  }

  #container:focus {
    outline: none;
  }

  #keySeparator {
    align-items: center;
    display: flex;
    padding-inline-end: 8px;
  }
</style>

<div id="container" class="flex-row" tabindex="-1">
  <template is="dom-if" if="[[shouldShowConfirmView(isCapturing)]]">
    <div id="confirmContainer">
      <template is="dom-repeat" items="[[modifiers]]">
        <shortcut-input-key key="[[item]]" key-state="modifier-selected"
            meta-key="[[metaKey]]">
        </shortcut-input-key>
      </template>
      <template is="dom-if"
          if="[[shouldShowSeparator(showSeparator, modifiers)]]">
        <div id="keySeparator"> + </div>
      </template>
      <template is="dom-if"
          if="[[shouldShowSelectedKey(pendingKeyEvent.*,
                                      pendingPrerewrittenKeyEvent.*)]]">
        <shortcut-input-key id="confirmKey"
            key="[[getConfirmKey(pendingKeyEvent.*,
                                 pendingPrerewrittenKeyEvent.*)]]"
            key-state="[[getConfirmKeyState(pendingKeyEvent.*,
                                            pendingPrerewrittenKeyEvent.*)]]"
            meta-key="[[metaKey]]">
        </shortcut-input-key>
      </template>
    </div>
  </template>
  <template is="dom-if" if="[[shouldShowEditView(isCapturing)]]">
    <div id="editContainer" class="flex-row">
      <shortcut-input-key id="ctrlKey"
          key="ctrl"
          key-state="[[getCtrlState(pendingKeyEvent.*,
                                    pendingPrerewrittenKeyEvent.*)]]">
      </shortcut-input-key>
      <shortcut-input-key id="altKey"
          key="alt"
          key-state="[[getAltState(pendingKeyEvent.*,
                                   pendingPrerewrittenKeyEvent.*)]]">
      </shortcut-input-key>
      <shortcut-input-key id="shiftKey"
          key="shift"
          key-state="[[getShiftState(pendingKeyEvent.*,
                                    pendingPrerewrittenKeyEvent.*)]]">
      </shortcut-input-key>
      <shortcut-input-key id="searchKey"
          key="meta"
          key-state="[[getSearchState(pendingKeyEvent.*,
                                      pendingPrerewrittenKeyEvent.*)]]"
          meta-key="[[metaKey]]">
      </shortcut-input-key>
      <template is="dom-if" if="[[hasFunctionKey]]">
        <shortcut-input-key id="functionKey"
            key="fn"
            key-state="[[getFunctionState(pendingKeyEvent.*,
                                        pendingPrerewrittenKeyEvent.*)]]"
            meta-key="[[metaKey]]">
        </shortcut-input-key>
      </template>
      <div id="keySeparator"> + </div>
      <shortcut-input-key id="pendingKey"
          key="[[getKey(pendingKeyEvent.*, pendingPrerewrittenKeyEvent.*)]]"
          key-state="[[getKeyState(pendingKeyEvent.*,
                                   pendingPrerewrittenKeyEvent.*)]]"
          meta-key="[[metaKey]]">
      </shortcut-input-key>
    </div>
  </template>
</div>
<!--_html_template_end_-->`;
}