import {html} from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
  return html`<!--_html_template_start_--><style>
  :host {
    --key-alpha-numeric-selected-bg-color: var(--cros-bg-color-dropped-elevation-1);
    --key-container-height: 32px;
    --key-container-padding-bottom: 6px;
    --key-container-padding-top: 6px;
    --key-modifier-selected-bg-color: var(--cros-highlight-color);
    --key-modifier-selected-shadow-color: var(--cros-highlight-color);
  }

  :host-context(body.jelly-enabled) {
    --key-alpha-numeric-selected-bg-color: var(--cros-sys-surface_variant);
    --key-modifier-selected-bg-color: var(--cros-sys-highlight_shape);
    --key-modifier-selected-shadow-color: var(--cros-sys-highlight_shape);
  }

  .key-container {
    align-items: center;
    border-radius: 12px;
    box-sizing: border-box;
    display: inline-flex;
    font-weight: 500;
    height: var(--key-container-height);
    justify-content: center;
    margin-bottom: 2px;
    margin-inline-end: 8px;
    min-width: 32px;
    padding-bottom: var(--key-container-padding-bottom);
    padding-top: var(--key-container-padding-top);
    vertical-align: middle;
  }

  :host([narrow]) .key-container {
    margin-inline-end: 4px;
    padding-inline: 4px;
  }

  #key-text {
    color: var(--cros-text-color-secondary);
    font: var(--cros-button-2-font);
  }

  :host([key-state='not-selected']) .key-container {
    outline: 1px solid var(--cros-separator-color);
  }

  :host([key-state='not-selected']) #key-text {
    color: var(--cros-text-color-disabled);
  }

  :host([key-state='not-selected']) #key-icon{
    --iron-icon-fill-color: var(--cros-text-color-disabled);
  }

  :host([key-state='modifier-selected']) .key-container {
    background-color: var(--key-modifier-selected-bg-color);
    border: none;
    box-shadow: 0 1px 1px var(--key-modifier-selected-shadow-color);
    transition: all 300ms ease-in-out;
  }

  :host([key-state='modifier-selected']:not([key='meta']):not([key='Meta'])) .key-container {
    min-width: 44px;
    padding-inline: 12px;
  }

  :host([key-state='modifier-selected'][key='meta']) .key-container,
  :host([key-state='modifier-selected'][key='Meta']) .key-container {
    padding-inline: 6px;
  }

  :host([key-state='alpha-numeric-selected']) .key-container {
    background-color: var(--key-alpha-numeric-selected-bg-color);
    border: none;
    box-shadow: 0 1px 1px var(--cros-bg-color-dropped-elevation-1);
    transition: all 300ms ease-in-out;
  }

  :host([key-state='alpha-numeric-selected'][has-icon]) .key-container {
    padding-inline: 6px;
  }

  :host([key-state='alpha-numeric-selected']:not([has-icon])) .key-container {
    padding-inline: 11px;
  }

  :host([highlighted][key-state='modifier-selected']) div.key-container {
    background-color: var(--cros-color-prominent);
  }

  :host([highlighted][key-state='modifier-selected']) #key-text {
    color: var(--cros-button-label-color-primary);
  }

  :host([highlighted][key-state='alpha-numeric-selected']) div.key-container {
    background-color: var(--cros-bg-color);
  }

  :host([highlighted][key-state='modifier-selected']) #key-icon {
    --iron-icon-fill-color: var(--cros-button-label-color-primary);
  }

  :host([key-state='not-selected'][key='ctrl']) .key-container,
  :host([key-state='not-selected'][key='alt']) .key-container,
  :host([key-state='not-selected'][key='shift']) .key-container{
    min-width: 44px;
    padding-inline: 12px;
  }

  #key-icon {
    --iron-icon-height: 16px;
    --iron-icon-width: 16px;
    --iron-icon-fill-color: var(--cros-text-color-secondary);
  }
</style>

<div id="key" class="key-container">
  <template is="dom-if" if="[[getIconIdForKey(key)]]">
    <div id="keyIcon" aria-label="[[getAriaLabelForIcon(key)]]" role="img">
      <iron-icon icon="[[getIconIdForKey(key)]]" id="key-icon"></iron-icon>
    </div>
  </template>
  <template is="dom-if" if="[[!getIconIdForKey(key)]]">
    <span id="key-text">[[key]]</span>
  </template>
</div>
<!--_html_template_end_-->`;
}