import {html} from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
  return html`<!--_html_template_start_-->    <style include="cr-shared-style md-select">
      cr-dialog::part(dialog) {
        background-color: var(--cros-sys-dialog_container);
      }

      [slot=title] {
        --cr-dialog-title-slot-padding-bottom: 32px;
        --cr-dialog-title-slot-padding-end: 32px;
        --cr-dialog-title-slot-padding-start: 32px;
        --cr-dialog-title-slot-padding-top: 32px;
        --cr-primary-text-color: var(--cros-sys-on_surface);
        font: var(--cros-display-7-font);
      }

      [slot='button-container'] {
        --cr-dialog-button-container-padding-bottom: 28px;
        --cr-dialog-button-container-padding-horizontal: 32px;
        padding-top: 0;
      }

      #dialog [slot=body] {
        --cr-dialog-body-padding-horizontal: 32px;
        --cr-form-field-bottom-spacing: 8px;
      }

      .md-select {
        --md-select-bg-color: var(--cros-sys-input_field_on_base);
        --md-select-focus-shadow-color: var(--cros-sys-focus_ring);
        --md-select-text-color: var(--cros-sys-on_surface);
        --md-select-side-padding: 16px;
        border-radius: 8px;
        height: 36px;
        width: 100%;
      }

      cr-searchable-drop-down {
        --cr-searchable-drop-down-bg-color: var(--cros-sys-base_elevated);
        --cr-searchable-drop-down-icon-color-focus:
            var(--cros-sys-on_surface);
        --cr-searchable-drop-down-list-item-color: var(--cros-sys-on_surface);
        --cr-searchable-drop-down-list-bg-color-selected:
            var(--cros-sys-hover_on_subtle);
        --cr-searchable-drop-down-list-bg-color-active:
            var(--cros-sys-hover_on_subtle);
        --cr-searchable-drop-down-shadow: var(--cros-elevation-2-shadow);
        --cr-searchable-drop-down-spinner-color: var(--cros-sys-primary);
        /* dialog width (512px) - padding left (32px) - padding right (32px) */
        --cr-searchable-drop-down-width: calc(512px - 2 * 32px);
        --cr-secondary-text-color: var(--cros-sys-on_surface);
        --iron-icon-fill-color: var(--cros-sys-secondary);
        display: block;
      }

      cr-input,
      cr-searchable-drop-down::part(input) {
        --cr-form-field-label-color: var(--cros-sys-on_surface);
        --cr-input-background-color: var(--cros-sys-input_field_on_base);
        --cr-input-border-radius: 8px;
        --cr-input-color: var(--cros-sys-on_surface);
        --cr-input-error-color: var(--cros-sys-error);
        --cr-input-focus-color: var(--cros-sys-primary);
        --cr-input-min-height: 36px;
        --cr-input-padding-end: 16px;
        --cr-input-padding-start: 16px;
        --cr-input-placeholder-color: var(--cros-sys-secondary);
        font: var(--cros-body-2-font);
      }

      .md-select,
      cr-input:not(:last-child),
      cr-searchable-drop-down {
        margin-bottom: var(--cr-form-field-bottom-spacing);
      }

      #saveCredentialsCheckbox {
        --cr-checkbox-checked-box-color: var(--cros-sys-primary);
        --cr-checkbox-label-color: var(--cros-sys-on_surface);
        --cr-checkbox-mark-color: var(--cros-sys-on_primary);
        --cr-checkbox-ripple-checked-color: var(--cros-sys-ripple_primary);
        --cr-checkbox-ripple-opacity: 1;
        --cr-checkbox-ripple-unchecked-color: var(--cros-sys-ripple_primary);
        --cr-checkbox-unchecked-box-color: var(--cros-sys-on_surface);
      }

      :host-context(.focus-outline-visible)
          #saveCredentialsCheckbox:focus-within {
        --cr-checkbox-ripple-ring: 2px solid var(--cros-sys-focus_ring);
      }

      #saveCredentialsCheckboxJelly {
        --cros-checkbox-reserve-inline-start: 0px;
      }

      cr-button {
        --active-bg: transparent;
        --active-shadow: none;
        --active-shadow-action: none;
        --bg-action: var(--cros-sys-primary);
        --cr-button-height: 36px;
        --disabled-bg-action:
            var(--cros-sys-disabled_container);
        --disabled-bg: var(--cros-sys-disabled_container);;
        --disabled-text-color: var(--cros-sys-disabled);
        /* Use the default bg color as hover color because we
           rely on hoverBackground layer below.  */
        --hover-bg-action: var(--cros-sys-primary);
        --hover-bg-color: var(--cros-sys-primary_container);
        --ink-color: var(--cros-sys-ripple_primary);
        --ripple-opacity-action: 1;
        --ripple-opacity: 1;
        --text-color-action: var(--cros-sys-on_primary);
        --text-color: var(--cros-sys-on_primary_container);
        border: none;
        border-radius: 18px;
        font: var(--cros-button-2-font);
        position: relative;
      }

      cr-button.cancel-button {
        background-color: var(--cros-sys-primary_container);
      }

      cr-button.cancel-button:hover::part(hoverBackground) {
        background-color: var(--cros-sys-hover_on_subtle);
        display: block;
      }

      cr-button.action-button:hover::part(hoverBackground) {
        background-color: var(--cros-sys-hover_on_prominent);
        display: block;
      }

      :host-context(.focus-outline-visible) cr-button:focus {
        /* disable the focus shadow because we use outline below */
        box-shadow: none;
        outline: 2px solid var(--cros-sys-focus_ring);
        outline-offset: 2px;
      }

      .action-button:not(:active):hover {
        box-shadow: none;
      }

      #name,
      #username {
        --cr-input-error-display: none;
      }

      #general-error-container {
        height: 32px;
      }

      #general-error-icon {
        --iron-icon-fill-color: var(--cros-sys-error);
      }

      #general-error-message {
        color: var(--cros-sys-error);
        display: inline-block;
        font-size: 10px;
      }
    </style>

    <cr-dialog id="dialog" exportparts="dialog">
      <div slot="title" part="title">[[i18n('addSmbShare')]]</div>
      <div slot="body" part="body" spellcheck="false">
        <div id="general-error-container">
          <div hidden="[[!shouldShowGeneralError_(currentMountError_)]]">
            <iron-icon id="general-error-icon" icon="cr:warning"></iron-icon>
            <div id="general-error-message">[[generalErrorText_]]</div>
          </div>
        </div>
        <cr-searchable-drop-down id="address" label="[[i18n('smbShareUrl')]]"
            value="{{mountUrl_}}" items="[[discoveredShares_]]"
            placeholder="\\\\server\\share"
            error-message-allowed
            update-value-on-input autofocus
            show-loading="[[discoveryActive_]]"
            loading-message="[[i18n('smbShareDiscoveryMessage')]]">
        </cr-searchable-drop-down>
        <cr-input id="name" label="[[i18n('smbShareName')]]"
            value="{{mountName_}}" maxlength="64">
        </cr-input>
        <div id="authentication-method"
            hidden="[[!shouldShowAuthenticationUI_(isKerberosEnabled_,
                isGuest_)]]">
          <label id="authentication-label" class="cr-form-field-label">
            [[i18n('smbShareAuthenticationMethod')]]
          </label>
          <select class="md-select" aria-labelledby="authentication-label"
              value="{{authenticationMethod_::change}}">
            <option value="kerberos">
              [[i18n('smbShareKerberosAuthentication')]]
            </option>
            <option value="credentials">
              [[i18n('smbShareStandardAuthentication')]]
            </option>
          </select>
        </div>
        <div id="credentials"
            hidden="[[!shouldShowCredentialUI_(authenticationMethod_)]]">
          <cr-input id="username" label="[[i18n('smbShareUsername')]]"
              value="{{username_}}"
              invalid="[[shouldShowCredentialError_(currentMountError_)]]">
          </cr-input>
          <cr-input id="password" type="password"
              label="[[i18n('smbSharePassword')]]" value="{{password_}}"
              invalid="[[shouldShowCredentialError_(currentMountError_)]]">
          </cr-input>
          <template is="dom-if" if="[[isCrosComponentsEnabled_()]]">
            <label>
              <cros-checkbox id="saveCredentialsCheckboxJelly" checked>
              </cros-checkbox>
              [[i18n('smbShareSaveCredentials')]]
            </label>
          </template>
          <template is="dom-if" if="[[!isCrosComponentsEnabled_()]]">
            <cr-checkbox id="saveCredentialsCheckbox" checked>
              [[i18n('smbShareSaveCredentials')]]
            </cr-checkbox>
          </template>
        </div>
      </div>
      <div slot="button-container">
        <cr-button class="cancel-button" on-click="cancel_" id="cancel">
          [[i18n('cancel')]]
        </cr-button>
        <cr-button class="action-button" on-click="onAddButtonTap_"
            disabled="[[!canAddShare_(mountUrl_, inProgress_,
                currentMountError_)]]">
          [[i18n('add')]]
        </cr-button>
      </div>
    </cr-dialog>
<!--_html_template_end_-->`;
}