// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import"chrome://resources/ash/common/personalization/common.css.js";import"chrome://resources/polymer/v3_0/paper-spinner/paper-spinner-lite.js";import{assert}from"chrome://resources/js/assert.js";import{sanitizeInnerHtml}from"chrome://resources/js/parse_html_subset.js";import{PolymerElement}from"chrome://resources/polymer/v3_0/polymer/polymer_bundled.min.js";import{getTemplate}from"./sea_pen_chip_text_element.html.js";export class SeaPenChipTextElement extends PolymerElement{static get is(){return"sea-pen-chip-text"}static get template(){return getTemplate()}static get properties(){return{textAnimationEnabled:Boolean,chipText:{type:Object,observer:"onChipTextChanged_"}}}getLettersAsElements_(chipElement){const content=chipElement.innerHTML;chipElement.innerHTML=window.trustedTypes.emptyHTML;const letters=[];const segmenter=new Intl.Segmenter(Intl.DateTimeFormat().resolvedOptions().locale,{granularity:"grapheme"});for(const{segment:segment}of segmenter.segment(content)){const letter=document.createElement("span");letter.className="letter";letter.innerHTML=sanitizeInnerHtml(segment);chipElement.appendChild(letter);letters.push(letter)}return letters}removeLetterElementsFromChip_(n){const chip=this.$.chipText;for(let i=0;i<n;i++){if(!chip.firstChild){return}chip.removeChild(chip.firstChild)}}animateUnderlineWidthChange_(oldWidth,newWidth,duration){const underline=this.$.underline;assert(!!underline,"underline element should be available");underline.animate({width:[`${oldWidth}px`,`${newWidth}px`]},{duration:duration,easing:"cubic-bezier(0.00, 0.00, 0.00, 1.00)"})}animateLetterOut_(letterElements,i){setTimeout((()=>{letterElements[i].className="letter out"}),i*17)}animateLetterIn_(letterElements,i){setTimeout((function(){letterElements[i].className="letter in"}),i*17)}changeChipText_(chipElement,newText){assert(!!chipElement);const currentChipWidth=chipElement.clientWidth;const currentLetterElements=this.getLettersAsElements_(chipElement);for(let i=0;i<currentLetterElements.length;i++){this.animateLetterOut_(currentLetterElements,i)}setTimeout((()=>{this.removeLetterElementsFromChip_(currentLetterElements.length);chipElement.innerHTML=sanitizeInnerHtml(newText);const newLetterElements=this.getLettersAsElements_(chipElement);const newChipWidth=chipElement.clientWidth;this.animateUnderlineWidthChange_(currentChipWidth,newChipWidth,250+newLetterElements.length*17);for(let i=0;i<newLetterElements.length;i++){this.animateLetterIn_(newLetterElements,i)}}),200+currentLetterElements.length*17)}onChipTextChanged_(newText,oldText){const chip=this.$.chipText;assert(!!chip);if(!this.textAnimationEnabled){if(chip.childElementCount>0){this.removeLetterElementsFromChip_(chip.childElementCount)}if(chip.innerHTML!==newText){chip.innerHTML=sanitizeInnerHtml(newText)}return}chip.innerHTML=sanitizeInnerHtml(oldText);this.changeChipText_(chip,newText)}}customElements.define(SeaPenChipTextElement.is,SeaPenChipTextElement);