// Copyright 2023 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import{FullscreenPreviewState}from"chrome://resources/ash/common/personalization/wallpaper_state.js";import{QUERY}from"./constants.js";import{isSeaPenTextInputEnabled}from"./load_time_booleans.js";import{MantaStatusCode}from"./sea_pen.mojom-webui.js";import*as seaPenAction from"./sea_pen_actions.js";import{logSeaPenImageSet}from"./sea_pen_metrics_logger.js";import{isNonEmptyArray,isPersonalizationApp}from"./sea_pen_utils.js";import{withMinimumDelay}from"./transition.js";export async function selectRecentSeaPenImage(id,provider,store){if(id===store.data.currentSelected){return}store.beginBatchUpdate();store.dispatch(seaPenAction.beginSelectRecentSeaPenImageAction(id));store.dispatch(seaPenAction.beginLoadSelectedRecentSeaPenImageAction());store.endBatchUpdate();const shouldPreview=await shouldShowFullscreenPreview(provider);if(shouldPreview){provider.makeTransparent();store.dispatch(seaPenAction.setSeaPenFullscreenStateAction(FullscreenPreviewState.LOADING))}const{success:success}=await provider.selectRecentSeaPenImage(id,shouldPreview);store.beginBatchUpdate();store.dispatch(seaPenAction.endSelectRecentSeaPenImageAction(id,success));if(!success){console.warn("Error setting image");store.dispatch(seaPenAction.setSeaPenFullscreenStateAction(FullscreenPreviewState.OFF));store.dispatch(seaPenAction.setSelectedRecentSeaPenImageAction(store.data.currentSelected))}store.endBatchUpdate();if(success){const isTextQuery=!!store.data.recentImageData[id]?.imageInfo?.query?.textQuery;logSeaPenImageSet(isTextQuery,"Recent")}}export async function getSeaPenThumbnails(query,provider,store){store.dispatch(seaPenAction.beginSearchSeaPenThumbnailsAction(query));store.dispatch(seaPenAction.setCurrentSeaPenQueryAction(query));const{thumbnails:thumbnails,statusCode:statusCode}=await withMinimumDelay(provider.getSeaPenThumbnails(query));if(!isNonEmptyArray(thumbnails)||statusCode!==MantaStatusCode.kOk){console.warn("Error generating thumbnails. Status code: ",statusCode)}const params=new URLSearchParams(window.location.search);const templateIdParam=params.get("seaPenTemplateId");if(!templateIdParam||templateIdParam===query.templateQuery?.id.toString()||templateIdParam===QUERY&&!!query.textQuery){store.dispatch(seaPenAction.setThumbnailResponseStatusCodeAction(statusCode));store.dispatch(seaPenAction.setSeaPenThumbnailsAction(query,thumbnails))}}export async function selectSeaPenThumbnail(thumbnail,provider,store){if(store.data.recentImages&&store.data.recentImages.includes(thumbnail.id)){return selectRecentSeaPenImage(thumbnail.id,provider,store)}let promise;store.dispatch(seaPenAction.beginSelectSeaPenThumbnailAction(thumbnail));const shouldPreview=await shouldShowFullscreenPreview(provider);if(shouldPreview){provider.makeTransparent();store.dispatch(seaPenAction.setSeaPenFullscreenStateAction(FullscreenPreviewState.LOADING))}if(isPersonalizationApp()){promise=withMinimumDelay(provider.selectSeaPenThumbnail(thumbnail.id,shouldPreview))}else{store.beginBatchUpdate();promise=provider.selectSeaPenThumbnail(thumbnail.id,shouldPreview)}const{success:success}=await promise;store.beginBatchUpdate();store.dispatch(seaPenAction.endSelectSeaPenThumbnailAction(thumbnail,success));if(!success){store.dispatch(seaPenAction.setSeaPenFullscreenStateAction(FullscreenPreviewState.OFF));store.dispatch(seaPenAction.setSelectedRecentSeaPenImageAction(store.data.currentSelected))}store.endBatchUpdate();if(success){const isTextQuery=!!store.data.currentSeaPenQuery?.textQuery;logSeaPenImageSet(isTextQuery,"Create");await fetchRecentSeaPenData(provider,store)}}export function clearSeaPenThumbnails(store){store.dispatch(seaPenAction.clearSeaPenThumbnailsAction())}export function cleanUpSeaPenQueryStates(store){store.beginBatchUpdate();store.dispatch(seaPenAction.setThumbnailResponseStatusCodeAction(null));store.dispatch(seaPenAction.clearCurrentSeaPenQueryAction());store.dispatch(seaPenAction.clearSeaPenThumbnailsLoadingAction());store.endBatchUpdate()}export async function deleteRecentSeaPenImage(id,provider,store){const{success:success}=await provider.deleteRecentSeaPenImage(id);if(success){fetchRecentSeaPenData(provider,store)}}export async function getRecentSeaPenImageIds(provider,store){store.dispatch(seaPenAction.beginLoadRecentSeaPenImagesAction());const{ids:ids}=await provider.getRecentSeaPenImageIds();if(ids==null){console.warn("Failed to fetch recent sea pen images")}store.dispatch(seaPenAction.setRecentSeaPenImagesAction(ids))}export async function fetchRecentSeaPenData(provider,store){if(!store.data.loading.recentImages){await getRecentSeaPenImageIds(provider,store)}await getMissingRecentSeaPenImageData(provider,store)}const recentSeaPenImageDataToFetch=new Set;async function getMissingRecentSeaPenImageData(provider,store){if(!Array.isArray(store.data.recentImages)){console.warn("Cannot fetch thumbnails with invalid image list");return}store.beginBatchUpdate();for(const id of store.data.recentImages){if(store.data.recentImageData[id]||store.data.loading.recentImageData[id]||recentSeaPenImageDataToFetch.has(id)){continue}recentSeaPenImageDataToFetch.add(id);store.dispatch(seaPenAction.beginLoadRecentSeaPenImageDataAction(id))}store.endBatchUpdate();while(recentSeaPenImageDataToFetch.size){await Promise.all(Array.from(recentSeaPenImageDataToFetch).map((async id=>{recentSeaPenImageDataToFetch.delete(id);const{thumbnailData:thumbnailData}=await provider.getRecentSeaPenImageThumbnail(id);if(!thumbnailData){console.warn("Failed to fetch recent Sea Pen image data",id)}store.dispatch(seaPenAction.setRecentSeaPenImageDataAction(id,thumbnailData))})))}}export function openFeedbackDialog(metadata,provider){provider.openFeedbackDialog(metadata)}export async function getShouldShowSeaPenIntroductionDialog(provider,store){const{shouldShowDialog:shouldShowDialog}=await provider.shouldShowSeaPenIntroductionDialog();store.dispatch(seaPenAction.setShouldShowSeaPenIntroductionDialogAction(shouldShowDialog))}export async function closeSeaPenIntroductionDialog(provider,store){if(!store.data.shouldShowSeaPenIntroductionDialog){return}await provider.handleSeaPenIntroductionDialogClosed();store.dispatch(seaPenAction.setShouldShowSeaPenIntroductionDialogAction(false))}export async function getShouldShowSeaPenFreeformIntroductionDialog(provider,store){const{shouldShowFreeformDialog:shouldShowFreeformDialog}=await provider.shouldShowSeaPenFreeformIntroductionDialog();store.dispatch(seaPenAction.setShouldShowSeaPenFreeformIntroductionDialogAction(shouldShowFreeformDialog))}export async function closeSeaPenFreeformIntroductionDialog(provider,store){if(!store.data.shouldShowSeaPenFreeformIntroductionDialog){return}await provider.handleSeaPenFreeformIntroductionDialogClosed();store.dispatch(seaPenAction.setShouldShowSeaPenFreeformIntroductionDialogAction(false))}async function shouldShowFullscreenPreview(provider){if(!isPersonalizationApp()||!isSeaPenTextInputEnabled()){return false}const{tabletMode:tabletMode}=await provider.isInTabletMode();return tabletMode}