// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import"chrome://resources/ash/common/personalization/common.css.js";import"chrome://resources/ash/common/personalization/cros_button_style.css.js";import"chrome://resources/ash/common/personalization/personalization_shared_icons.html.js";import"chrome://resources/ash/common/personalization/wallpaper.css.js";import{assertNotReached}from"chrome://resources/js/assert.js";import{IronA11yAnnouncer}from"chrome://resources/polymer/v3_0/iron-a11y-announcer/iron-a11y-announcer.js";import{FreeformTab,SEA_PEN_SAMPLES}from"./constants.js";import{getTemplate}from"./sea_pen_freeform_element.html.js";import{logSamplePromptShuffleClicked,logSeaPenFreeformTabClicked}from"./sea_pen_metrics_logger.js";import{WithSeaPenStore}from"./sea_pen_store.js";import{IronAnnounceEvent,isArrayEqual,isNonEmptyArray,shuffle}from"./sea_pen_utils.js";export class SeaPenFreeformElement extends WithSeaPenStore{static get is(){return"sea-pen-freeform"}static get template(){return getTemplate()}static get properties(){return{freeformTab_:{type:String,value:FreeformTab.SAMPLE_PROMPTS},seaPenQuery_:{type:Object,observer:"onSeaPenQueryChanged_"},samples:{type:Array},thumbnailResponseStatusCode_:{type:Object,observer:"onThumbnailResponseStatusCodeChanged_"},thumbnails_:{type:Object}}}ready(){super.ready();IronA11yAnnouncer.requestAvailability()}connectedCallback(){super.connectedCallback();this.watch("seaPenQuery_",(state=>state.currentSeaPenQuery));this.watch("thumbnailResponseStatusCode_",(state=>state.thumbnailResponseStatusCode));this.watch("thumbnails_",(state=>state.thumbnails));this.updateFromStore();this.shuffleSamplePrompts_();this.freeformTab_=this.isTabContainerHidden_(this.seaPenQuery_,this.thumbnailResponseStatusCode_,this.thumbnails_)?FreeformTab.SAMPLE_PROMPTS:FreeformTab.RESULTS;this.$.tabKeys.target=this.$.tabContainer}onTabSelected_(e){const currentTarget=e.currentTarget;switch(currentTarget.id){case"samplePromptsTab":this.freeformTab_=FreeformTab.SAMPLE_PROMPTS;break;case"resultsTab":this.freeformTab_=FreeformTab.RESULTS;break;default:assertNotReached()}logSeaPenFreeformTabClicked(this.freeformTab_)}onTabKeysPressed_(e){const focusedElement=this.shadowRoot.activeElement;focusedElement?.removeAttribute("tabindex");const nextTab=this.getOtherTab_(focusedElement);if(nextTab){nextTab.setAttribute("tabindex","0");nextTab.focus()}e.detail.keyboardEvent.preventDefault()}onSeaPenQueryChanged_(query){this.freeformTab_=query?.textQuery?FreeformTab.RESULTS:FreeformTab.SAMPLE_PROMPTS}onThumbnailResponseStatusCodeChanged_(statusCode){if(statusCode){this.freeformTab_=FreeformTab.RESULTS}}isTabContainerHidden_(query,thumbnailResponseStatusCode,thumbnails){return!query?.textQuery&&!thumbnailResponseStatusCode&&!isNonEmptyArray(thumbnails)}isSamplePromptsTabSelected_(tab){return tab===FreeformTab.SAMPLE_PROMPTS}isResultsTabSelected_(tab){return tab===FreeformTab.RESULTS}getSamplePromptsTabIndex_(tab){return this.isSamplePromptsTabSelected_(tab)?"0":"-1"}getResultsTabIndex_(tab){return this.isResultsTabSelected_(tab)?"0":"-1"}getOtherTab_(element){if(element===this.$.resultsTab){return this.$.samplePromptsTab}if(element===this.$.samplePromptsTab){return this.$.resultsTab}return null}onShuffleClicked_(){logSamplePromptShuffleClicked();this.shuffleSamplePrompts_();this.dispatchEvent(new IronAnnounceEvent(this.i18n("ariaAnnounceSamplePromptsShuffled")))}shuffleSamplePrompts_(){for(let i=0;i<5;i++){const newSamples=shuffle(SEA_PEN_SAMPLES).slice(0,6);if(!this.samples||!isArrayEqual(newSamples,this.samples)){this.samples=newSamples;break}}}}customElements.define(SeaPenFreeformElement.is,SeaPenFreeformElement);