// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import{assert}from"chrome://resources/js/assert.js";import{FreeformTab,QUERY,SeaPenSamplePromptId}from"./constants.js";import{SeaPenPaths}from"./sea_pen_router_element.js";import{isPersonalizationApp}from"./sea_pen_utils.js";const WALLPAPER_FREEFORM=999;const VC_BACKGROUND_FREEFORM=1e3;function getTemplateIdForMetrics(templateId){if(templateId===QUERY){return isPersonalizationApp()?WALLPAPER_FREEFORM:VC_BACKGROUND_FREEFORM}return templateId}export var RecentImageActionMenuItem;(function(RecentImageActionMenuItem){RecentImageActionMenuItem[RecentImageActionMenuItem["CREATE_MORE"]=0]="CREATE_MORE";RecentImageActionMenuItem[RecentImageActionMenuItem["DELETE"]=1]="DELETE";RecentImageActionMenuItem[RecentImageActionMenuItem["ABOUT"]=2]="ABOUT";RecentImageActionMenuItem[RecentImageActionMenuItem["MAX_VALUE"]=2]="MAX_VALUE"})(RecentImageActionMenuItem||(RecentImageActionMenuItem={}));export function logSeaPenTemplateFeedback(templateName,positiveFeedback){chrome.metricsPrivate.recordBoolean(`Ash.SeaPen.${templateName}.UserFeedback`,positiveFeedback)}export function logGenerateSeaPenWallpaper(templateId){const templateIdForMetrics=getTemplateIdForMetrics(templateId);assert(templateIdForMetrics<=VC_BACKGROUND_FREEFORM,`Template ID ${templateIdForMetrics} should not be greater than VC_BACKGROUND_FREEFORM.`);chrome.metricsPrivate.recordEnumerationValue("Ash.SeaPen.CreateButton",templateIdForMetrics,VC_BACKGROUND_FREEFORM+1)}export function logSeaPenTemplateSelect(templateId){const templateIdForMetrics=getTemplateIdForMetrics(templateId);assert(templateIdForMetrics<=VC_BACKGROUND_FREEFORM,`Template ID ${templateIdForMetrics} should not be greater than VC_BACKGROUND_FREEFORM.`);chrome.metricsPrivate.recordEnumerationValue("Ash.SeaPen.Template",templateIdForMetrics,VC_BACKGROUND_FREEFORM+1)}export function logRecentImageActionMenuItemClick(isTextQuery,menuItem){const appName=isPersonalizationApp()?"Wallpaper":"VcBackground";const histogramName=isTextQuery?`Ash.SeaPen.Freeform.${appName}.RecentImage.ActionMenu`:`Ash.SeaPen.${appName}.RecentImage.ActionMenu`;chrome.metricsPrivate.recordEnumerationValue(histogramName,menuItem,RecentImageActionMenuItem.MAX_VALUE+1)}export function logSeaPenImageSet(isTextQuery,source){const appName=isPersonalizationApp()?"Wallpaper":"VcBackground";const histogramName=isTextQuery?`Ash.SeaPen.Freeform.${appName}.${source}.ImageSet`:`Ash.SeaPen.${appName}.${source}.ImageSet`;chrome.metricsPrivate.recordBoolean(histogramName,true)}export function logSeaPenVisited(path){const appName=isPersonalizationApp()?"Wallpaper":"VcBackground";const histogramName=path===SeaPenPaths.FREEFORM?`Ash.SeaPen.Freeform.${appName}.Visited`:`Ash.SeaPen.${appName}.Visited`;chrome.metricsPrivate.recordBoolean(histogramName,true)}export function logSeaPenThumbnailClicked(templateId){const templateIdForMetrics=getTemplateIdForMetrics(templateId);assert(templateIdForMetrics<=VC_BACKGROUND_FREEFORM,`Template ID ${templateIdForMetrics} should not be greater than VC_BACKGROUND_FREEFORM.`);chrome.metricsPrivate.recordEnumerationValue("Ash.SeaPen.ThumbnailClicked",templateIdForMetrics,VC_BACKGROUND_FREEFORM+1)}export function logSuggestionClicked(){chrome.metricsPrivate.recordBoolean("Ash.SeaPen.Freeform.Suggestion.Clicked",true)}export function logSuggestionShuffleClicked(){chrome.metricsPrivate.recordBoolean("Ash.SeaPen.Freeform.Suggestion.Shuffle.Clicked",true)}export function logSamplePromptClicked(id){chrome.metricsPrivate.recordEnumerationValue("Ash.SeaPen.Freeform.SamplePrompt.SampleClicked",id,SeaPenSamplePromptId.MAX_VALUE)}export function logSamplePromptShuffleClicked(){chrome.metricsPrivate.recordBoolean("Ash.SeaPen.Freeform.SamplePrompt.Shuffle.Clicked",true)}export function logSeaPenFreeformTabClicked(freeformTab){let enumValue;switch(freeformTab){case FreeformTab.RESULTS:enumValue=0;break;case FreeformTab.SAMPLE_PROMPTS:enumValue=1;break}chrome.metricsPrivate.recordEnumerationValue("Ash.SeaPen.Freeform.Tab.Clicked",enumValue,2)}