// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import"chrome://resources/ash/common/personalization/common.css.js";import"chrome://resources/ash/common/personalization/cros_button_style.css.js";import{I18nMixin}from"chrome://resources/ash/common/cr_elements/i18n_mixin.js";import{afterNextRender,Debouncer,PolymerElement,timeOut}from"chrome://resources/polymer/v3_0/polymer/polymer_bundled.min.js";import{getTemplate}from"./sea_pen_options_element.html.js";import{isNonEmptyArray}from"./sea_pen_utils.js";const SeaPenOptionsElementBase=I18nMixin(PolymerElement);export class SeaPenOptionEscapeEvent extends CustomEvent{static{this.EVENT_NAME="sea-pen-option-escape"}constructor(){super(SeaPenOptionEscapeEvent.EVENT_NAME,{bubbles:true,composed:true,detail:null})}}export class SeaPenOptionsElement extends SeaPenOptionsElementBase{constructor(){super(...arguments);this.onResized_=()=>{this.debouncer_=Debouncer.debounce(this.debouncer_,timeOut.after(50),(()=>{this.calculateHiddenOptions_()}))}}static get is(){return"sea-pen-options"}static get template(){return getTemplate()}static get properties(){return{options:{type:Array},selectedChip:{type:Object,observer:"onSelectedChipChanged_"},selectedOptions:{type:Object,notify:true},chipsExpanded_:{type:Boolean,value:false},shouldShowExpandButton_:{type:Boolean,value:false},ironSelectedOption_:Object}}connectedCallback(){super.connectedCallback();window.addEventListener("resize",this.onResized_)}disconnectedCallback(){super.disconnectedCallback();window.removeEventListener("resize",this.onResized_)}focusOnTargetOption_(n){const prevButton=this.ironSelectedOption_;if(prevButton){prevButton.removeAttribute("tabindex")}this.$.optionSelector.selectIndex(n);this.ironSelectedOption_.setAttribute("tabindex","0");this.ironSelectedOption_.focus()}onOptionKeyPressed_(e){const selector=this.$.optionSelector;const prevButton=this.ironSelectedOption_;switch(e.detail.key){case"left":selector.selectPrevious();if(this.isHiddenOptionSelected_()){selector.selectIndex(this.getLastVisibleChipOptionIndex_())}break;case"right":selector.selectNext();if(this.isHiddenExpandButtonSelected_()){selector.selectIndex(0)}else if(this.isHiddenChipOptionSelected_()){const expandButton=selector.querySelector("#expandButton");selector.selectIndex(selector.indexOf(expandButton))}break;case"esc":this.dispatchEvent(new SeaPenOptionEscapeEvent);return;default:return}if(prevButton){prevButton.removeAttribute("tabindex")}if(this.ironSelectedOption_){this.ironSelectedOption_.setAttribute("tabindex","0");this.ironSelectedOption_.focus()}e.detail.keyboardEvent.preventDefault()}onClickOption_(event){const option=event.model.option;this.selectedOptions.set(this.selectedChip.id,option);const copiedSelectedOptions=this.selectedOptions;this.selectedOptions=new Map;this.selectedOptions=copiedSelectedOptions;event.preventDefault();event.stopPropagation()}isHiddenOptionSelected_(){return this.ironSelectedOption_.classList.contains("hidden")}isHiddenExpandButtonSelected_(){return this.ironSelectedOption_?.id==="expandButton"&&this.isHiddenOptionSelected_()}isHiddenChipOptionSelected_(){return this.ironSelectedOption_.classList.contains("option")&&this.isHiddenOptionSelected_()}isSelected_(option,selectedChip,selectedOptions){return!!selectedOptions&&!!selectedChip&&selectedOptions.has(selectedChip.id)&&option===selectedOptions.get(selectedChip.id)}getLastVisibleChipOptionIndex_(){const options=this.shadowRoot.querySelectorAll(".option:not(.hidden)");return options.length>0?options.length-1:0}getOptionTabIndex_(option,selectedChip,selectedOptions){return this.isSelected_(option,selectedChip,selectedOptions)?"0":"-1"}getOptionAriaChecked_(option,selectedChip,selectedOptions){return this.isSelected_(option,selectedChip,selectedOptions).toString()}calculateHiddenOptions_(){if(this.chipsExpanded_||!isNonEmptyArray(this.options)){return}this.shouldShowExpandButton_=true;const items=Array.from(this.shadowRoot.querySelectorAll(".option"));this.$.expandButton.innerText=this.i18n("seaPenExpandOptionsButton",items.length);const gap=8;const expandButtonWidth=this.$.expandButton.clientWidth+gap;let row=1;let remainingWidth=this.$.container.clientWidth;let numHiddenItems=0;items.forEach(((item,i)=>{item.classList.remove("hidden");const itemWidth=item.clientWidth+gap;if(itemWidth<=remainingWidth){remainingWidth-=itemWidth}else{switch(row){case 1:remainingWidth=this.$.container.clientWidth-itemWidth-expandButtonWidth;row++;break;case 2:if(i<this.options.length-1||itemWidth>remainingWidth+expandButtonWidth){numHiddenItems=this.options.length-i;item.classList.add("hidden")}remainingWidth=0;row++;break;case 3:item.classList.add("hidden");break}}}));this.shouldShowExpandButton_=numHiddenItems>0;if(this.shouldShowExpandButton_){this.$.expandButton.innerText=this.i18n("seaPenExpandOptionsButton",numHiddenItems)}}onClickExpandButton_(event){this.chipsExpanded_=true;this.shouldShowExpandButton_=false;let firstHiddenIndex=-1;this.shadowRoot.querySelectorAll(".option").forEach(((option,index)=>{if(firstHiddenIndex===-1&&option.classList.contains("hidden")){firstHiddenIndex=index}option.classList.remove("hidden")}));if(firstHiddenIndex>=0){afterNextRender(this,(()=>{this.focusOnTargetOption_(firstHiddenIndex)}))}event.preventDefault();event.stopPropagation()}onSelectedChipChanged_(){this.chipsExpanded_=false;this.shouldShowExpandButton_=false;afterNextRender(this,(()=>{this.calculateHiddenOptions_();this.focusOnTargetOption_(0)}))}getOptionsClassName_(chipsExpanded){return chipsExpanded?"expanded":""}getExpandButtonClassName_(shouldShowExpandButton){return shouldShowExpandButton?"":"hidden"}}customElements.define(SeaPenOptionsElement.is,SeaPenOptionsElement);