import{html}from"//resources/polymer/v3_0/polymer/polymer_bundled.min.js";export function getTemplate(){return html`<!--_html_template_start_--><style include="wallpaper common sea-pen">:host{display:block;overflow:hidden}iron-list{width:100%}.recent-image-container{height:calc(var(--personalization-app-grid-item-height) + var(--personalization-app-grid-item-spacing));width:calc(100% / 3 - 0.34px)}@media (min-width:720px){.recent-image-container{width:calc(100% / 4 - 0.25px)}}.menu-icon-container{align-items:flex-end;bottom:10px;display:flex;justify-content:flex-end;height:28px;position:absolute;right:10px;width:28px;z-index:1}.menu-icon-container-inner{align-items:flex-end;background-color:var(--cros-bg-color);border-bottom-right-radius:12px;border-top-left-radius:50%;bottom:0;display:flex;height:28px;justify-content:flex-end;position:absolute;right:0;width:28px}div[class^="menu-icon-container-shadow"]{height:10px;overflow:hidden;position:absolute;width:10px}div[class^="menu-icon-container-shadow"]::before{border-bottom-right-radius:100%;bottom:0;box-shadow:0px 10px 0px 10px var(--cros-bg-color);content:'';height:100%;position:absolute;right:0;width:100%}.menu-icon-container-shadow-left{bottom:0;right:28px}.menu-icon-container-shadow-top{bottom:28px;right:0}.menu-icon-button{--cr-icon-button-size:20px;background-color:var(--cros-bg-color);bottom:2px;margin-inline:0;position:absolute;right:2px}.menu-icon-button:focus-visible:focus{box-shadow:none;outline:2px solid var(--cros-sys-focus_ring);outline-offset:1px}.dropdown-item>iron-icon{--iron-icon-fill-color:var(--cros-sys-on_surface);--iron-icon-height:20px;--iron-icon-width:20px;margin-inline-end:16px}#wallpaperInfoDialog::part(dialog){border-radius:20px;position:fixed}@media (max-width:671px){#wallpaperInfoDialog::part(dialog){width:440px}}#wallpaperInfoTitle{color:var(--cros-sys-on_surface);font:var(--cros-display-7-font);padding:32px 32px 16px}#wallpaperInfoBody{padding:0 32px}#wallpaperInfoBody:focus{outline:none}#wallpaperInfoBody p{color:var(--cros-sys-on_surface_variant);font:var(--cros-body-1-font);margin:0 0 16px}#wallpaperInfoButtonContainer{padding:16px 32px 28px}#wallpaperInfoCloseButton{border-radius:16px}</style>
<template is="dom-if" if="[[shouldShowRecentlyUsedWallpapers_(recentImagesToDisplay_)]]">
  <h2 id="recentImagesHeading" class="wallpaper-collections-heading">[[getRecentPoweredByGoogleMessage_()]]</h2>
  <iron-list id="grid"
      items="[[recentImagesToDisplay_]]"
      as="image"
      grid
      aria-labelledby="recentImagesHeading"
      aria-setsize$="[[recentImagesToDisplay_.length]]"
      role="listbox">
    <template>
      <div class="recent-image-container">
        <wallpaper-grid-item
            class="sea-pen-image recent-used-image"
            disabled="[[isRecentImageLoading_(image, recentImageDataLoading_)]]"
            index="[[index]]"
            data-sea-pen-image
            aria-label$="[[getAriaLabel_(image, recentImageData_, recentImageDataLoading_)]]"
            aria-posinset$="[[getAriaIndex_(index)]]"
            on-wallpaper-grid-item-selected="onRecentImageSelected_"
            role="option"
            selected="[[isRecentImageSelected_(image, currentSelected_, pendingSelected_)]]"
            src="[[getRecentImageUrl_(image, recentImageData_, recentImageDataLoading_)]]"
            tabindex$="[[tabIndex]]">
        </wallpaper-grid-item>
        <div class="menu-icon-container">
          <div class="menu-icon-container-inner">
            <cr-icon-button
                class="menu-icon-button"
                data-id$="[[index]]"
                iron-icon="cr:more-vert"
                aria-label$="[[i18n('seaPenRecentImageMenuButton')]]"
                aria-description$="[[getAriaLabel_(image, recentImageData_, recentImageDataLoading_)]]"
                role="button"
                on-click="onClickMenuIcon_"
                tabindex$="[[tabIndex]]">
            </cr-icon-button>
          </div>
          <div class="menu-icon-container-shadow-left"></div>
          <div class="menu-icon-container-shadow-top"></div>
        </div>
        <cr-action-menu
            class="action-menu-container"
            accessibility-label="[[i18n('seaPenRecentImageMenuButton')]]"
            role-description="[[i18n('seaPenMenuRoleDescription')]]">
          <template is="dom-if" if="[[shouldShowCreateMoreButton_(image, recentImageData_, recentImageDataLoading_)]]" restamp>
            <button data-id$="[[index]]" class="dropdown-item create-more-option"
                on-click="onClickCreateMore_">
              <iron-icon icon="cr:add"></iron-icon>
              [[i18n('seaPenCreateMore')]]
            </button>
          </template>
          <button class="dropdown-item delete-wallpaper-option"
              on-click="onClickDeleteWallpaper_">
            <iron-icon icon="sea-pen:delete"></iron-icon>
            [[i18n('seaPenDeleteWallpaper')]]
          </button>
          <template is="dom-if" if="[[shouldShowWallpaperInfoButton_(image, recentImageData_, recentImageDataLoading_)]]" restamp>
            <button data-id$="[[index]]" class="dropdown-item wallpaper-info-option"
                on-click="onClickWallpaperInfo_">
              <iron-icon icon="cr:info-outline"></iron-icon>
              [[i18n('seaPenAbout')]]
            </button>
          </template>
        </cr-action-menu>
        <template is="dom-if" if="[[shouldShowWallpaperInfoDialog_(index, currentShowWallpaperInfoDialog_)]]" restamp>
          <cr-dialog id="wallpaperInfoDialog" data-id$="[[index]]" on-close="onCloseDialog_" show-on-attach>
            <div id="wallpaperInfoTitle" slot="title">[[getAboutDialogTitle_()]]</div>
            <div id="wallpaperInfoBody" slot="body">
              <p class="about-prompt-info">
                [[getWallpaperInfoPromptMessage_(image, recentImageData_, recentImageDataLoading_)]]
              </p>
              <p class="about-date-info">
                [[getWallpaperInfoDateMessage_(image, recentImageData_, recentImageDataLoading_)]]
              </p>
            </div>
            <div id="wallpaperInfoButtonContainer" slot="button-container">
              <cr-button id="wallpaperInfoCloseButton" class="action-button primary" on-click="onCloseDialog_">
                [[i18n('seaPenAboutDialogClose')]]
              </cr-button>
            </div>
          </cr-dialog>
        </template>
      </div>
    </template>
  </iron-list>
</template>
<!--_html_template_end_-->`}