// Copyright 2023 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import"chrome://resources/ash/common/personalization/common.css.js";import"chrome://resources/ash/common/personalization/wallpaper.css.js";import"./sea_pen.css.js";import"./sea_pen_icons.html.js";import"chrome://resources/ash/common/cr_elements/cr_action_menu/cr_action_menu.js";import"chrome://resources/polymer/v3_0/iron-icon/iron-icon.js";import{AnchorAlignment}from"chrome://resources/ash/common/cr_elements/cr_action_menu/cr_action_menu.js";import{assert}from"chrome://resources/js/assert.js";import{afterNextRender}from"chrome://resources/polymer/v3_0/polymer/polymer_bundled.min.js";import{isSeaPenTextInputEnabled}from"./load_time_booleans.js";import{deleteRecentSeaPenImage,fetchRecentSeaPenData,getSeaPenThumbnails,selectRecentSeaPenImage}from"./sea_pen_controller.js";import{getSeaPenProvider}from"./sea_pen_interface_provider.js";import{logRecentImageActionMenuItemClick,RecentImageActionMenuItem}from"./sea_pen_metrics_logger.js";import{getTemplate}from"./sea_pen_recent_wallpapers_element.html.js";import{SeaPenRouterElement}from"./sea_pen_router_element.js";import{WithSeaPenStore}from"./sea_pen_store.js";import{getUserVisibleQuery,isActiveSeaPenQuery,isImageDataUrl,isNonEmptyArray,isPersonalizationApp,isSeaPenImageId,isUrl}from"./sea_pen_utils.js";export class SeaPenRecentImageDeleteEvent extends CustomEvent{static{this.EVENT_NAME="sea-pen-recent-image-delete"}constructor(){super(SeaPenRecentImageDeleteEvent.EVENT_NAME,{bubbles:true,composed:true,detail:null})}}export class SeaPenRecentWallpapersElement extends WithSeaPenStore{static get is(){return"sea-pen-recent-wallpapers"}static get template(){return getTemplate()}static get properties(){return{recentImages_:{type:Array,observer:"onRecentImagesChanged_"},recentImageData_:Object,recentImageDataLoading_:Object,recentImagesToDisplay_:{type:Array,value:[]},currentShowWallpaperInfoDialog_:{type:Number,value:null},currentSelected_:Number,pendingSelected_:Object,isSeaPenTextInputEnabled_:{type:Boolean,value(){return isSeaPenTextInputEnabled()}}}}static get observers(){return["onRecentImageLoaded_(recentImageData_, recentImageDataLoading_)"]}connectedCallback(){super.connectedCallback();this.watch("recentImages_",(state=>state.recentImages));this.watch("recentImageData_",(state=>state.recentImageData));this.watch("recentImageDataLoading_",(state=>state.loading.recentImageData));this.watch("currentSelected_",(state=>state.currentSelected));this.watch("pendingSelected_",(state=>state.pendingSelected));this.updateFromStore();fetchRecentSeaPenData(getSeaPenProvider(),this.getStore())}onRecentImagesChanged_(recentImages){this.recentImagesToDisplay_=(recentImages||[]).filter((id=>{if(this.recentImageDataLoading_[id]===false){const dataUrl=this.recentImageData_[id]?.url;return isUrl(dataUrl)&&isImageDataUrl(dataUrl)}return true}))}onRecentImageLoaded_(recentImageData,recentImageDataLoading){if(!recentImageData||!recentImageDataLoading){return}for(let i=this.recentImagesToDisplay_.length-1;i>=0;i--){const id=this.recentImagesToDisplay_[i];const data=recentImageData[id];const validData=isUrl(data?.url)&&isImageDataUrl(data.url);const failed=recentImageDataLoading[id]===false&&!validData;if(failed){this.splice("recentImagesToDisplay_",i,1)}}}isRecentImageLoading_(recentImage,recentImageDataLoading){if(!recentImage||!recentImageDataLoading){return true}return!recentImageDataLoading.hasOwnProperty(recentImage)||recentImageDataLoading[recentImage]===true}getRecentImageUrl_(recentImage,recentImageData,recentImageDataLoading){if(!recentImage||this.isRecentImageLoading_(recentImage,recentImageDataLoading)){return null}const data=recentImageData[recentImage];if(!isUrl(data?.url)||!isImageDataUrl(data.url)){return{url:""}}return data.url}getWallpaperInfoPromptMessage_(recentImage,recentImageData,recentImageDataLoading){if(!recentImage||this.isRecentImageLoading_(recentImage,recentImageDataLoading)){return null}const data=recentImageData[recentImage];if(!data||!data.imageInfo||!data.imageInfo.query){return null}const title=isPersonalizationApp()?"seaPenAboutDialogPrompt":"vcBackgroundAboutDialogPrompt";return this.i18n(title,getUserVisibleQuery(data.imageInfo.query))}getWallpaperInfoDateMessage_(recentImage,recentImageData,recentImageDataLoading){if(!recentImage||this.isRecentImageLoading_(recentImage,recentImageDataLoading)){return null}const data=recentImageData[recentImage];if(!data||!data.imageInfo||!data.imageInfo.creationTime){return null}return this.i18n("seaPenAboutDialogDate",data.imageInfo.creationTime)}getAboutDialogTitle_(){return isPersonalizationApp()?this.i18n("seaPenAboutDialogTitle"):this.i18n("vcBackgroundAboutDialogTitle")}getRecentPoweredByGoogleMessage_(){return isPersonalizationApp()?this.i18n("seaPenRecentWallpapersHeading"):this.i18n("vcBackgroundRecentWallpapersHeading")}getAriaLabel_(image,recentImageData,recentImageDataLoading){if(!image||this.isRecentImageLoading_(image,recentImageDataLoading)){return this.i18n("ariaLabelLoading")}const data=recentImageData[image];if(!data||!data.imageInfo||!data.imageInfo.query){return""}return getUserVisibleQuery(data.imageInfo.query)}getAriaIndex_(i){return i+1}shouldShowRecentlyUsedWallpapers_(recentImagesToDisplay){return isNonEmptyArray(recentImagesToDisplay)}isRecentImageSelected_(id,currentSelected,pendingSelected){if(!isSeaPenImageId(id)){return false}if(pendingSelected!==null){if(isSeaPenImageId(pendingSelected)){return id===pendingSelected}else{return id===pendingSelected.id}}return id===currentSelected}onRecentImageSelected_(event){assert(isSeaPenImageId(event.model.image),"recent Sea Pen image is a positive number");selectRecentSeaPenImage(event.model.image,getSeaPenProvider(),this.getStore())}onClickMenuIcon_(e){const targetElement=e.currentTarget;const menuIconContainerRect=targetElement.getBoundingClientRect();const config={top:menuIconContainerRect.top-8,left:menuIconContainerRect.left-menuIconContainerRect.width/2,height:menuIconContainerRect.height,width:menuIconContainerRect.width,anchorAlignmentX:AnchorAlignment.AFTER_END,anchorAlignmentY:AnchorAlignment.BEFORE_START};const id=targetElement.dataset["id"];if(id!==undefined){const index=parseInt(id,10);const menuElement=this.shadowRoot.querySelectorAll("cr-action-menu")[index];menuElement.showAtPosition(config);const menuItems=menuElement.querySelectorAll(".dropdown-item:not([hidden]):not(.more-like-this-option)");menuItems[0].focus()}}onClickCreateMore_(event){assert(isSeaPenImageId(event.model.image),"selected Sea Pen image is a positive number");const image=event.model.image;if(!image||this.isRecentImageLoading_(image,this.recentImageDataLoading_)){return}const seaPenQuery=this.recentImageData_[image]?.imageInfo?.query;if(!seaPenQuery){return}const templateId=seaPenQuery.textQuery?"Query":seaPenQuery.templateQuery?.id;logRecentImageActionMenuItemClick(!!seaPenQuery.textQuery,RecentImageActionMenuItem.CREATE_MORE);SeaPenRouterElement.instance().selectSeaPenTemplate(templateId);getSeaPenThumbnails(seaPenQuery,getSeaPenProvider(),this.getStore())}async onClickDeleteWallpaper_(event){assert(isSeaPenImageId(event.model.image),"selected Sea Pen image is a positive number");const index=event.model.index;const isLastOrOnlyImage=this.recentImagesToDisplay_.length===1||index===this.recentImagesToDisplay_.length-1;await deleteRecentSeaPenImage(event.model.image,getSeaPenProvider(),this.getStore());const isTextQuery=!!this.recentImageData_[event.model.image]?.imageInfo?.query?.textQuery;logRecentImageActionMenuItemClick(isTextQuery,RecentImageActionMenuItem.DELETE);this.closeAllActionMenus_();if(isLastOrOnlyImage){this.dispatchEvent(new SeaPenRecentImageDeleteEvent);return}afterNextRender(this,(()=>{const recentImageContainers=this.shadowRoot.querySelectorAll(".recent-image-container:not([hidden])");const recentImage=recentImageContainers[index].querySelector(".sea-pen-image");recentImage.setAttribute("tabindex","0");recentImage.focus();const menuIconButton=recentImageContainers[index].querySelector(".menu-icon-button");menuIconButton.setAttribute("tabindex","0")}))}onClickWallpaperInfo_(event){this.currentShowWallpaperInfoDialog_=event.model.index;const isTextQuery=!!this.recentImageData_[event.model.image]?.imageInfo?.query?.textQuery;logRecentImageActionMenuItemClick(isTextQuery,RecentImageActionMenuItem.ABOUT);this.closeAllActionMenus_()}closeAllActionMenus_(){const menuElements=this.shadowRoot.querySelectorAll("cr-action-menu");menuElements.forEach((menuElement=>{menuElement.close()}))}shouldShowCreateMoreButton_(recentImage,recentImageData,recentImageDataLoading){if(!this.isSeaPenTextInputEnabled_||!recentImage||this.isRecentImageLoading_(recentImage,recentImageDataLoading)){return false}const data=recentImageData[recentImage];return isActiveSeaPenQuery(data?.imageInfo?.query)}shouldShowWallpaperInfoButton_(recentImage,recentImageData,recentImageDataLoading){if(!recentImage||this.isRecentImageLoading_(recentImage,recentImageDataLoading)){return false}const data=recentImageData[recentImage];return!!data&&!!data.imageInfo&&!!data.imageInfo.creationTime&&!!data.imageInfo.query}shouldShowWallpaperInfoDialog_(i,currentShowWallpaperInfoDialog){return currentShowWallpaperInfoDialog===i}onCloseDialog_(){const menuId=this.currentShowWallpaperInfoDialog_;this.currentShowWallpaperInfoDialog_=null;afterNextRender(this,(()=>{const menuButtons=this.shadowRoot.querySelectorAll(".menu-icon-button");if(menuId!==null&&menuButtons.length>menuId+1){menuButtons[menuId].focus()}}))}}customElements.define(SeaPenRecentWallpapersElement.is,SeaPenRecentWallpapersElement);