// Copyright 2023 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import"chrome://resources/ash/common/cr_elements/cr_dialog/cr_dialog.js";import"chrome://resources/polymer/v3_0/iron-location/iron-location.js";import"chrome://resources/polymer/v3_0/iron-location/iron-query-params.js";import"./sea_pen_freeform_element.js";import"./sea_pen_images_element.js";import"./sea_pen_input_query_element.js";import"./sea_pen_introduction_dialog_element.js";import"./sea_pen_recent_wallpapers_element.js";import"./sea_pen_samples_element.js";import"./sea_pen_template_query_element.js";import"./sea_pen_templates_element.js";import"./sea_pen_toast_element.js";import{assert}from"chrome://resources/js/assert.js";import{afterNextRender}from"chrome://resources/polymer/v3_0/polymer/polymer_bundled.min.js";import{QUERY}from"./constants.js";import{isSeaPenEnabled,isSeaPenTextInputEnabled}from"./load_time_booleans.js";import{cleanUpSeaPenQueryStates,closeSeaPenFreeformIntroductionDialog,closeSeaPenIntroductionDialog,getShouldShowSeaPenFreeformIntroductionDialog,getShouldShowSeaPenIntroductionDialog}from"./sea_pen_controller.js";import{getSeaPenProvider}from"./sea_pen_interface_provider.js";import{logSeaPenVisited}from"./sea_pen_metrics_logger.js";import{SeaPenObserver}from"./sea_pen_observer.js";import{getTemplate}from"./sea_pen_router_element.html.js";import{WithSeaPenStore}from"./sea_pen_store.js";import{getTemplateIdFromString,isPersonalizationApp}from"./sea_pen_utils.js";import{maybeDoPageTransition}from"./transition.js";export var SeaPenPaths;(function(SeaPenPaths){SeaPenPaths["TEMPLATES"]="";SeaPenPaths["RESULTS"]="/results";SeaPenPaths["FREEFORM"]="/freeform"})(SeaPenPaths||(SeaPenPaths={}));let instance=null;export class SeaPenRouterElement extends WithSeaPenStore{static get is(){return"sea-pen-router"}static get template(){return getTemplate()}static get properties(){return{basePath:String,path_:String,query_:String,queryParams_:Object,relativePath_:{type:String,computed:"computeRelativePath_(path_, basePath)",observer:"onRelativePathChanged_"},showSeaPenIntroductionDialog_:Boolean,showSeaPenFreeformIntroductionDialog_:Boolean}}static instance(){assert(instance,"sea pen router does not exist");return instance}connectedCallback(){assert(isSeaPenEnabled(),"sea pen must be enabled");super.connectedCallback();instance=this;this.watch("showSeaPenIntroductionDialog_",(state=>state.shouldShowSeaPenIntroductionDialog));this.watch("showSeaPenFreeformIntroductionDialog_",(state=>state.shouldShowSeaPenFreeformIntroductionDialog));this.updateFromStore();this.fetchIntroductionDialogStatus();this.fetchFreeformIntroductionDialogStatus();logSeaPenVisited(this.relativePath_);afterNextRender(this,(()=>SeaPenObserver.initSeaPenObserverIfNeeded()))}disconnectedCallback(){super.disconnectedCallback();instance=null}selectSeaPenTemplate(templateId){if(templateId===undefined){return}cleanUpSeaPenQueryStates(this.getStore());if(templateId===QUERY){this.goToRoute(SeaPenPaths.FREEFORM);return}this.goToRoute(SeaPenPaths.RESULTS,{seaPenTemplateId:templateId.toString()})}async goToRoute(relativePath,queryParams={}){assert(typeof this.basePath==="string","basePath must be set");const routingPath=this.basePath+relativePath;if(this.path_===routingPath){this.setProperties({queryParams_:queryParams});return Promise.resolve()}return maybeDoPageTransition((()=>this.setProperties({path_:routingPath,queryParams_:queryParams})))}computeRelativePath_(path,basePath){if(typeof path!=="string"||typeof basePath!=="string"){return null}if(!path.startsWith(basePath)){return null}const relativePath=path.substring(basePath.length);return relativePath==="/"?"":relativePath}onRelativePathChanged_(relativePath){if(typeof relativePath!=="string"){return}if(!Object.values(SeaPenPaths).includes(relativePath)){console.warn("SeaPenRouter unknown path",relativePath);this.goToRoute(SeaPenPaths.TEMPLATES)}if(!isPersonalizationApp()&&relativePath===SeaPenPaths.FREEFORM){console.warn("Attempt to navigate to freeform on unsupported platform");this.goToRoute(SeaPenPaths.TEMPLATES)}}shouldShowTemplateQuery_(relativePath,templateId){return relativePath===SeaPenPaths.RESULTS&&(!!templateId&&templateId!=="Query")}shouldShowSeaPenTemplates_(relativePath){if(typeof relativePath!=="string"){return false}return relativePath===SeaPenPaths.TEMPLATES}shouldShowSeaPenTemplateImages_(relativePath){if(typeof relativePath!=="string"){return false}return relativePath===SeaPenPaths.RESULTS}shouldShowSeaPenFreeform_(relativePath){return isSeaPenTextInputEnabled()&&relativePath===SeaPenPaths.FREEFORM&&isPersonalizationApp()}shouldSeaPenIntroductionDialog_(relativePath,showSeaPenFreeformIntroDialog,showSeaPenIntroDialog){if(!isSeaPenTextInputEnabled()||!isPersonalizationApp()){return showSeaPenIntroDialog}if(relativePath===SeaPenPaths.FREEFORM){return showSeaPenFreeformIntroDialog}return showSeaPenIntroDialog&&showSeaPenFreeformIntroDialog}getBottomContainerClass_(relativePath){return isSeaPenTextInputEnabled()&&relativePath!==SeaPenPaths.FREEFORM?"add-extra-spacing":""}onBottomContainerClicked_(){this.shadowRoot.querySelector("sea-pen-template-query")?.onOptionSelectionDone()}getTemplateIdFromQueryParams_(templateId){return getTemplateIdFromString(templateId)}async fetchIntroductionDialogStatus(){await getShouldShowSeaPenIntroductionDialog(getSeaPenProvider(),this.getStore())}async onCloseSeaPenIntroductionDialog_(){await closeSeaPenIntroductionDialog(getSeaPenProvider(),this.getStore());if(this.relativePath_!==SeaPenPaths.FREEFORM){this.focusOnFirstTemplate_()}}async fetchFreeformIntroductionDialogStatus(){await getShouldShowSeaPenFreeformIntroductionDialog(getSeaPenProvider(),this.getStore())}async onCloseSeaPenFreeformIntroductionDialog_(){await closeSeaPenFreeformIntroductionDialog(getSeaPenProvider(),this.getStore());if(this.relativePath_!==SeaPenPaths.FREEFORM){this.focusOnFirstTemplate_()}}onRecentTemplateImageDelete_(){this.focusOnFirstTemplate_()}focusOnFirstTemplate_(){const seaPenTemplates=this.shadowRoot.querySelector("sea-pen-templates");const firstTemplate=seaPenTemplates.shadowRoot.querySelector(".sea-pen-template");window.scrollTo(0,0);firstTemplate.focus()}}customElements.define(SeaPenRouterElement.is,SeaPenRouterElement);