// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import"chrome://resources/ash/common/personalization/personalization_shared_icons.html.js";import"chrome://resources/ash/common/personalization/common.css.js";import"chrome://resources/ash/common/personalization/cros_button_style.css.js";import"chrome://resources/polymer/v3_0/iron-a11y-keys/iron-a11y-keys.js";import"chrome://resources/polymer/v3_0/iron-selector/iron-selector.js";import{I18nMixin}from"chrome://resources/ash/common/cr_elements/i18n_mixin.js";import{assert}from"chrome://resources/js/assert.js";import{loadTimeData}from"chrome://resources/js/load_time_data.js";import{IronA11yAnnouncer}from"chrome://resources/polymer/v3_0/iron-a11y-announcer/iron-a11y-announcer.js";import{afterNextRender,Debouncer,PolymerElement,timeOut}from"chrome://resources/polymer/v3_0/polymer/polymer_bundled.min.js";import{SEA_PEN_SUGGESTIONS}from"./constants.js";import{logSuggestionClicked,logSuggestionShuffleClicked}from"./sea_pen_metrics_logger.js";import{getTemplate}from"./sea_pen_suggestions_element.html.js";import{IronAnnounceEvent,isArrayEqual,isNonEmptyArray,shuffle}from"./sea_pen_utils.js";const seaPenSuggestionSelectedEvent="sea-pen-suggestion-selected";export class SeaPenSuggestionSelectedEvent extends CustomEvent{constructor(suggestion){super(seaPenSuggestionSelectedEvent,{bubbles:true,composed:true,detail:suggestion})}}const SeaPenSuggestionsElementBase=I18nMixin(PolymerElement);export class SeaPenSuggestionsElement extends SeaPenSuggestionsElementBase{constructor(){super(...arguments);this.onResized_=()=>{this.debouncer_=Debouncer.debounce(this.debouncer_,timeOut.after(50),(()=>{this.getSelectableSuggestions_()}))}}static get is(){return"sea-pen-suggestions"}static get template(){return getTemplate()}static get properties(){return{suggestions_:{type:Array,observer:"onSuggestionsChanged_"},selectableSuggestions_:Array,hiddenSuggestions_:Object}}ready(){super.ready();IronA11yAnnouncer.requestAvailability();this.$.keys.target=this.$.suggestionSelector}connectedCallback(){super.connectedCallback();this.hiddenSuggestions_=new Set;this.suggestions_=[...SEA_PEN_SUGGESTIONS];this.shuffleSuggestions_();window.addEventListener("resize",this.onResized_)}disconnectedCallback(){super.disconnectedCallback();window.removeEventListener("resize",this.onResized_)}getSelectableSuggestions_(){if(!isNonEmptyArray(this.suggestions_)){return}this.selectableSuggestions_=this.suggestions_;afterNextRender(this,(()=>{const items=Array.from(this.shadowRoot.querySelectorAll(".suggestion"));const GAP=10;let remainingWidth=this.$.suggestionSelector.clientWidth-GAP;this.selectableSuggestions_=this.suggestions_.filter(((_,i)=>{const itemWidth=items[i].clientWidth+GAP;remainingWidth-=itemWidth;return remainingWidth>=0}))}))}onClickSuggestion_(event){const target=event.currentTarget;const suggestion=target.textContent?.trim();assert(suggestion);this.dispatchEvent(new SeaPenSuggestionSelectedEvent(suggestion));logSuggestionClicked();if(SEA_PEN_SUGGESTIONS.length-this.hiddenSuggestions_.size<4){this.shuffleSuggestions_()}else{this.hiddenSuggestions_.add(suggestion);this.splice("suggestions_",event.model.index,1);this.onSuggestionsChanged_()}}onShuffleClicked_(){logSuggestionShuffleClicked();this.shuffleSuggestions_();this.dispatchEvent(new IronAnnounceEvent(loadTimeData.getString("ariaAnnouncePromptSuggestionsShuffled")))}shuffleSuggestions_(){for(let i=0;i<5;i++){const filteredSuggestions=SEA_PEN_SUGGESTIONS.length-this.hiddenSuggestions_.size>3?SEA_PEN_SUGGESTIONS.filter((s=>!this.hiddenSuggestions_.has(s))):SEA_PEN_SUGGESTIONS;const newSuggestions=shuffle(filteredSuggestions);if(!isArrayEqual(newSuggestions,this.suggestions_)){this.suggestions_=newSuggestions;break}}this.hiddenSuggestions_=new Set}onSuggestionsChanged_(){this.getSelectableSuggestions_();requestAnimationFrame((()=>{const suggestions=this.$.suggestionSelector.items;const hasFocusableSuggestions=suggestions.some((el=>el.getAttribute("tabindex")==="0"));if(!hasFocusableSuggestions&&suggestions.length>0){this.$.suggestionSelector.selectIndex(0);suggestions[0].setAttribute("tabindex","0");suggestions[0].focus()}}))}onSuggestionKeyPressed_(e){const selector=this.$.suggestionSelector;const prevSuggestion=selector.selectedItem;switch(e.detail.key){case"left":selector.selectPrevious();break;case"right":selector.selectNext();break;default:return}if(prevSuggestion){prevSuggestion.removeAttribute("tabindex")}const currentSuggestion=selector.selectedItem;if(currentSuggestion){currentSuggestion.setAttribute("tabindex","0");currentSuggestion.focus()}e.detail.keyboardEvent.preventDefault()}getSuggestionTabIndex_(index){return index===0?"0":"-1"}}customElements.define(SeaPenSuggestionsElement.is,SeaPenSuggestionsElement);