// Copyright 2023 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import"chrome://resources/ash/common/personalization/common.css.js";import"chrome://resources/ash/common/personalization/cros_button_style.css.js";import"chrome://resources/ash/common/personalization/personalization_shared_icons.html.js";import"./sea_pen.css.js";import"./sea_pen_chip_text_element.js";import"./sea_pen_icons.html.js";import"./sea_pen_options_element.js";import"chrome://resources/cros_components/lottie_renderer/lottie-renderer.js";import{assert}from"chrome://resources/js/assert.js";import{loadTimeData}from"chrome://resources/js/load_time_data.js";import{afterNextRender,beforeNextRender}from"chrome://resources/polymer/v3_0/polymer/polymer_bundled.min.js";import{getSeaPenTemplates}from"./constants.js";import{isSeaPenTextInputEnabled,isSeaPenUseExptTemplateEnabled}from"./load_time_booleans.js";import{clearSeaPenThumbnails,getSeaPenThumbnails}from"./sea_pen_controller.js";import{getSeaPenProvider}from"./sea_pen_interface_provider.js";import{logGenerateSeaPenWallpaper}from"./sea_pen_metrics_logger.js";import{WithSeaPenStore}from"./sea_pen_store.js";import{getTemplate}from"./sea_pen_template_query_element.html.js";import{getDefaultOptions,getSelectedOptionsFromQuery,getTemplateTokens,isNonEmptyArray,isPersonalizationApp}from"./sea_pen_utils.js";import{getTransitionEnabled}from"./transition.js";function isSameOption(map1,map2){if(map1.size!==map2.size){return false}for(const[key,value]of map1.entries()){if(!map2.has(key)||map2.get(key)!==value){return false}}return true}export class SeaPenTemplateQueryElement extends WithSeaPenStore{static get is(){return"sea-pen-template-query"}static get template(){return getTemplate()}static get properties(){return{templateId:String,seaPenQuery_:{type:Object,value:null},seaPenTemplate_:{type:Object,computed:"computeSeaPenTemplate_(templateId)"},selectedOptions_:{type:Object,observer:"onSelectedOptionsChanged_"},templateTokens_:{type:Array},selectedChip_:{type:Object},options_:{type:Array},isSelectingOptions:{type:Boolean,reflectToAttribute:true},thumbnails_:{type:Object,observer:"updateSearchButton_"},thumbnailsLoading_:Boolean,searchButtonText_:{type:String,value(){return loadTimeData.getString("seaPenCreateButton")}},searchButtonIcon_:{type:String,value(){return"sea-pen:photo-spark"}},seaPenUseExptTemplateEnabled_:{type:Boolean,value(){return isSeaPenUseExptTemplateEnabled()}},autoplay_:{type:Boolean,value:false}}}static get observers(){return["onSeaPenTemplateOrQueryChanged_(seaPenTemplate_, seaPenQuery_)"]}connectedCallback(){super.connectedCallback();this.addEventListener("click",this.onClick_);this.watch("thumbnails_",(state=>state.thumbnails));this.watch("thumbnailsLoading_",(state=>state.loading.thumbnails));this.watch("seaPenQuery_",(state=>state.currentSeaPenQuery));this.updateFromStore();this.resizeObserver_=new ResizeObserver((()=>this.animateContainerHeight()));beforeNextRender(this,(()=>{this.containerOriginalHeight_=this.$.container.scrollHeight;this.$.container.style.height=`${this.containerOriginalHeight_}px`}))}disconnectedCallback(){super.disconnectedCallback();clearSeaPenThumbnails(this.getStore());this.resizeObserver_.disconnect();this.removeEventListener("click",this.onClick_)}onSeaPenOptionsDomChanged_(){const optionsContainer=this.shadowRoot.querySelector("sea-pen-options");if(optionsContainer){this.resizeObserver_.observe(optionsContainer)}}animateContainerHeight(){const optionsContainer=this.shadowRoot.querySelector("sea-pen-options");const optionsContainerHeight=optionsContainer?optionsContainer.scrollHeight:0;this.$.container.style.height=`${this.containerOriginalHeight_+optionsContainerHeight}px`}onOptionSelectionDone(){if(!this.selectedChip_){return}const selectedChipIndex=Array.from(this.shadowRoot.querySelectorAll(".chip-container")).findIndex((elem=>elem.classList.contains("selected")));this.clearSelectedChipState_();afterNextRender(this,(()=>{this.shadowRoot.querySelectorAll(".chip-text")[selectedChipIndex]?.focus()}))}startInspireIconAnimation_(){this.getInspireMeAnimationElement_()?.play()}stopInspireIconAnimation_(){this.getInspireMeAnimationElement_()?.stop()}clearSelectedChipState_(){if(this.selectedChip_){this.selectedChip_=null;this.options_=null;this.isSelectingOptions=false}}onClick_(){this.onOptionSelectionDone()}computeSeaPenTemplate_(templateId){const seaPenTemplates=getSeaPenTemplates();const correctTemplate=seaPenTemplates.find((seaPenTemplate=>seaPenTemplate.id.toString()===templateId));return correctTemplate}isChip_(token){return typeof token?.translation==="string"}onClickChip_(event){assert(this.isChip_(event.model.token),"Token must be a chip");if(this.selectedChip_?.id===event.model.token.id){this.clearSelectedChipState_()}else{this.selectedChip_=event.model.token;assert(this.seaPenTemplate_.options.has(this.selectedChip_.id),"options must exist");this.options_=this.seaPenTemplate_.options.get(this.selectedChip_.id);this.isSelectingOptions=true}event.preventDefault();event.stopPropagation()}onClickInspire_(event){for(let i=0;i<5;i++){const newOptions=getDefaultOptions(this.seaPenTemplate_,true);if(!isSameOption(newOptions,this.selectedOptions_)){this.selectedOptions_=newOptions;break}}this.onClickSearchButton_(event)}onSeaPenTemplateOrQueryChanged_(template,seaPenQuery){this.clearSelectedChipState_();this.selectedOptions_=getSelectedOptionsFromQuery(seaPenQuery,template)??getDefaultOptions(template)}onSelectedOptionsChanged_(){this.searchButtonText_=this.i18n("seaPenCreateButton");this.searchButtonIcon_="sea-pen:photo-spark";this.templateTokens_=getTemplateTokens(this.seaPenTemplate_,this.selectedOptions_)}getChipClassName_(chip,selectedChip){assert(this.isChip_(chip),"Token must be a chip");return!selectedChip||chip.id===selectedChip.id?"selected":"unselected"}isOptionSelected_(option,selectedChipTranslation){return(option.translation===selectedChipTranslation).toString()}getOptionClass_(option,selectedChipTranslation){return this.isOptionSelected_(option,selectedChipTranslation)==="true"?"action-button":"unselected-option"}getTextClassName_(selectedChip){return selectedChip?"unselected":""}getUserVisibleQueryInfo_(){const translatedTokens=this.templateTokens_.map((token=>this.isChip_(token)?token.translation:token));return{text:translatedTokens.join(" "),templateTitle:this.seaPenTemplate_.title}}getSeaPenTemplateId_(){return parseInt(this.templateId,10)}getTemplateRequest_(){const optionMap=new Map;this.selectedOptions_.forEach(((option,chip)=>{optionMap.set(chip,option.value)}));const id=this.getSeaPenTemplateId_();assert(!isNaN(id));return{templateQuery:{id:id,options:Object.fromEntries(optionMap),userVisibleQuery:this.getUserVisibleQueryInfo_()}}}getInspireMeAnimationElement_(){return this.shadowRoot?.querySelector("#inspireMeAnimation")}onClickSearchButton_(event){this.clearSelectedChipState_();getSeaPenThumbnails(this.getTemplateRequest_(),getSeaPenProvider(),this.getStore());logGenerateSeaPenWallpaper(this.getSeaPenTemplateId_());event.preventDefault();event.stopPropagation()}updateSearchButton_(thumbnails){if(!thumbnails){this.searchButtonText_=this.i18n("seaPenCreateButton");this.searchButtonIcon_="sea-pen:photo-spark"}else{this.searchButtonText_=this.i18n("seaPenRecreateButton");this.searchButtonIcon_="personalization-shared:refresh"}}shouldShowOptions_(options){return isNonEmptyArray(options)}shouldShowFreeformNavigationInfo_(thumbnailsLoading){return isSeaPenTextInputEnabled()&&isPersonalizationApp()&&!thumbnailsLoading}shouldEnableTextAnimation(selectedChip,token){return getTransitionEnabled()&&!!selectedChip&&selectedChip.id===token.id}getTemplateAriaLabel_(){return this.getUserVisibleQueryInfo_().text}}customElements.define(SeaPenTemplateQueryElement.is,SeaPenTemplateQueryElement);