import{html}from"//resources/polymer/v3_0/polymer/polymer_bundled.min.js";export function getTemplate(){return html`<!--_html_template_start_--><style include="wallpaper common">:host{overflow:hidden}#templateHeading{margin-top:18px}iron-list{width:100%}.template-chip{border-bottom:2px dotted white}.template-info{font:var(--cros-body-1-font)}#templateTitle{display:flex;flex-direction:row;flex-wrap:wrap;justify-content:center;gap:4px;text-wrap:wrap}wallpaper-grid-item[data-sea-pen-image]::part(text){position:unset}wallpaper-grid-item:hover::part(image){filter:brightness(55%)}wallpaper-grid-item::part(textShadow){background:linear-gradient(rgba(var(--google-grey-900-rgb),0),rgba(var(--google-grey-900-rgb),40%));height:100%}</style>
<!-- TODO(b/308200616): Add real text -->
<h2 id="templateHeading" class="wallpaper-collections-heading">[[i18n('seaPenTemplateHeading')]]</h2>
<iron-list id="grid"
    items="[[seaPenTemplates_]]"
    as="template"
    grid
    aria-labelledby="templateHeading"
    aria-setsize$="[[seaPenTemplates_.length]]"
    role="listbox">
  <template>
    <wallpaper-grid-item
        class="sea-pen-template"
        index="[[index]]"
        data-sea-pen-image
        aria-posinset$="[[getAriaIndex_(index)]]"
        on-mouseout="onMouseOut_"
        on-mouseover="onMouseOver_"
        on-wallpaper-grid-item-selected="onTemplateSelected_"
        primary-text="[[template.title]]"
        role="option"
        src="[[template.preview]]"
        tabindex$="[[tabIndex]]">
        <div id="templateTitle" slot="text" class="primary-text">
          <template is="dom-if" if="[[shouldShowTemplateTitle_(template, hoveredTemplate_)]]">
            <template is="dom-repeat" items="[[getTemplateTokens_(template)]]" as="token">
              <template is="dom-if" if="[[isChip_(token)]]">
                <div class="template-chip template-info">
                  [[token.translation]]
                </div>
              </template>
              <template is="dom-if" if="[[!isChip_(token)]]">
                <div class="template-info">
                  [[token]]
                </div>
              </template>
            </template>
          </template>
          <template is="dom-if" if="[[!shouldShowTemplateTitle_(template, hoveredTemplate_)]]">
            [[template.title]]
          </template>
        </div>
      </template>
    </wallpaper-grid-item>
  </template>
</iron-list>
<!--_html_template_end_-->`}