// Copyright 2023 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import SPARKLE_SHADER_SOURCE from"./sparkle_shader.js";const VERTEX_SHADER_SOURCE=`#version 100\nprecision highp float;\n\nattribute vec2 a_position;\n\nvoid main() {\n  gl_Position = vec4(a_position, 0, 1);\n}\n`;function createShader(gl,type,source){const shader=gl.createShader(type);if(shader==null){throw new Error("Failed to create WebGLShader")}gl.shaderSource(shader,source);gl.compileShader(shader);if(!gl.getShaderParameter(shader,gl.COMPILE_STATUS)){console.warn(gl.getShaderInfoLog(shader));gl.deleteShader(shader);throw new Error("Failed to compile shader")}return shader}function linkProgram(gl,vertexShader,fragmentShader){const program=gl.createProgram();if(program==null){throw new Error("Failed to create WebGLProgram")}gl.attachShader(program,vertexShader);gl.attachShader(program,fragmentShader);gl.linkProgram(program);if(!gl.getProgramParameter(program,gl.LINK_STATUS)){console.warn(gl.getProgramInfoLog(program));gl.deleteShader(vertexShader);gl.deleteShader(fragmentShader);gl.deleteProgram(program);throw new Error("Failed to link program")}return program}class DrawSurface{constructor(gl,program){this.gl=null;this.buffer=null;this.positions=new Float32Array([-1,-1,1,-1,-1,1,-1,1,1,-1,1,1]);this.gl=gl;const buffer=this.buffer=gl.createBuffer();if(!buffer){throw new Error("Failed to create WebGLBuffer for DrawSurface")}gl.bindBuffer(gl.ARRAY_BUFFER,buffer);gl.bufferData(gl.ARRAY_BUFFER,this.positions,gl.STATIC_DRAW);const location=gl.getAttribLocation(program,"a_position");gl.enableVertexAttribArray(location);gl.vertexAttribPointer(location,2,gl.FLOAT,false,0,0)}dispose(){const{gl:gl,buffer:buffer}=this;if(gl!=null&&buffer!=null){gl.deleteBuffer(buffer)}this.gl=null;this.buffer=null}}export class Sparkle{constructor(){this.canvas=document.createElement("canvas");this.element=this.canvas;this.gl=null;this.instancing=null;this.vertexShader=null;this.fragmentShader=null;this.program=null;this.drawSurface=null;this.rendering=false;this.width=-1;this.height=-1;this.dpr=1;this.topLeftBackgroundColor=[1,1,1,1];this.bottomRightBackgroundColor=[1,1,1,1];this.sparkleColor=[1,1,1,1];this.noiseMove=[0,0,0];this.applyNoise=false;this.gridNum=1.2;this.inverseLuma=-1;this.opacity=1;this.then=performance.now();this.needsUpdate=true}get initialized(){return this.gl!=null}setTopLeftBackgroundColor(color){this.topLeftBackgroundColor=color;this.needsUpdate=true}setBottomRightBackgroundColor(color){this.bottomRightBackgroundColor=color;this.needsUpdate=true}setSparkleColor(color){this.sparkleColor=color;this.needsUpdate=true}setGridCount(gridNumber){this.gridNum=gridNumber;this.needsUpdate=true}setLumaMatteFactors(lumaMatteBlendFactor=1,lumaMatteOverallBrightness=0){this.lumaMatteBlendFactor=lumaMatteBlendFactor;this.lumaMatteOverallBrightness=lumaMatteOverallBrightness;this.needsUpdate=true}setInverseNoiseLuminosity(inverse){this.inverseLuma=inverse?-1:1;this.needsUpdate=true}setOpacity(opacity){this.opacity=opacity;this.needsUpdate=true}applyNoiseOffset(){this.applyNoise=true}reset(){this.width=-1;this.height=-1}resize(width,height){if(width===this.width&&height===this.height){return}const{dpr:dpr}=this;this.width=width;this.height=height;this.canvas.width=width*dpr;this.canvas.height=height*dpr;const{gl:gl}=this;if(gl!=null){gl.viewport(0,0,width*dpr,height*dpr)}}startRendering(){if(this.rendering){return}this.rendering=true;this.render()}stopRendering(){if(this.rendering===false){return}this.rendering=false}render(){if(this.rendering===false){return}const{gl:gl,instancing:instancing,program:program,dpr:dpr}=this;if(gl==null||instancing==null||program==null){this.stopRendering();return}gl.uniform1f(gl.getUniformLocation(program,"u_time"),performance.now()-this.then);gl.uniform2f(gl.getUniformLocation(program,"u_resolution"),this.width*dpr,this.height*dpr);const initialX=this.noiseMove[0];const initialY=this.noiseMove[1];const initialZ=this.noiseMove[2];if(this.applyNoise){const NOISE_MOVE_OFFSET=.006;this.noiseMove=[initialX-NOISE_MOVE_OFFSET,initialY,initialZ+NOISE_MOVE_OFFSET]}gl.uniform3f(gl.getUniformLocation(program,"u_noise_move"),...this.noiseMove);if(this.needsUpdate){gl.uniform4f(gl.getUniformLocation(program,"u_top_left_background_color"),...this.topLeftBackgroundColor);gl.uniform4f(gl.getUniformLocation(program,"u_bottom_right_background_color"),...this.bottomRightBackgroundColor);gl.uniform4f(gl.getUniformLocation(program,"u_sparkle_color"),...this.sparkleColor);gl.uniform1f(gl.getUniformLocation(program,"u_grid_num"),this.gridNum);gl.uniform1f(gl.getUniformLocation(program,"u_luma_matte_blend_factor"),this.lumaMatteBlendFactor);gl.uniform1f(gl.getUniformLocation(program,"u_luma_matte_overall_brightness"),this.lumaMatteOverallBrightness);gl.uniform1f(gl.getUniformLocation(program,"u_inverse_luma"),this.inverseLuma);gl.uniform1f(gl.getUniformLocation(program,"u_opacity"),this.opacity)}this.needsUpdate=false;instancing.drawArraysInstancedANGLE(gl.TRIANGLES,0,6,10);requestAnimationFrame((()=>{this.render()}))}initialize(){if(this.initialized){return}const gl=this.gl=this.canvas.getContext("webgl",{premultipliedAlpha:true,alpha:true});if(gl==null){return}this.instancing=gl.getExtension("ANGLE_instanced_arrays");if(!this.instancing){throw new Error("Could not activate WebGL instancing extension")}this.vertexShader=createShader(gl,gl.VERTEX_SHADER,VERTEX_SHADER_SOURCE);this.fragmentShader=createShader(gl,gl.FRAGMENT_SHADER,SPARKLE_SHADER_SOURCE);const program=this.program=linkProgram(gl,this.vertexShader,this.fragmentShader);gl.clearColor(0,0,0,0);gl.enable(gl.BLEND);gl.disable(gl.DEPTH_TEST);gl.disable(gl.CULL_FACE);gl.blendEquation(gl.FUNC_ADD);gl.blendFunc(gl.ONE,gl.ONE_MINUS_SRC_ALPHA);gl.useProgram(program);gl.uniform1f(gl.getUniformLocation(program,"u_pixel_density"),this.dpr);this.drawSurface=new DrawSurface(gl,program)}dispose(){if(!this.initialized){return}this.drawSurface?.dispose();const gl=this.gl;if(gl!=null){gl.deleteProgram(this.program);gl.deleteShader(this.vertexShader);gl.deleteShader(this.fragmentShader);gl.getExtension("WEBGL_lose_context")?.loseContext()}this.drawSurface=null;this.program=null;this.vertexShader=null;this.fragmentShader=null;this.instancing=null;this.gl=null}}