// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import"chrome://resources/ash/common/cr_elements/icons.html.js";import"chrome://resources/polymer/v3_0/iron-icon/iron-icon.js";import"./data_point.js";import"./diagnostics_card.js";import"./diagnostics_shared.css.js";import"./icons.html.js";import"./realtime_cpu_chart.js";import"./routine_section.js";import"/strings.m.js";import{I18nMixin}from"chrome://resources/ash/common/cr_elements/i18n_mixin.js";import{loadTimeData}from"chrome://resources/ash/common/load_time_data.m.js";import{PolymerElement}from"chrome://resources/polymer/v3_0/polymer/polymer_bundled.min.js";import{getTemplate}from"./cpu_card.html.js";import{convertKibToMib}from"./diagnostics_utils.js";import{getSystemDataProvider}from"./mojo_interface_provider.js";import{TestSuiteStatus}from"./routine_list_executor.js";import{CpuUsageObserverReceiver,MemoryUsageObserverReceiver}from"./system_data_provider.mojom-webui.js";import{RoutineType}from"./system_routine_controller.mojom-webui.js";const CpuCardElementBase=I18nMixin(PolymerElement);export class CpuCardElement extends CpuCardElementBase{static get is(){return"cpu-card"}static get template(){return getTemplate()}static get properties(){return{routines:{type:Array,value:()=>[RoutineType.kCpuStress,RoutineType.kCpuCache,RoutineType.kCpuFloatingPoint,RoutineType.kCpuPrime]},cpuUsage:{type:Object},cpuChipInfo:{type:String,value:""},testSuiteStatus:{type:Number,value:TestSuiteStatus.NOT_RUNNING,notify:true},isActive:{type:Boolean}}}constructor(){super();this.systemDataProvider=getSystemDataProvider();this.cpuUsageObserverReceiver=null;this.memoryUsageObserverReceiver=null;this.observeCpuUsage();this.observeMemoryUsage();this.fetchSystemInfo()}disconnectedCallback(){super.disconnectedCallback();if(this.cpuUsageObserverReceiver){this.cpuUsageObserverReceiver.$.close()}if(this.memoryUsageObserverReceiver){this.memoryUsageObserverReceiver.$.close()}}observeMemoryUsage(){this.memoryUsageObserverReceiver=new MemoryUsageObserverReceiver(this);this.systemDataProvider.observeMemoryUsage(this.memoryUsageObserverReceiver.$.bindNewPipeAndPassRemote())}onMemoryUsageUpdated(memoryUsage){this.memoryUsage=memoryUsage}observeCpuUsage(){this.cpuUsageObserverReceiver=new CpuUsageObserverReceiver(this);this.systemDataProvider.observeCpuUsage(this.cpuUsageObserverReceiver.$.bindNewPipeAndPassRemote())}onCpuUsageUpdated(cpuUsage){this.cpuUsage=cpuUsage}getCurrentlyUsing(){const MAX_PERCENTAGE=100;const usagePercentage=Math.min(this.cpuUsage.percentUsageSystem+this.cpuUsage.percentUsageUser,MAX_PERCENTAGE);return loadTimeData.getStringF("cpuUsageText",usagePercentage)}fetchSystemInfo(){this.systemDataProvider.getSystemInfo().then((result=>{this.onSystemInfoReceived(result.systemInfo)}))}onSystemInfoReceived(systemInfo){this.cpuChipInfo=loadTimeData.getStringF("cpuChipText",systemInfo.cpuModelName,systemInfo.cpuThreadsCount,this.convertKhzToGhz(systemInfo.cpuMaxClockSpeedKhz))}getCpuTemp(){return loadTimeData.getStringF("cpuTempText",this.cpuUsage.averageCpuTempCelsius)}getCpuUsageTooltipText(){return loadTimeData.getString("cpuUsageTooltipText")}convertKhzToGhz(num){return(num/1e6).toFixed(3)}getCurrentCpuSpeed(){return loadTimeData.getStringF("currentCpuSpeedText",this.convertKhzToGhz(this.cpuUsage.scalingCurrentFrequencyKhz))}getEstimateRuntimeInMinutes(){return this.routines.length}getRunTestsAdditionalMessage(){return convertKibToMib(this.memoryUsage.availableMemoryKib)>=625?"":loadTimeData.getString("notEnoughAvailableMemoryCpuMessage")}}customElements.define(CpuCardElement.is,CpuCardElement);