// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import"chrome://resources/ash/common/navigation_view_panel.js";import"chrome://resources/ash/common/page_toolbar.js";import"chrome://resources/ash/common/cr_elements/cr_toast/cr_toast.js";import"chrome://resources/polymer/v3_0/iron-icon/iron-icon.js";import"./diagnostics_sticky_banner.js";import"./diagnostics_shared.css.js";import"./input_list.js";import"./network_list.js";import"/strings.m.js";import"./system_page.js";import{I18nMixin}from"chrome://resources/ash/common/cr_elements/i18n_mixin.js";import{loadTimeData}from"chrome://resources/ash/common/load_time_data.m.js";import{ColorChangeUpdater}from"chrome://resources/cr_components/color_change_listener/colors_css_updater.js";import{assert}from"chrome://resources/js/assert.js";import{PolymerElement}from"chrome://resources/polymer/v3_0/polymer/polymer_bundled.min.js";import{getTemplate}from"./diagnostics_app.html.js";import{DiagnosticsBrowserProxyImpl}from"./diagnostics_browser_proxy.js";import{getDiagnosticsIcon,getNavigationIcon}from"./diagnostics_utils.js";import{ConnectedDevicesObserverReceiver}from"./input_data_provider.mojom-webui.js";import{getInputDataProvider}from"./mojo_interface_provider.js";const DiagnosticsAppElementBase=I18nMixin(PolymerElement);export class DiagnosticsAppElement extends DiagnosticsAppElementBase{static get is(){return"diagnostics-app"}static get template(){return getTemplate()}static get properties(){return{bannerMessage:{type:Boolean,value:""},saveSessionLogEnabled:{type:Boolean,value:true},isLoggedIn:{type:Boolean,value:loadTimeData.getBoolean("isLoggedIn")},toastText:{type:String,value:""}}}constructor(){super();this.browserProxy=DiagnosticsBrowserProxyImpl.getInstance();this.inputDataProvider=getInputDataProvider();this.numKeyboards=0;this.showToastHandler=e=>{assert(e.detail.message);this.toastText=e.detail.message;this.$.toast.show()};this.browserProxy.initialize();this.inputDataProvider.observeConnectedDevices(new ConnectedDevicesObserverReceiver(this).$.bindNewPipeAndPassRemote())}onKeyboardConnected(){this.numKeyboards++;if(!this.$.navigationPanel.pageExists("input")){this.$.navigationPanel.addSelectorItem(this.createInputSelector())}}onKeyboardDisconnected(){this.numKeyboards--;if(this.numKeyboards===0){this.$.navigationPanel.removeSelectorById("input")}}onTouchDeviceConnected(){}onTouchDeviceDisconnected(){}async getNavPages(){const pages=[this.$.navigationPanel.createSelectorItem(loadTimeData.getString("systemText"),"system-page",getNavigationIcon("laptop-chromebook"),"system"),this.$.navigationPanel.createSelectorItem(loadTimeData.getString("connectivityText"),"network-list",getNavigationIcon("ethernet"),"connectivity")];pages.push(this.createInputSelector());const devices=await this.inputDataProvider.getConnectedDevices();this.numKeyboards=devices.keyboards.length||this.numKeyboards;const isTouchPadOrTouchScreenEnabled=loadTimeData.getBoolean("isTouchpadEnabled")||loadTimeData.getBoolean("isTouchscreenEnabled");if(this.numKeyboards===0&&!isTouchPadOrTouchScreenEnabled){pages.pop()}return pages}async createNavigationPanel(){this.$.navigationPanel.addSelectors(await this.getNavPages())}connectedCallback(){super.connectedCallback();ColorChangeUpdater.forDocument().start();this.createNavigationPanel();window.addEventListener("show-toast",(e=>this.showToastHandler(e)))}disconnectedCallback(){super.disconnectedCallback();window.removeEventListener("show-toast",(e=>this.showToastHandler(e)))}onSessionLogClick(){if(!this.saveSessionLogEnabled){return}this.saveSessionLogEnabled=false;this.browserProxy.saveSessionLog().then((success=>{const result=success?"Success":"Failure";this.toastText=loadTimeData.getString(`sessionLogToastText${result}`);this.$.toast.show()})).catch((()=>{})).finally((()=>{this.saveSessionLogEnabled=true}))}createInputSelector(){return this.$.navigationPanel.createSelectorItem(loadTimeData.getString("keyboardText"),"input-list",getDiagnosticsIcon("keyboard"),"input")}}customElements.define(DiagnosticsAppElement.is,DiagnosticsAppElement);