// Copyright 2021 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import"chrome://resources/ash/common/network/network_icon.js";import"chrome://resources/polymer/v3_0/paper-spinner/paper-spinner-lite.js";import"./diagnostics_shared.css.js";import{I18nMixin}from"chrome://resources/ash/common/cr_elements/i18n_mixin.js";import{assert,assertNotReached}from"chrome://resources/js/assert.js";import{SecurityType as MojomSecurityType}from"chrome://resources/mojo/chromeos/services/network_config/public/mojom/cros_network_config.mojom-webui.js";import{ConnectionStateType as MojomConnectionStateType,NetworkType as MojomNetworkType}from"chrome://resources/mojo/chromeos/services/network_config/public/mojom/network_types.mojom-webui.js";import{PolymerElement}from"chrome://resources/polymer/v3_0/polymer/polymer_bundled.min.js";import{getTemplate}from"./diagnostics_network_icon.html.js";import{getNetworkType}from"./diagnostics_utils.js";import{NetworkState,NetworkType,SecurityType}from"./network_health_provider.mojom-webui.js";export const ConnectionStateType=MojomConnectionStateType;export const CrosNetworkType=MojomNetworkType;export const CrosSecurityType=MojomSecurityType;function convertNetworkStateToCrosNetworkState(state){switch(state){case NetworkState.kOnline:return ConnectionStateType.kOnline;case NetworkState.kConnected:return ConnectionStateType.kConnected;case NetworkState.kPortal:return ConnectionStateType.kPortal;case NetworkState.kConnecting:return ConnectionStateType.kConnecting;case NetworkState.kNotConnected:case NetworkState.kDisabled:return ConnectionStateType.kNotConnected}}function convertNetworkTypeToCrosNetworkType(type){switch(type){case NetworkType.kEthernet:return CrosNetworkType.kEthernet;case NetworkType.kWiFi:return CrosNetworkType.kWiFi;case NetworkType.kCellular:return CrosNetworkType.kCellular;default:assertNotReached()}}function getCellularTypeState(network){assert(network.type===NetworkType.kCellular);const defaultCellularTypeStateProperties={networkTechnology:"",roaming:false,signalStrength:0,simLocked:false};let typeState={cellular:defaultCellularTypeStateProperties};if(!network?.typeProperties?.cellular){return typeState}const networkTechnology=network.typeProperties.cellular.networkTechnology;const roaming=network.typeProperties.cellular.roaming;const signalStrength=network.typeProperties.cellular.signalStrength;const simLocked=network.typeProperties.cellular.simLocked;assert(networkTechnology);assert(roaming);assert(signalStrength);assert(simLocked);typeState={cellular:{networkTechnology:networkTechnology,roaming:roaming,signalStrength:signalStrength,simLocked:simLocked}};return typeState}function getWifiTypeState(network){const defaultWifiTypeStateProperties={security:CrosSecurityType.kNone,signalStrength:0};let typeState={wifi:defaultWifiTypeStateProperties};if(!network?.typeProperties?.wifi){return typeState}const signalStrength=network.typeProperties.wifi.signalStrength;const securityType=network.typeProperties.wifi.security;if(signalStrength){typeState={wifi:{security:typeState.wifi.security,signalStrength:signalStrength}}}if(securityType){const security=convertSecurityTypeToCrosSecurityType(securityType);typeState={wifi:{security:security,signalStrength:typeState.wifi.signalStrength}}}return typeState}function getTypeState(network){switch(network.type){case NetworkType.kEthernet:return null;case NetworkType.kCellular:return getCellularTypeState(network);case NetworkType.kWiFi:return getWifiTypeState(network)}assertNotReached()}function convertSecurityTypeToCrosSecurityType(type){switch(type){case SecurityType.kNone:return CrosSecurityType.kNone;case SecurityType.kWep8021x:return CrosSecurityType.kWep8021x;case SecurityType.kWepPsk:return CrosSecurityType.kWepPsk;case SecurityType.kWpaEap:return CrosSecurityType.kWpaEap;case SecurityType.kWpaPsk:return CrosSecurityType.kWpaPsk}}export function networkToNetworkStateAdapter(network){const type=convertNetworkTypeToCrosNetworkType(network.type);const connectionState=convertNetworkStateToCrosNetworkState(network.state);const guid=network.observerGuid;const typeState=getTypeState(network);return{guid:guid,connectionState:connectionState,type:type,typeState:typeState}}const DiagnosticsNetworkIconBase=I18nMixin(PolymerElement);export class DiagnosticsNetworkIconElement extends DiagnosticsNetworkIconBase{static get is(){return"diagnostics-network-icon"}static get template(){return getTemplate()}static get properties(){return{network:{type:Object}}}computeNetworkState(){if(!this.network){return null}return networkToNetworkStateAdapter(this.network)}computeShouldDisplaySpinner(){if(!this.network){return false}return this.network.state===NetworkState.kConnecting}computeSpinnerAriaLabel(){if(!this.network){return""}const networkType=getNetworkType(this.network.type);return this.i18nDynamic(navigator.language,"networkIconLabelConnecting",networkType)}}customElements.define(DiagnosticsNetworkIconElement.is,DiagnosticsNetworkIconElement);