// Copyright 2021 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import{loadTimeData}from"chrome://resources/ash/common/load_time_data.m.js";import{assert,assertNotReached}from"chrome://resources/js/assert.js";import{NavigationView}from"./diagnostics_types.js";import{LockType,NetworkState,NetworkType}from"./network_health_provider.mojom-webui.js";import{RoutineGroup}from"./routine_group.js";import{RoutineType}from"./system_routine_controller.mojom-webui.js";export function convertKibToGibDecimalString(value,numDecimalPlaces){return(value/2**20).toFixed(numDecimalPlaces)}export function convertKibToMib(value){return value/2**10}export function getDiagnosticsIcon(id){return`diagnostics:${id}`}export function getNavigationIcon(id){return`navigation-selector:${id}`}export function getNavigationViewForPageId(id){switch(id){case"system":return NavigationView.SYSTEM;case"connectivity":return NavigationView.CONNECTIVITY;case"input":return NavigationView.INPUT;default:assertNotReached()}}export function getNetworkType(type){switch(type){case NetworkType.kWiFi:return loadTimeData.getString("wifiLabel");case NetworkType.kEthernet:return loadTimeData.getString("ethernetLabel");case NetworkType.kCellular:return loadTimeData.getString("cellularLabel")}assertNotReached()}export function getNetworkState(state){switch(state){case NetworkState.kOnline:return loadTimeData.getString("networkStateOnlineText");case NetworkState.kConnected:return loadTimeData.getString("networkStateConnectedText");case NetworkState.kPortal:return loadTimeData.getString("networkStatePortalText");case NetworkState.kConnecting:return loadTimeData.getString("networkStateConnectingText");case NetworkState.kNotConnected:return loadTimeData.getString("networkStateNotConnectedText");case NetworkState.kDisabled:return loadTimeData.getString("networkStateDisabledText")}}export function getLockType(lockType){switch(lockType){case LockType.kSimPuk:return"sim-puk";case LockType.kSimPin:return"sim-pin";case LockType.kNetworkPin:return"network-pin";case LockType.kNone:return""}}export function createRoutine(routine,blocking){return{routine:routine,blocking:blocking}}export function getRoutineGroups(type){const localNetworkGroup=new RoutineGroup([createRoutine(RoutineType.kGatewayCanBePinged,false),createRoutine(RoutineType.kLanConnectivity,true),createRoutine(RoutineType.kArcPing,false)],"localNetworkGroupLabel");const nameResolutionGroup=new RoutineGroup([createRoutine(RoutineType.kDnsResolverPresent,true),createRoutine(RoutineType.kDnsResolution,true),createRoutine(RoutineType.kDnsLatency,true),createRoutine(RoutineType.kArcDnsResolution,false)],"nameResolutionGroupLabel");const wifiGroup=new RoutineGroup([createRoutine(RoutineType.kSignalStrength,false),createRoutine(RoutineType.kCaptivePortal,false),createRoutine(RoutineType.kHasSecureWiFiConnection,false)],"wifiGroupLabel");const internetConnectivityGroup=new RoutineGroup([createRoutine(RoutineType.kHttpsFirewall,true),createRoutine(RoutineType.kHttpFirewall,true),createRoutine(RoutineType.kHttpsLatency,true),createRoutine(RoutineType.kArcHttp,false)],"internetConnectivityGroupLabel");const groupsToAdd=type===NetworkType.kWiFi?[wifiGroup,internetConnectivityGroup]:[internetConnectivityGroup];const networkRoutineGroups=[localNetworkGroup,nameResolutionGroup];return networkRoutineGroups.concat(groupsToAdd)}export function getSubnetMaskFromRoutingPrefix(prefix){assert(prefix>=0&&prefix<=32);if(prefix===0){return""}const zeroes=32-prefix;let mask=4294967295>>zeroes<<zeroes;const pieces=new Array(4);for(let i=0;i<4;i++){pieces[3-i]=mask&255;mask=mask>>8}return pieces.join(".")}export function formatMacAddress(macAddress){return`${loadTimeData.getString("macAddressLabel")}: ${macAddress}`}export function getRoutineFailureMessage(routineType){switch(routineType){case RoutineType.kCaptivePortal:return loadTimeData.getString("captivePortalFailedText");case RoutineType.kDnsLatency:return loadTimeData.getString("dnsLatencyFailedText");case RoutineType.kDnsResolution:return loadTimeData.getString("dnsResolutionFailedText");case RoutineType.kDnsResolverPresent:return loadTimeData.getString("dnsResolverPresentFailedText");case RoutineType.kGatewayCanBePinged:return loadTimeData.getString("gatewayCanBePingedFailedText");case RoutineType.kHasSecureWiFiConnection:return loadTimeData.getString("hasSecureWiFiConnectionFailedText");case RoutineType.kHttpFirewall:return loadTimeData.getString("httpFirewallFailedText");case RoutineType.kHttpsFirewall:return loadTimeData.getString("httpsFirewallFailedText");case RoutineType.kHttpsLatency:return loadTimeData.getString("httpsLatencyFailedText");case RoutineType.kLanConnectivity:return loadTimeData.getString("lanConnectivityFailedText");case RoutineType.kSignalStrength:return loadTimeData.getString("signalStrengthFailedText");case RoutineType.kArcHttp:return loadTimeData.getString("arcHttpFailedText");case RoutineType.kArcPing:return loadTimeData.getString("arcPingFailedText");case RoutineType.kArcDnsResolution:return loadTimeData.getString("arcDnsResolutionFailedText");case RoutineType.kBatteryCharge:case RoutineType.kBatteryDischarge:case RoutineType.kCpuCache:case RoutineType.kCpuStress:case RoutineType.kCpuFloatingPoint:case RoutineType.kCpuPrime:case RoutineType.kMemory:default:assertNotReached()}}export function isConnectedOrOnline(state){switch(state){case NetworkState.kOnline:case NetworkState.kConnected:case NetworkState.kConnecting:return true;default:return false}}export function isNetworkMissingNameServers(network){return!network.ipConfig||!network.ipConfig.nameServers||network.ipConfig.nameServers.length===0}export function filterNameServers(network){if(network?.ipConfig?.nameServers){network.ipConfig.nameServers=network.ipConfig.nameServers.filter((n=>n!=="0.0.0.0"))}}let displayStateInTitle=false;export function setDisplayStateInTitleForTesting(state){displayStateInTitle=state}export function getNetworkCardTitle(networkType,networkState){let titleForCard=`${networkType}`;if(displayStateInTitle){titleForCard=`${titleForCard} (${networkState})`}return`${titleForCard}`}export function getSignalStrength(value){assert(typeof value==="number");assert(value>=0&&value<=100);if(value<=1){return""}if(value<=25){return loadTimeData.getStringF("signalStrength_Weak",value)}if(value<=50){return loadTimeData.getStringF("signalStrength_Average",value)}if(value<=75){return loadTimeData.getStringF("signalStrength_Good",value)}return loadTimeData.getStringF("signalStrength_Excellent",value)}