// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import{FakeMethodResolver}from"chrome://resources/ash/common/fake_method_resolver.js";export class FakeInputDataProvider{constructor(){this.methods=new FakeMethodResolver;this.observers=[];this.keyboards=[];this.keyboardObservers=[];this.touchDevices=[];this.moveAppToTestingScreenCalled=0;this.moveAppBackToPreviousScreenCalled=0;this.a11yTouchPassthroughState=false;this.registerMethods()}reset(){this.methods=new FakeMethodResolver;this.observers=[];this.keyboards=[];this.touchDevices=[];this.moveAppToTestingScreenCalled=0;this.moveAppBackToPreviousScreenCalled=0;this.a11yTouchPassthroughState=false;this.registerMethods()}registerMethods(){this.methods.register("getConnectedDevices");this.methods.register("observeKeyEvents");this.methods.register("observeTabletMode");this.methods.register("observeLidState")}getConnectedDevices(){return this.methods.resolveMethod("getConnectedDevices")}observeKeyEvents(id,remote){if(!this.keyboardObservers[id]){return}this.keyboardObservers[id].push(remote)}observeInternalDisplayPowerState(remote){this.internalDisplayPowerStateObserver=remote}setInternalDisplayPowerOn(){this.internalDisplayPowerStateObserver.onInternalDisplayPowerStateChanged(true)}setInternalDisplayPowerOff(){this.internalDisplayPowerStateObserver.onInternalDisplayPowerStateChanged(false)}setStartWithLidClosed(){this.methods.setResult("observeLidState",{isLidOpen:false})}setStartWithLidOpen(){this.methods.setResult("observeLidState",{isLidOpen:true})}observeLidState(remote){this.lidStateObserver=remote;return this.methods.resolveMethod("observeLidState")}setLidStateOpen(){this.lidStateObserver.onLidStateChanged(true)}setLidStateClosed(){this.lidStateObserver.onLidStateChanged(false)}observeTabletMode(remote){this.tabletModeObserver=remote;return this.methods.resolveMethod("observeTabletMode")}startTabletMode(){this.tabletModeObserver.onTabletModeChanged(true)}endTabletMode(){this.tabletModeObserver.onTabletModeChanged(false)}setStartTesterWithClamshellMode(){this.methods.setResult("observeTabletMode",{isTabletMode:false})}setStartTesterWithTabletMode(){this.methods.setResult("observeTabletMode",{isTabletMode:true})}setFakeConnectedDevices(keyboards,touchDevices){this.keyboards=keyboards;this.touchDevices=touchDevices;this.methods.setResult("getConnectedDevices",{keyboards:[...keyboards],touchDevices:[...touchDevices]})}observeConnectedDevices(remote){this.observers.push(remote)}addFakeConnectedKeyboard(keyboard){this.keyboards.push(keyboard);this.keyboardObservers[keyboard.id]=[];this.methods.setResult("getConnectedDevices",{keyboards:[...this.keyboards],touchDevices:[...this.touchDevices]});for(const observer of this.observers){observer.onKeyboardConnected(keyboard)}}removeFakeConnectedKeyboardById(id){this.keyboards=this.keyboards.filter((device=>device.id!==id));delete this.keyboardObservers[id];for(const observer of this.observers){observer.onKeyboardDisconnected(id)}}addFakeConnectedTouchDevice(touchDevice){this.touchDevices.push(touchDevice);this.methods.setResult("getConnectedDevices",{keyboards:this.keyboards,touchDevices:this.touchDevices});for(const observer of this.observers){observer.onTouchDeviceConnected(touchDevice)}}removeFakeConnectedTouchDeviceById(id){this.touchDevices=this.touchDevices.filter((device=>device.id!==id));for(const observer of this.observers){observer.onTouchDeviceDisconnected(id)}}moveAppToTestingScreen(){this.moveAppToTestingScreenCalled++}getMoveAppToTestingScreenCalled(){return this.moveAppToTestingScreenCalled}moveAppBackToPreviousScreen(){this.moveAppBackToPreviousScreenCalled++}getMoveAppBackToPreviousScreenCalled(){return this.moveAppBackToPreviousScreenCalled}setA11yTouchPassthrough(enabled){this.a11yTouchPassthroughState=enabled}getA11yTouchPassthroughState(){return this.a11yTouchPassthroughState}}