// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import{FakeMethodResolver}from"chrome://resources/ash/common/fake_method_resolver.js";import{FakeObservables}from"chrome://resources/ash/common/fake_observables.js";import{assert}from"chrome://resources/js/assert.js";export class FakeSystemDataProvider{constructor(){this.methods=new FakeMethodResolver;this.observables=new FakeObservables;this.observeBatteryChargeStatusPromise=null;this.observeBatteryHealthPromise=null;this.observeCpuUsagePromise=null;this.observeMemoryUsagePromise=null;this.registerMethods();this.registerObservables()}getSystemInfo(){return this.methods.resolveMethod("getSystemInfo")}setFakeSystemInfo(systemInfo){this.methods.setResult("getSystemInfo",{systemInfo:systemInfo})}getBatteryInfo(){return this.methods.resolveMethod("getBatteryInfo")}setFakeBatteryInfo(batteryInfo){this.methods.setResult("getBatteryInfo",{batteryInfo:batteryInfo})}observeBatteryChargeStatus(remote){this.observeBatteryChargeStatusPromise=this.observe("BatteryChargeStatusObserver_onBatteryChargeStatusUpdated",(batteryChargeStatus=>{remote.onBatteryChargeStatusUpdated(batteryChargeStatus)}))}getObserveBatteryChargeStatusPromiseForTesting(){assert(this.observeBatteryChargeStatusPromise);return this.observeBatteryChargeStatusPromise}setFakeBatteryChargeStatus(batteryChargeStatusList){this.observables.setObservableData("BatteryChargeStatusObserver_onBatteryChargeStatusUpdated",batteryChargeStatusList)}triggerBatteryChargeStatusObserver(){this.observables.trigger("BatteryChargeStatusObserver_onBatteryChargeStatusUpdated")}observeBatteryHealth(remote){this.observeBatteryHealthPromise=this.observe("BatteryHealthObserver_onBatteryHealthUpdated",(batteryHealth=>{remote.onBatteryHealthUpdated(batteryHealth)}))}getObserveBatteryHealthPromiseForTesting(){assert(this.observeBatteryHealthPromise);return this.observeBatteryHealthPromise}setFakeBatteryHealth(batteryHealthList){this.observables.setObservableData("BatteryHealthObserver_onBatteryHealthUpdated",batteryHealthList)}triggerBatteryHealthObserver(){this.observables.trigger("BatteryHealthObserver_onBatteryHealthUpdated")}observeCpuUsage(remote){this.observeCpuUsagePromise=this.observe("CpuUsageObserver_onCpuUsageUpdated",(cpuUsage=>{remote.onCpuUsageUpdated(cpuUsage)}))}getObserveCpuUsagePromiseForTesting(){assert(this.observeCpuUsagePromise);return this.observeCpuUsagePromise}setFakeCpuUsage(cpuUsageList){this.observables.setObservableData("CpuUsageObserver_onCpuUsageUpdated",cpuUsageList)}triggerCpuUsageObserver(){this.observables.trigger("CpuUsageObserver_onCpuUsageUpdated")}observeMemoryUsage(remote){this.observeMemoryUsagePromise=this.observe("MemoryUsageObserver_onMemoryUsageUpdated",(memoryUsage=>{remote.onMemoryUsageUpdated(memoryUsage)}))}getObserveMemoryUsagePromiseForTesting(){assert(this.observeMemoryUsagePromise);return this.observeMemoryUsagePromise}setFakeMemoryUsage(memoryUsageList){this.observables.setObservableData("MemoryUsageObserver_onMemoryUsageUpdated",memoryUsageList)}triggerMemoryUsageObserver(){this.observables.trigger("MemoryUsageObserver_onMemoryUsageUpdated")}startTriggerIntervals(){this.observables.startTriggerOnInterval("CpuUsageObserver_onCpuUsageUpdated",1e3);this.observables.startTriggerOnInterval("MemoryUsageObserver_onMemoryUsageUpdated",5e3);this.observables.startTriggerOnInterval("BatteryHealthObserver_onBatteryHealthUpdated",3e4);this.observables.startTriggerOnInterval("BatteryChargeStatusObserver_onBatteryChargeStatusUpdated",3e4)}stopTriggerIntervals(){this.observables.stopAllTriggerIntervals()}registerMethods(){this.methods.register("getSystemInfo");this.methods.register("getBatteryInfo")}registerObservables(){this.observables.register("BatteryChargeStatusObserver_onBatteryChargeStatusUpdated");this.observables.register("BatteryHealthObserver_onBatteryHealthUpdated");this.observables.register("CpuUsageObserver_onCpuUsageUpdated");this.observables.register("MemoryUsageObserver_onMemoryUsageUpdated")}reset(){this.observables.stopAllTriggerIntervals();this.methods=new FakeMethodResolver;this.observables=new FakeObservables;this.registerMethods();this.registerObservables()}observe(methodName,callback){return new Promise((resolve=>{this.observables.observe(methodName,callback);this.observables.trigger(methodName);resolve()}))}}