// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import{FakeMethodResolver}from"chrome://resources/ash/common/fake_method_resolver.js";import{assert}from"chrome://resources/js/assert.js";import{PromiseResolver}from"chrome://resources/js/promise_resolver.js";import{RoutineType,StandardRoutineResult}from"./system_routine_controller.mojom-webui.js";export class FakeSystemRoutineController{constructor(){this.methods=new FakeMethodResolver;this.routineResults=new Map;this.delayTimeMilliseconds=0;this.resolver=null;this.remote=null;this.routineType=null;this.registerMethods()}getAllRoutines(){return[RoutineType.kBatteryCharge,RoutineType.kBatteryDischarge,RoutineType.kCpuStress,RoutineType.kCpuCache,RoutineType.kCpuFloatingPoint,RoutineType.kCpuPrime,RoutineType.kMemory,RoutineType.kCaptivePortal,RoutineType.kDnsLatency,RoutineType.kDnsResolution,RoutineType.kDnsResolverPresent,RoutineType.kGatewayCanBePinged,RoutineType.kHasSecureWiFiConnection,RoutineType.kHttpFirewall,RoutineType.kHttpsFirewall,RoutineType.kHttpsLatency,RoutineType.kLanConnectivity,RoutineType.kSignalStrength,RoutineType.kArcHttp,RoutineType.kArcPing,RoutineType.kArcDnsResolution]}getSupportedRoutines(){return this.methods.resolveMethod("getSupportedRoutines")}setFakeSupportedRoutines(routines){this.methods.setResult("getSupportedRoutines",{routines:routines})}runRoutine(routineType,remoteRunner){this.resolver=new PromiseResolver;this.remote=remoteRunner;this.routineType=routineType;if(this.delayTimeMilliseconds>=0){setTimeout((()=>{this.fireRemoteWithResult()}),this.delayTimeMilliseconds)}}registerMethods(){this.methods.register("getSupportedRoutines")}setFakeStandardRoutineResult(routineType,routineResult){this.routineResults.set(routineType,{simpleResult:routineResult})}setFakePowerRoutineResult(routineType,routineResult){this.routineResults.set(routineType,{powerResult:routineResult})}setDelayTimeInMillisecondsForTesting(delayMilliseconds){assert(delayMilliseconds>=-1);this.delayTimeMilliseconds=delayMilliseconds}getRunRoutinePromiseForTesting(){assert(this.resolver!=null);return this.resolver.promise}resolveRoutineForTesting(){assert(this.delayTimeMilliseconds==-1);assert(this.resolver!=null);const promise=this.resolver.promise;this.fireRemoteWithResult();return promise}isRoutineInProgressForTesting(){assert(this.delayTimeMilliseconds==-1);return this.resolver!=null}getResultInfo(){assert(this.routineType!=null);let result=this.routineResults.get(this.routineType);if(result==undefined){result={simpleResult:StandardRoutineResult.kExecutionError}}const resultInfo={type:this.routineType,result:result};return resultInfo}fireRemoteWithResult(){this.remote.onRoutineResult(this.getResultInfo());this.resolver.resolve(null);this.resolver=null;this.remote=null;this.routineType=null}}