import{html}from"//resources/polymer/v3_0/polymer/polymer_bundled.min.js";export function getTemplate(){return html`<!--_html_template_start_--><style include="diagnostics-shared">:host-context(body.jelly-enabled) .device #deviceIcon{--iron-icon-fill-color:var(--cros-icon-color-prominent);background-color:var(--cros-sys-highlight_shape)}:host-context(body.jelly-enabled) .device #tooltipText{font:var(--cros-annotation-1-font)}:host-context(body.jelly-enabled) .device-name,:host-context(body.jelly-enabled) .device-description{font:var(--cros-body-2-font)}paper-tooltip{--paper-tooltip-background:var(--cros-tooltip-background-color);--paper-tooltip-min-width:0px;--paper-tooltip-text-color:var(--cros-tooltip-label-color)}.device{display:flex;padding:12px 20px}.device #deviceIcon{--iron-icon-fill-color:var(--cros-color-prominent);--iron-icon-height:20px;--iron-icon-width:20px;background-color:var(--cros-highlight-color);border-radius:50%;margin-inline-end:28px;padding:8px}.device #infoIcon{--iron-icon-fill-color:var(--cros-icon-color-secondary);--iron-icon-height:20px;--iron-icon-width:20px;align-self:center;margin-inline-end:12px}.device #tooltipText{font-family:var(--diagnostics-roboto-font-family);font-weight:var(--diagnostics-regular-font-weight)}.device #inputDeviceTestButton{align-self:center}.device-body{align-self:center;flex-grow:1;line-height:140%}.device-name{color:var(--cros-text-color-secondary)}.device-description{color:var(--cros-text-color-primary)}</style>
<diagnostics-card-frame>
  <slot name="title" slot="title"></slot>
  <div slot="contents">
    <dom-repeat items="[[devices]]" as="device">
      <template>
        <div class="device" data-evdev-id$="[[device.id]]">
          <iron-icon icon="[[deviceIcon]]" id="deviceIcon"></iron-icon>
          <div class="device-body">
            <div class="device-description" id="deviceDescription">
              [[getDeviceDescription(device)]]
            </div>
            <div class="device-name" id="deviceName">[[device.name]]</div>
          </div>
          <iron-icon slot="icon" icon="diagnostics:info" id="infoIcon" tabindex="0"
              aria-labelledby="tooltipText" role="img"
              hidden$="[[getDeviceTestability(device, hostDeviceStatus)]]">
          </iron-icon>
          <paper-tooltip for="infoIcon" aria-hidden="true">
            <span id="tooltipText">
              [[getDeviceTestabilityErrorMessage(device, hostDeviceStatus)]]
            </span>
          </paper-tooltip>
          <cr-button id="inputDeviceTestButton"
              on-click="handleTestButtonClick"
              aria-labelledby="inputDeviceTestButton deviceDescription"
              disabled="[[!getDeviceTestability(device, hostDeviceStatus)]]">
            [[i18n('inputDeviceTest')]]
          </cr-button>
        </div>
      </template>
    </dom-repeat>
  </div>
</diagnostics-card-frame>
<!--_html_template_end_-->`}