import{html}from"//resources/polymer/v3_0/polymer/polymer_bundled.min.js";export function getTemplate(){return html`<!--_html_template_start_--><style include="diagnostics-shared">@media (min-width:600px){:host{--cr-dialog-width:504px}}@media (min-width:768px){:host{--cr-dialog-width:636px}}@media (min-width:960px){:host{--cr-dialog-width:672px}}@media (min-width:1280px){:host{--cr-dialog-width:960px}}:host{--cr-dialog-body-padding-horizontal:24px}:host-context(body.jelly-enabled) keyboard-diagram{--diagram-bg-color:var(--cros-sys-base_elevated)}:host-context(body.jelly-enabled) #help{color:var(--cros-text-color-primary)}:host-context(body.jelly-enabled) [slot='title']{font:var(--cros-title-1-font)}:host-context(body.jelly-enabled) #description{font:var(--cros-body-1-font)}:host-context(body.jelly-enabled) #help{font:var(--cros-body-2-font)}:host-context(body.jelly-enabled) #shortcutInstruction{font:var(--cros-body-1-font)}:host-context(body.jelly-enabled) #shortcutKeyAlt,:host-context(body.jelly-enabled) #shortcutKeyEsc{font:var(--cros-body-2-font)}[slot='title']{font-family:var(--diagnostics-google-sans-font-family);font-size:16px;font-weight:var(--diagnostics-medium-font-weight);line-height:24px;padding-bottom:4px;padding-inline-end:var(--cr-dialog-body-padding-horizontal);padding-inline-start:var(--cr-dialog-body-padding-horizontal);padding-top:var(--cr-dialog-body-padding-horizontal)}[slot='button-container']{padding-bottom:20px;padding-inline-end:var(--cr-dialog-body-padding-horizontal);padding-inline-start:var(--cr-dialog-body-padding-horizontal);padding-top:68px}#description{font-family:var(--diagnostics-roboto-font-family);font-size:14px;font-weight:var(--diagnostics-regular-font-weight);line-height:20px;margin:0;padding-bottom:8px}#diagram-border{border:1px solid var(--cros-text-color-selection);border-radius:8px;padding:6px}#help{align-self:center;flex-grow:1;font-family:var(--diagnostics-roboto-font-family);font-size:13px;font-weight:var(--diagnostics-regular-font-weight);line-height:20px}a[href]{color:var(--cros-link-color);text-decoration:none}#lostFocusToast{bottom:0;left:0}cr-toast iron-icon{--iron-icon-fill-color:var(--cros-color-prominent-inverted);margin-inline-end:12px}#shortcutInstruction{font-family:var(--diagnostics-roboto-font-family);font-size:14px;font-weight:var(--diagnostics-regular-font-weight);line-height:20px;margin:0;padding-bottom:24px}#shortcutKeyAlt,#shortcutKeyEsc{border:1px solid var(--cros-text-color-selection);border-radius:10px;color:var(--cros-text-color-selection);font-family:var(--diagnostics-roboto-font-family);font-size:13px;font-weight:var(--diagnostics-medium-font-weight);line-height:20px;margin:0 2px;padding:0 6px}</style>
<cr-dialog id="dialog" on-close="handleClose">
  <div slot="title" aria-describedby="description shortcutInstruction">[[i18n('keyboardTesterTitle')]]</div>
  <div slot="body">
    <p id="description">[[getDescriptionLabel()]]</p>
    <p id="shortcutInstruction" inner-h-t-m-l="[[getShortcutInstructionLabel()]]"></p>
    <template is="dom-if" if="[[shouldDisplayDiagram]]">
      <div id="diagram-border">
        <keyboard-diagram
            id="diagram"
            mechanical-layout="[[diagramMechanicalLayout]]"
            physical-layout="[[diagramPhysicalLayout]]"
            region-code="[[keyboard.regionCode]]"
            show-assistant-key="[[showAssistantKey]]"
            show-number-pad="[[showNumberPad]]"
            top-row-keys="[[topRowKeys]]"
            top-right-key="[[diagramTopRightKey]]"
            bottom-left-layout="[[bottomLeftLayout]]"
            bottom-right-layout="[[bottomRightLayout]]"
            number-pad-layout="[[numberPadLayout]]">
        </keyboard-diagram>
      </div>
    </template>
    <cr-toast id="lostFocusToast" duration="[[lostFocusToastLingerMs]]">
      <iron-icon icon="diagnostics:keyboard"></iron-icon>
      <!--
        Though the message refers to "other windows", it also applies when
        the user opens the launcher, but not if they just click another element
        of the system UI (e.g. opening the quick settings).
      -->
      <span>[[i18n('keyboardTesterFocusLossMessage')]]</span>
    </cr-toast>
  </div>
  <div slot="button-container">
    <div id="help" inner-h-t-m-l="[[i18nAdvanced('keyboardTesterHelpLink')]]"
        hidden$="[[!isLoggedIn]]">
    </div>
    <cr-button class="action-button" on-click="close">
      [[i18n('inputTesterDone')]]
    </cr-button>
  </div>
</cr-dialog>
<!--_html_template_end_-->`}