// Copyright 2021 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import"chrome://resources/ash/common/cr_elements/cr_dialog/cr_dialog.js";import"chrome://resources/ash/common/cr_elements/cr_shared_vars.css.js";import"chrome://resources/ash/common/cr_elements/cr_toast/cr_toast.js";import"chrome://resources/polymer/v3_0/iron-icon/iron-icon.js";import"/strings.m.js";import{getInstance}from"chrome://resources/ash/common/cr_elements/cr_a11y_announcer/cr_a11y_announcer.js";import{I18nMixin}from"chrome://resources/ash/common/cr_elements/i18n_mixin.js";import{BottomLeftLayout as DiagramBottomLeftLayout,BottomRightLayout as DiagramBottomRightLayout,MechanicalLayout as DiagramMechanicalLayout,NumberPadLayout as DiagramNumberPadLayout,PhysicalLayout as DiagramPhysicalLayout,SplitModifierTopRowKey as DiagramSplitModifierTopRowKey,TopRightKey as DiagramTopRightKey,TopRowKey as DiagramTopRowKey}from"chrome://resources/ash/common/keyboard_diagram.js";import{KeyboardKeyState}from"chrome://resources/ash/common/keyboard_key.js";import{loadTimeData}from"chrome://resources/ash/common/load_time_data.m.js";import{assert}from"chrome://resources/js/assert.js";import{EventTracker}from"chrome://resources/js/event_tracker.js";import{PolymerElement}from"chrome://resources/polymer/v3_0/polymer/polymer_bundled.min.js";import{BottomLeftLayout,BottomRightLayout,MechanicalLayout,NumberPadPresence,NumpadLayout,PhysicalLayout,TopRightKey,TopRowKey}from"./input.mojom-webui.js";import{KeyboardObserverReceiver,KeyEventType}from"./input_data_provider.mojom-webui.js";import{getTemplate}from"./keyboard_tester.html.js";import{getInputDataProvider,getSystemDataProvider}from"./mojo_interface_provider.js";const topRowKeyMap={[TopRowKey.kNone]:DiagramTopRowKey["kNone"],[TopRowKey.kBack]:DiagramTopRowKey["kBack"],[TopRowKey.kForward]:DiagramTopRowKey["kForward"],[TopRowKey.kRefresh]:DiagramTopRowKey["kRefresh"],[TopRowKey.kFullscreen]:DiagramTopRowKey["kFullscreen"],[TopRowKey.kOverview]:DiagramTopRowKey["kOverview"],[TopRowKey.kScreenshot]:DiagramTopRowKey["kScreenshot"],[TopRowKey.kScreenBrightnessDown]:DiagramTopRowKey["kScreenBrightnessDown"],[TopRowKey.kScreenBrightnessUp]:DiagramTopRowKey["kScreenBrightnessUp"],[TopRowKey.kPrivacyScreenToggle]:DiagramTopRowKey["kPrivacyScreenToggle"],[TopRowKey.kMicrophoneMute]:DiagramTopRowKey["kMicrophoneMute"],[TopRowKey.kVolumeMute]:DiagramTopRowKey["kVolumeMute"],[TopRowKey.kVolumeDown]:DiagramTopRowKey["kVolumeDown"],[TopRowKey.kVolumeUp]:DiagramTopRowKey["kVolumeUp"],[TopRowKey.kKeyboardBacklightToggle]:DiagramTopRowKey["kKeyboardBacklightToggle"],[TopRowKey.kKeyboardBacklightDown]:DiagramTopRowKey["kKeyboardBacklightDown"],[TopRowKey.kKeyboardBacklightUp]:DiagramTopRowKey["kKeyboardBacklightUp"],[TopRowKey.kNextTrack]:DiagramTopRowKey["kNextTrack"],[TopRowKey.kPreviousTrack]:DiagramTopRowKey["kPreviousTrack"],[TopRowKey.kPlayPause]:DiagramTopRowKey["kPlayPause"],[TopRowKey.kScreenMirror]:DiagramTopRowKey["kScreenMirror"],[TopRowKey.kAccessibility]:DiagramTopRowKey["kAccessibility"],[TopRowKey.kDictation]:DiagramTopRowKey["kDictation"],[TopRowKey.kDelete]:DiagramTopRowKey["kDelete"],[TopRowKey.kUnknown]:DiagramTopRowKey["kUnknown"]};const splitModifierTopRowKeyMap={[TopRowKey.kOverview]:DiagramSplitModifierTopRowKey["kOverview"]};const topRightKeyByCode=new Map([[116,DiagramTopRightKey.POWER],[142,DiagramTopRightKey.LOCK],[579,DiagramTopRightKey.CONTROL_PANEL]]);const numberPadCodes=new Set([55,71,72,73,74,75,76,77,78,79,80,81,82,83,96,98,102,107]);const standardNumberPadCodes=new Set([104,109,111]);const acerSplitModifierKeyboardWithNumpadBoards=["ruke","jubileum","ruken"];const DISPLAY_TOAST_INDEFINITELY_MS=0;const TOAST_LINGER_MS=1e3;const KeyboardTesterElementBase=I18nMixin(PolymerElement);export class KeyboardTesterElement extends KeyboardTesterElementBase{static get is(){return"keyboard-tester"}static get template(){return getTemplate()}static get properties(){return{keyboard:{type:Object},shouldDisplayDiagram:{type:Boolean,computed:"computeShouldDisplayDiagram(keyboard)"},diagramMechanicalLayout:{type:String,computed:"computeDiagramMechanicalLayout(keyboard)"},diagramPhysicalLayout:{type:String,computed:"computeDiagramPhysicalLayout(keyboard)"},diagramTopRightKey:{type:String,computed:"computeDiagramTopRightKey(keyboard)"},showNumberPad:{type:Boolean,computed:"computeShowNumberPad(keyboard)"},showAssistantKey:{type:Boolean,computed:"computeShowAssistantKey(keyboard)"},topRowKeys:{type:Array,computed:"computeTopRowKeys(keyboard)"},bottomLeftLayout:{type:String,computed:"computeBottomLeftLayout(keyboard)"},bottomRightLayout:{type:String,computed:"computeBottomRightLayout(keyboard)"},numberPadLayout:{type:String,computed:"computeNumberPadLayout(keyboard)"},isLoggedIn:{type:Boolean,value:loadTimeData.getBoolean("isLoggedIn")},lostFocusToastLingerMs:{type:Number,value:DISPLAY_TOAST_INDEFINITELY_MS}}}constructor(){super();this.boardName="";this.receiver=null;this.inputDataProvider=getInputDataProvider();this.systemDataProvider=getSystemDataProvider();this.eventTracker=new EventTracker;this.announceTextHandler=e=>{assert(e.detail.text);e.stopPropagation();getInstance(this.$.dialog.getNative()).announce(e.detail.text)};this.systemDataProvider.getSystemInfo().then((result=>{this.onSystemInfoReceived(result.systemInfo)}))}onSystemInfoReceived(systemInfo){this.boardName=systemInfo.boardName}disconnectedCallback(){super.disconnectedCallback();this.eventTracker.removeAll()}computeShouldDisplayDiagram(keyboard){if(!keyboard){return false}return keyboard.physicalLayout!==PhysicalLayout.kUnknown&&keyboard.mechanicalLayout!==MechanicalLayout.kUnknown}computeDiagramMechanicalLayout(keyboardInfo){if(!keyboardInfo){return null}return{[MechanicalLayout.kUnmappedEnumField]:null,[MechanicalLayout.kUnknown]:null,[MechanicalLayout.kAnsi]:DiagramMechanicalLayout.ANSI,[MechanicalLayout.kIso]:DiagramMechanicalLayout.ISO,[MechanicalLayout.kJis]:DiagramMechanicalLayout.JIS}[keyboardInfo.mechanicalLayout]}computeDiagramPhysicalLayout(keyboardInfo){if(!keyboardInfo){return null}if(acerSplitModifierKeyboardWithNumpadBoards.includes(this.boardName)){return DiagramPhysicalLayout.ACER_SPLIT_MODIFIER_WITH_NUMPAD}if(keyboardInfo.bottomLeftLayout!==BottomLeftLayout.kUnknown&&keyboardInfo.bottomRightLayout!==BottomRightLayout.kUnknown){return DiagramPhysicalLayout.SPLIT_MODIFIER}return{[PhysicalLayout.kUnmappedEnumField]:null,[PhysicalLayout.kUnknown]:null,[PhysicalLayout.kChromeOS]:DiagramPhysicalLayout.CHROME_OS,[PhysicalLayout.kChromeOSDellEnterpriseWilco]:DiagramPhysicalLayout.CHROME_OS_DELL_ENTERPRISE_WILCO,[PhysicalLayout.kChromeOSDellEnterpriseDrallion]:DiagramPhysicalLayout.CHROME_OS_DELL_ENTERPRISE_DRALLION}[keyboardInfo.physicalLayout]}computeDiagramTopRightKey(keyboardInfo){if(!keyboardInfo){return null}return{[TopRightKey.kUnmappedEnumField]:null,[TopRightKey.kUnknown]:null,[TopRightKey.kPower]:DiagramTopRightKey.POWER,[TopRightKey.kLock]:DiagramTopRightKey.LOCK,[TopRightKey.kControlPanel]:DiagramTopRightKey.CONTROL_PANEL}[keyboardInfo.topRightKey]}computeShowNumberPad(keyboard){return!!keyboard&&(keyboard.numberPadPresent===NumberPadPresence.kPresent||!!keyboard.numpadLayout)}computeShowAssistantKey(keyboard){const physicalLayout=this.computeDiagramPhysicalLayout(keyboard);return!!keyboard&&keyboard.hasAssistantKey&&physicalLayout!==DiagramPhysicalLayout.SPLIT_MODIFIER&&physicalLayout!==DiagramPhysicalLayout.ACER_SPLIT_MODIFIER_WITH_NUMPAD}computeTopRowKeys(keyboard){if(!keyboard){return[]}if(this.computeDiagramPhysicalLayout(keyboard)===DiagramPhysicalLayout.SPLIT_MODIFIER){return keyboard.topRowKeys.map((keyId=>splitModifierTopRowKeyMap[keyId]??topRowKeyMap[keyId]))}return keyboard.topRowKeys.map((keyId=>topRowKeyMap[keyId]))}computeBottomLeftLayout(keyboardInfo){if(!keyboardInfo){return null}return{[BottomLeftLayout.kUnknown]:null,[BottomLeftLayout.kBottomLeft3Keys]:DiagramBottomLeftLayout.THREE_KEYS,[BottomLeftLayout.kBottomLeft4Keys]:DiagramBottomLeftLayout.FOUR_KEYS}[keyboardInfo.bottomLeftLayout]}computeBottomRightLayout(keyboardInfo){if(!keyboardInfo){return null}return{[BottomRightLayout.kUnknown]:null,[BottomRightLayout.kBottomRight2Keys]:DiagramBottomRightLayout.TWO_KEYS,[BottomRightLayout.kBottomRight3Keys]:DiagramBottomRightLayout.THREE_KEYS,[BottomRightLayout.kBottomRight4Keys]:DiagramBottomRightLayout.FOUR_KEYS}[keyboardInfo.bottomRightLayout]}computeNumberPadLayout(keyboardInfo){if(!keyboardInfo){return null}return{[NumpadLayout.kUnknown]:null,[NumpadLayout.kNumpad3Column]:DiagramNumberPadLayout.THREE_COLUMN,[NumpadLayout.kNumpad4Column]:DiagramNumberPadLayout.FOUR_COLUMN}[keyboardInfo.numpadLayout]}getDescriptionLabel(){return this.i18n("keyboardTesterInstruction")}getShortcutInstructionLabel(){return this.i18nAdvanced("keyboardTesterShortcutInstruction",{attrs:["id"]})}addEventListeners(){this.eventTracker.add(document,"keydown",(e=>this.onKeyPress(e)));this.eventTracker.add(document,"keyup",(e=>this.onKeyPress(e)));this.eventTracker.add(document,"announce-text",(e=>this.announceTextHandler(e)))}show(){assert(this.inputDataProvider);this.receiver=new KeyboardObserverReceiver(this);this.inputDataProvider.observeKeyEvents(this.keyboard.id,this.receiver.$.bindNewPipeAndPassRemote());this.addEventListeners();const title=this.shadowRoot.querySelector('div[slot="title"]');this.$.dialog.getNative().removeAttribute("aria-describedby");this.$.dialog.showModal();title?.focus()}onKeyPress(e){if(!this.isOpen()){return}e.preventDefault();e.stopPropagation();if(e.type==="keydown"&&e.altKey&&e.key==="Escape"){this.close()}}isOpen(){return this.$.dialog.open}close(){if(this.shouldDisplayDiagram){const diagram=this.shadowRoot.querySelector("#diagram");assert(diagram);diagram.resetAllKeys()}this.$.dialog.close();const url=new URL(window.location.href);url.searchParams.delete("showDefaultKeyboardTester");history.pushState(null,"",url)}handleClose(){this.eventTracker.removeAll();if(this.receiver){this.receiver.$.close()}}isNumberPadKey(evdevCode){if(this.keyboard.physicalLayout===PhysicalLayout.kChromeOS&&standardNumberPadCodes.has(evdevCode)){return true}return numberPadCodes.has(evdevCode)}onKeyEvent(keyEvent){const diagram=this.shadowRoot.querySelector("#diagram");assert(diagram);const state=keyEvent.type===KeyEventType.kPress?KeyboardKeyState.PRESSED:KeyboardKeyState.TESTED;if(keyEvent.topRowPosition!==-1&&keyEvent.topRowPosition<this.keyboard.topRowKeys.length){diagram.setTopRowKeyState(keyEvent.topRowPosition,state)}else{if(topRightKeyByCode.has(keyEvent.keyCode)&&diagram.topRightKey!==topRightKeyByCode.get(keyEvent.keyCode)){const newValue=topRightKeyByCode.get(keyEvent.keyCode);diagram.topRightKey=newValue}if(keyEvent.keyCode===183){keyEvent.keyCode=142}if(!diagram.showNumberPad&&this.isNumberPadKey(keyEvent.keyCode)){diagram.showNumberPad=true}diagram.setKeyState(keyEvent.keyCode,state)}}onKeyEventsPaused(){const diagram=this.shadowRoot.querySelector("#diagram");assert(diagram);diagram.clearPressedKeys();this.lostFocusToastLingerMs=DISPLAY_TOAST_INDEFINITELY_MS;this.$.lostFocusToast.show()}onKeyEventsResumed(){if(this.isOpen()){this.$.dialog.focus()}this.lostFocusToastLingerMs=TOAST_LINGER_MS}}customElements.define(KeyboardTesterElement.is,KeyboardTesterElement);