// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import{mojo}from"//resources/mojo/mojo/public/js/bindings.js";export const AuthenticationTypeSpec={$:mojo.internal.Enum()};export var AuthenticationType;(function(AuthenticationType){AuthenticationType[AuthenticationType["MIN_VALUE"]=0]="MIN_VALUE";AuthenticationType[AuthenticationType["MAX_VALUE"]=1]="MAX_VALUE";AuthenticationType[AuthenticationType["kNone"]=0]="kNone";AuthenticationType[AuthenticationType["k8021x"]=1]="k8021x"})(AuthenticationType||(AuthenticationType={}));export const NetworkStateSpec={$:mojo.internal.Enum()};export var NetworkState;(function(NetworkState){NetworkState[NetworkState["MIN_VALUE"]=0]="MIN_VALUE";NetworkState[NetworkState["MAX_VALUE"]=5]="MAX_VALUE";NetworkState[NetworkState["kOnline"]=0]="kOnline";NetworkState[NetworkState["kConnected"]=1]="kConnected";NetworkState[NetworkState["kPortal"]=2]="kPortal";NetworkState[NetworkState["kConnecting"]=3]="kConnecting";NetworkState[NetworkState["kNotConnected"]=4]="kNotConnected";NetworkState[NetworkState["kDisabled"]=5]="kDisabled"})(NetworkState||(NetworkState={}));export const NetworkTypeSpec={$:mojo.internal.Enum()};export var NetworkType;(function(NetworkType){NetworkType[NetworkType["MIN_VALUE"]=0]="MIN_VALUE";NetworkType[NetworkType["MAX_VALUE"]=3]="MAX_VALUE";NetworkType[NetworkType["kCellular"]=0]="kCellular";NetworkType[NetworkType["kEthernet"]=1]="kEthernet";NetworkType[NetworkType["kWiFi"]=2]="kWiFi";NetworkType[NetworkType["kUnsupported"]=3]="kUnsupported"})(NetworkType||(NetworkType={}));export const RoamingStateSpec={$:mojo.internal.Enum()};export var RoamingState;(function(RoamingState){RoamingState[RoamingState["MIN_VALUE"]=0]="MIN_VALUE";RoamingState[RoamingState["MAX_VALUE"]=2]="MAX_VALUE";RoamingState[RoamingState["kNone"]=0]="kNone";RoamingState[RoamingState["kRoaming"]=1]="kRoaming";RoamingState[RoamingState["kHome"]=2]="kHome"})(RoamingState||(RoamingState={}));export const LockTypeSpec={$:mojo.internal.Enum()};export var LockType;(function(LockType){LockType[LockType["MIN_VALUE"]=0]="MIN_VALUE";LockType[LockType["MAX_VALUE"]=3]="MAX_VALUE";LockType[LockType["kNone"]=0]="kNone";LockType[LockType["kSimPin"]=1]="kSimPin";LockType[LockType["kSimPuk"]=2]="kSimPuk";LockType[LockType["kNetworkPin"]=3]="kNetworkPin"})(LockType||(LockType={}));export const SecurityTypeSpec={$:mojo.internal.Enum()};export var SecurityType;(function(SecurityType){SecurityType[SecurityType["MIN_VALUE"]=0]="MIN_VALUE";SecurityType[SecurityType["MAX_VALUE"]=4]="MAX_VALUE";SecurityType[SecurityType["kNone"]=0]="kNone";SecurityType[SecurityType["kWep8021x"]=1]="kWep8021x";SecurityType[SecurityType["kWepPsk"]=2]="kWepPsk";SecurityType[SecurityType["kWpaEap"]=3]="kWpaEap";SecurityType[SecurityType["kWpaPsk"]=4]="kWpaPsk"})(SecurityType||(SecurityType={}));export class NetworkListObserverPendingReceiver{constructor(handle){this.handle=mojo.internal.interfaceSupport.getEndpointForReceiver(handle)}bindInBrowser(scope="context"){mojo.internal.interfaceSupport.bind(this.handle,"ash.diagnostics.mojom.NetworkListObserver",scope)}}export class NetworkListObserverRemote{constructor(handle){this.proxy=new mojo.internal.interfaceSupport.InterfaceRemoteBase(NetworkListObserverPendingReceiver,handle);this.$=new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);this.onConnectionError=this.proxy.getConnectionErrorEventRouter()}onNetworkListChanged(networkGuids,activeGuid){this.proxy.sendMessage(0,NetworkListObserver_OnNetworkListChanged_ParamsSpec.$,null,[networkGuids,activeGuid],false)}}export class NetworkListObserverReceiver{constructor(impl){this.helper_internal_=new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(NetworkListObserverRemote);this.$=new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);this.helper_internal_.registerHandler(0,NetworkListObserver_OnNetworkListChanged_ParamsSpec.$,null,impl.onNetworkListChanged.bind(impl),false);this.onConnectionError=this.helper_internal_.getConnectionErrorEventRouter()}}export class NetworkListObserver{static get $interfaceName(){return"ash.diagnostics.mojom.NetworkListObserver"}static getRemote(){let remote=new NetworkListObserverRemote;remote.$.bindNewPipeAndPassReceiver().bindInBrowser();return remote}}export class NetworkListObserverCallbackRouter{constructor(){this.helper_internal_=new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(NetworkListObserverRemote);this.$=new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);this.router_=new mojo.internal.interfaceSupport.CallbackRouter;this.onNetworkListChanged=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(0,NetworkListObserver_OnNetworkListChanged_ParamsSpec.$,null,this.onNetworkListChanged.createReceiverHandler(false),false);this.onConnectionError=this.helper_internal_.getConnectionErrorEventRouter()}removeListener(id){return this.router_.removeListener(id)}}export class NetworkStateObserverPendingReceiver{constructor(handle){this.handle=mojo.internal.interfaceSupport.getEndpointForReceiver(handle)}bindInBrowser(scope="context"){mojo.internal.interfaceSupport.bind(this.handle,"ash.diagnostics.mojom.NetworkStateObserver",scope)}}export class NetworkStateObserverRemote{constructor(handle){this.proxy=new mojo.internal.interfaceSupport.InterfaceRemoteBase(NetworkStateObserverPendingReceiver,handle);this.$=new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);this.onConnectionError=this.proxy.getConnectionErrorEventRouter()}onNetworkStateChanged(network){this.proxy.sendMessage(0,NetworkStateObserver_OnNetworkStateChanged_ParamsSpec.$,null,[network],false)}}export class NetworkStateObserverReceiver{constructor(impl){this.helper_internal_=new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(NetworkStateObserverRemote);this.$=new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);this.helper_internal_.registerHandler(0,NetworkStateObserver_OnNetworkStateChanged_ParamsSpec.$,null,impl.onNetworkStateChanged.bind(impl),false);this.onConnectionError=this.helper_internal_.getConnectionErrorEventRouter()}}export class NetworkStateObserver{static get $interfaceName(){return"ash.diagnostics.mojom.NetworkStateObserver"}static getRemote(){let remote=new NetworkStateObserverRemote;remote.$.bindNewPipeAndPassReceiver().bindInBrowser();return remote}}export class NetworkStateObserverCallbackRouter{constructor(){this.helper_internal_=new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(NetworkStateObserverRemote);this.$=new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);this.router_=new mojo.internal.interfaceSupport.CallbackRouter;this.onNetworkStateChanged=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(0,NetworkStateObserver_OnNetworkStateChanged_ParamsSpec.$,null,this.onNetworkStateChanged.createReceiverHandler(false),false);this.onConnectionError=this.helper_internal_.getConnectionErrorEventRouter()}removeListener(id){return this.router_.removeListener(id)}}export class NetworkHealthProviderPendingReceiver{constructor(handle){this.handle=mojo.internal.interfaceSupport.getEndpointForReceiver(handle)}bindInBrowser(scope="context"){mojo.internal.interfaceSupport.bind(this.handle,"ash.diagnostics.mojom.NetworkHealthProvider",scope)}}export class NetworkHealthProviderRemote{constructor(handle){this.proxy=new mojo.internal.interfaceSupport.InterfaceRemoteBase(NetworkHealthProviderPendingReceiver,handle);this.$=new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);this.onConnectionError=this.proxy.getConnectionErrorEventRouter()}observeNetworkList(observer){this.proxy.sendMessage(0,NetworkHealthProvider_ObserveNetworkList_ParamsSpec.$,null,[observer],false)}observeNetwork(observer,guid){this.proxy.sendMessage(1,NetworkHealthProvider_ObserveNetwork_ParamsSpec.$,null,[observer,guid],false)}}export class NetworkHealthProviderReceiver{constructor(impl){this.helper_internal_=new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(NetworkHealthProviderRemote);this.$=new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);this.helper_internal_.registerHandler(0,NetworkHealthProvider_ObserveNetworkList_ParamsSpec.$,null,impl.observeNetworkList.bind(impl),false);this.helper_internal_.registerHandler(1,NetworkHealthProvider_ObserveNetwork_ParamsSpec.$,null,impl.observeNetwork.bind(impl),false);this.onConnectionError=this.helper_internal_.getConnectionErrorEventRouter()}}export class NetworkHealthProvider{static get $interfaceName(){return"ash.diagnostics.mojom.NetworkHealthProvider"}static getRemote(){let remote=new NetworkHealthProviderRemote;remote.$.bindNewPipeAndPassReceiver().bindInBrowser();return remote}}export class NetworkHealthProviderCallbackRouter{constructor(){this.helper_internal_=new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(NetworkHealthProviderRemote);this.$=new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);this.router_=new mojo.internal.interfaceSupport.CallbackRouter;this.observeNetworkList=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(0,NetworkHealthProvider_ObserveNetworkList_ParamsSpec.$,null,this.observeNetworkList.createReceiverHandler(false),false);this.observeNetwork=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(1,NetworkHealthProvider_ObserveNetwork_ParamsSpec.$,null,this.observeNetwork.createReceiverHandler(false),false);this.onConnectionError=this.helper_internal_.getConnectionErrorEventRouter()}removeListener(id){return this.router_.removeListener(id)}}export const IPConfigPropertiesSpec={$:{}};export const CellularStatePropertiesSpec={$:{}};export const EthernetStatePropertiesSpec={$:{}};export const WiFiStatePropertiesSpec={$:{}};export const NetworkSpec={$:{}};export const NetworkListObserver_OnNetworkListChanged_ParamsSpec={$:{}};export const NetworkStateObserver_OnNetworkStateChanged_ParamsSpec={$:{}};export const NetworkHealthProvider_ObserveNetworkList_ParamsSpec={$:{}};export const NetworkHealthProvider_ObserveNetwork_ParamsSpec={$:{}};export const NetworkTypePropertiesSpec={$:{}};mojo.internal.Struct(IPConfigPropertiesSpec.$,"IPConfigProperties",[mojo.internal.StructField("nameServers",0,0,mojo.internal.Array(mojo.internal.String,false),null,true,0,undefined,undefined),mojo.internal.StructField("routingPrefix",8,0,mojo.internal.Int32,0,false,0,undefined,undefined),mojo.internal.StructField("gateway",16,0,mojo.internal.String,null,true,0,undefined,undefined),mojo.internal.StructField("ipAddress",24,0,mojo.internal.String,null,true,0,undefined,undefined)],[[0,40]]);mojo.internal.Struct(CellularStatePropertiesSpec.$,"CellularStateProperties",[mojo.internal.StructField("iccid",0,0,mojo.internal.String,null,false,0,undefined,undefined),mojo.internal.StructField("eid",8,0,mojo.internal.String,null,false,0,undefined,undefined),mojo.internal.StructField("networkTechnology",16,0,mojo.internal.String,null,false,0,undefined,undefined),mojo.internal.StructField("roaming",24,0,mojo.internal.Bool,false,false,0,undefined,undefined),mojo.internal.StructField("roamingState",28,0,RoamingStateSpec.$,0,false,0,undefined,undefined),mojo.internal.StructField("signalStrength",32,0,mojo.internal.Int32,0,false,0,undefined,undefined),mojo.internal.StructField("simLocked",24,1,mojo.internal.Bool,false,false,0,undefined,undefined),mojo.internal.StructField("lockType",36,0,LockTypeSpec.$,0,false,0,undefined,undefined)],[[0,48]]);mojo.internal.Struct(EthernetStatePropertiesSpec.$,"EthernetStateProperties",[mojo.internal.StructField("authentication",0,0,AuthenticationTypeSpec.$,0,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(WiFiStatePropertiesSpec.$,"WiFiStateProperties",[mojo.internal.StructField("signalStrength",0,0,mojo.internal.Int32,0,false,0,undefined,undefined),mojo.internal.StructField("frequency",4,0,mojo.internal.Int32,0,false,0,undefined,undefined),mojo.internal.StructField("ssid",8,0,mojo.internal.String,null,false,0,undefined,undefined),mojo.internal.StructField("bssid",16,0,mojo.internal.String,null,false,0,undefined,undefined),mojo.internal.StructField("security",24,0,SecurityTypeSpec.$,0,false,0,undefined,undefined)],[[0,40]]);mojo.internal.Struct(NetworkSpec.$,"Network",[mojo.internal.StructField("state",0,0,NetworkStateSpec.$,0,false,0,undefined,undefined),mojo.internal.StructField("type",4,0,NetworkTypeSpec.$,0,false,0,undefined,undefined),mojo.internal.StructField("typeProperties",8,0,NetworkTypePropertiesSpec.$,null,true,0,undefined,undefined),mojo.internal.StructField("observerGuid",24,0,mojo.internal.String,null,false,0,undefined,undefined),mojo.internal.StructField("name",32,0,mojo.internal.String,null,false,0,undefined,undefined),mojo.internal.StructField("macAddress",40,0,mojo.internal.String,null,true,0,undefined,undefined),mojo.internal.StructField("ipConfig",48,0,IPConfigPropertiesSpec.$,null,true,0,undefined,undefined)],[[0,64]]);mojo.internal.Struct(NetworkListObserver_OnNetworkListChanged_ParamsSpec.$,"NetworkListObserver_OnNetworkListChanged_Params",[mojo.internal.StructField("networkGuids",0,0,mojo.internal.Array(mojo.internal.String,false),null,false,0,undefined,undefined),mojo.internal.StructField("activeGuid",8,0,mojo.internal.String,null,false,0,undefined,undefined)],[[0,24]]);mojo.internal.Struct(NetworkStateObserver_OnNetworkStateChanged_ParamsSpec.$,"NetworkStateObserver_OnNetworkStateChanged_Params",[mojo.internal.StructField("network",0,0,NetworkSpec.$,null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(NetworkHealthProvider_ObserveNetworkList_ParamsSpec.$,"NetworkHealthProvider_ObserveNetworkList_Params",[mojo.internal.StructField("observer",0,0,mojo.internal.InterfaceProxy(NetworkListObserverRemote),null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(NetworkHealthProvider_ObserveNetwork_ParamsSpec.$,"NetworkHealthProvider_ObserveNetwork_Params",[mojo.internal.StructField("observer",0,0,mojo.internal.InterfaceProxy(NetworkStateObserverRemote),null,false,0,undefined,undefined),mojo.internal.StructField("guid",8,0,mojo.internal.String,null,false,0,undefined,undefined)],[[0,24]]);mojo.internal.Union(NetworkTypePropertiesSpec.$,"NetworkTypeProperties",{cellular:{ordinal:0,type:CellularStatePropertiesSpec.$},ethernet:{ordinal:1,type:EthernetStatePropertiesSpec.$},wifi:{ordinal:2,type:WiFiStatePropertiesSpec.$}});export var NetworkTypePropertiesFieldTags;(function(NetworkTypePropertiesFieldTags){NetworkTypePropertiesFieldTags[NetworkTypePropertiesFieldTags["CELLULAR"]=0]="CELLULAR";NetworkTypePropertiesFieldTags[NetworkTypePropertiesFieldTags["ETHERNET"]=1]="ETHERNET";NetworkTypePropertiesFieldTags[NetworkTypePropertiesFieldTags["WIFI"]=2]="WIFI"})(NetworkTypePropertiesFieldTags||(NetworkTypePropertiesFieldTags={}));export function whichNetworkTypeProperties(u){if(u.cellular!==null&&u.cellular!==undefined){return NetworkTypePropertiesFieldTags.CELLULAR}if(u.ethernet!==null&&u.ethernet!==undefined){return NetworkTypePropertiesFieldTags.ETHERNET}if(u.wifi!==null&&u.wifi!==undefined){return NetworkTypePropertiesFieldTags.WIFI}throw new Error("no union field has been set, this is an illegal state")}