// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import"./diagnostics_shared.css.js";import"/strings.m.js";import"chrome://resources/d3/d3.min.js";import{I18nMixin}from"chrome://resources/ash/common/cr_elements/i18n_mixin.js";import{loadTimeData}from"chrome://resources/ash/common/load_time_data.m.js";import{assert}from"chrome://resources/js/assert.js";import{PolymerElement}from"chrome://resources/polymer/v3_0/polymer/polymer_bundled.min.js";import{getTemplate}from"./realtime_cpu_chart.html.js";const RealtimeCpuChartElementBase=I18nMixin(PolymerElement);export class RealtimeCpuChartElement extends RealtimeCpuChartElementBase{static get is(){return"realtime-cpu-chart"}static get template(){return getTemplate()}static get properties(){return{user:{type:Number,value:0},system:{type:Number,value:0},numDataPoints:{type:Number,value:50},dataRefreshPerSecond:{type:Number,value:2},framesPerSecond:{type:Number,value:30},frameDuration:{readOnly:true,type:Number,computed:"getFrameDuration(dataRefreshPerSecond, framesPerSecond)"},width:{type:Number,value:560},height:{type:Number,value:114},padding:{type:Object,value:{top:10,right:5,bottom:8,left:50,tick:10}},graphWidth:{readOnly:true,type:Number,computed:"getGraphDimension(width, padding.left, padding.right)"},graphHeight:{readOnly:true,type:Number,computed:"getGraphDimension(height, padding.top, padding.bottom)"}}}constructor(){super();this.xAxisScaleFn=d3.scaleLinear();this.yAxisScaleFn=d3.scaleLinear();this.data=[];this.lastRender=0;this.currentFrame=0;this.yAxisTicks=[0,25,50,75,100];this.data=[];for(let i=0;i<this.numDataPoints;++i){this.data.push({user:-1,system:-1})}}static get observers(){return["setScaling(graphWidth)"]}ready(){super.ready();this.setScaling();this.initializeChart();window.addEventListener("resize",(()=>this.updateChartWidth()));this.updateChartWidth()}updateChartWidth(){const width=parseFloat(window.getComputedStyle(this).getPropertyValue("--chart-width-nav"));if(!isNaN(width)){this.width=width}}getFrameDuration(){assert(this.dataRefreshPerSecond>0);assert(this.framesPerSecond>0);assert(this.framesPerSecond%this.dataRefreshPerSecond===0);return 1e3/(this.framesPerSecond/this.dataRefreshPerSecond)}getGraphDimension(base,...margins){return margins.reduce(((acc,margin)=>acc-margin),base)}setScaling(){this.yAxisScaleFn=d3.scaleLinear().domain([0,100]).range([this.graphHeight,0]);this.xAxisScaleFn=d3.scaleLinear().domain([0,this.numDataPoints-2]).range([0,this.graphWidth]);const chartGroup=d3.select(this.shadowRoot.querySelector("#chartGroup"));assert(chartGroup);chartGroup.select("#gridLines").call(d3.axisLeft(this.yAxisScaleFn).tickValues(this.yAxisTicks).tickFormat((y=>this.getPercentageLabel(y))).tickPadding(this.padding.tick).tickSize(-this.graphWidth))}initializeChart(){const chartGroup=d3.select(this.shadowRoot.querySelector("#chartGroup"));assert(chartGroup);chartGroup.attr("transform",`translate(${this.padding.left},${this.padding.top})`);const plotGroup=d3.select(this.shadowRoot.querySelector("#plotGroup"));assert(plotGroup);plotGroup.datum(this.data);plotGroup.select(".user-area").transition().duration(this.frameDuration).ease((t=>+t));plotGroup.select(".system-area").transition().duration(this.frameDuration).ease((t=>+t));this.getDataSnapshotAndRedraw();this.render(0)}getAreaDefinition(areaClass){return d3.area().x(((_,i)=>this.xAxisScaleFn(i))).y0((data=>this?.yAxisScaleFn(areaClass==="system-area"?-1:data?.system))).y1((data=>this?.yAxisScaleFn(areaClass==="system-area"?data?.system:data?.system+data?.user)))}getDataSnapshotAndRedraw(){this.data.push({user:this.user,system:this.system});this.data.shift();const userArea=this.shadowRoot.querySelector(`path.user-area`);assert(userArea);const systemArea=this.shadowRoot.querySelector(`path.system-area`);assert(systemArea);d3.select(userArea).attr("d",this.getAreaDefinition("user-area"));d3.select(systemArea).attr("d",this.getAreaDefinition("system-area"))}render(timeStamp){if(timeStamp-this.lastRender>this.frameDuration){this.lastRender=performance.now();const framesPerCycle=this.framesPerSecond/this.dataRefreshPerSecond;if(this.currentFrame===framesPerCycle){this.currentFrame=0;this.getDataSnapshotAndRedraw()}const userArea=this.shadowRoot.querySelector(`path.user-area`);assert(userArea);const systemArea=this.shadowRoot.querySelector(`path.system-area`);assert(systemArea);const pos=-1*((this.currentFrame+1)/framesPerCycle);d3.select(userArea).attr("transform","translate("+this.xAxisScaleFn(pos)+",0)");d3.select(systemArea).attr("transform","translate("+this.xAxisScaleFn(pos)+",0)");this.currentFrame++}requestAnimationFrame((timeStamp=>this.render(timeStamp)))}getPercentageLabel(value){return loadTimeData.getStringF("percentageLabel",value)}getPaddingForTesting(){return this.padding}getFrameDurationForTesting(){return this.frameDuration}}customElements.define(RealtimeCpuChartElement.is,RealtimeCpuChartElement);