// Copyright 2021 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import{ExecutionProgress}from"./routine_list_executor.js";import{getSimpleResult}from"./routine_result_entry.js";import{StandardRoutineResult}from"./system_routine_controller.mojom-webui.js";function isBlockingRoutine(routineProp){return routineProp.blocking}function getNonBlockingRoutines(routines){return routines.filter((r=>!isBlockingRoutine(r))).map(getRoutine)}function getRoutine(routineProp){return routineProp.routine}export class RoutineGroup{constructor(routines,groupName){this.failedTest=null;this.inWarningState=false;this.routineProperties=this.routineProperties||routines;this.nonBlockingRoutines=new Set(getNonBlockingRoutines(routines));this.routines=routines.map(getRoutine);this.groupName=groupName;this.progress=ExecutionProgress.NOT_STARTED;this.failedTest=null;this.inWarningState=false}setStatus(status){if(status.progress!==ExecutionProgress.COMPLETED){this.progress=this.inWarningState?this.progress:status.progress;return}const isLastRoutine=this.isLastRoutine(status.routine);if(status.result&&this.testFailed(status.result)){this.failedTest=this.failedTest||status.routine;const isBlocking=!this.nonBlockingRoutines.has(status.routine);this.inWarningState=this.inWarningState||!isBlocking;if(this.failedTest&&isBlocking){this.progress=ExecutionProgress.COMPLETED;return}}this.progress=isLastRoutine?ExecutionProgress.COMPLETED:this.inWarningState?ExecutionProgress.WARNING:ExecutionProgress.RUNNING;return}testFailed(result){return getSimpleResult(result)===StandardRoutineResult.kTestFailed}isLastRoutine(routine){return routine===this.routines[this.routines.length-1]}addRoutine(routineProps){this.routines.push(routineProps.routine);if(!isBlockingRoutine(routineProps)){this.nonBlockingRoutines.add(routineProps.routine)}this.routineProperties=[...this.routineProperties,routineProps]}hasBlockingFailure(){if(!this.failedTest){return false}return!this.nonBlockingRoutines.has(this.failedTest)&&!this.inWarningState}clone(){const clonedRoutineGroup=new RoutineGroup(this.routineProperties,this.groupName);clonedRoutineGroup.progress=this.progress;clonedRoutineGroup.failedTest=this.failedTest;clonedRoutineGroup.inWarningState=this.inWarningState;return clonedRoutineGroup}}