// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import"./diagnostics_card.js";import"./diagnostics_shared.css.js";import"./routine_result_entry.js";import{assert}from"chrome://resources/js/assert.js";import{PolymerElement}from"chrome://resources/polymer/v3_0/polymer/polymer_bundled.min.js";import{RoutineGroup}from"./routine_group.js";import{ExecutionProgress,ResultStatusItem}from"./routine_list_executor.js";import{getTemplate}from"./routine_result_list.html.js";import{RoutineType}from"./system_routine_controller.mojom-webui.js";export const isRoutineGroupArray=arr=>arr[0].groupName!==undefined;export const isRoutineTypeArray=arr=>Object.values(RoutineType).includes(arr[0]);export class RoutineResultListElement extends PolymerElement{static get is(){return"routine-result-list"}static get template(){return getTemplate()}static get properties(){return{results:{type:Array,value:()=>[]},hidden:{type:Boolean,value:false},hideVerticalLines:{type:Boolean,value:false},usingRoutineGroups:{type:Boolean,value:false},ignoreRoutineStatusUpdates:{type:Boolean,value:false}}}initializeTestRun(routines){this.clearRoutines();if(routines.length===0){return}if(this.usingRoutineGroups&&isRoutineGroupArray(routines)){this.set("results",routines)}else{assert(isRoutineTypeArray(routines));this.addRoutines(routines)}}clearRoutines(){this.splice("results",0,this.results.length)}addRoutines(routines){for(const routine of routines){this.push("results",new ResultStatusItem(routine))}}updateRoutineStatus(index,status){assert(index<this.results.length);this.splice("results",index,1,status)}onStatusUpdate(status){if(this.ignoreRoutineStatusUpdates){return}assert(this.results.length>0);this.results.forEach(((result,idx)=>{if(result instanceof RoutineGroup&&result.routines.includes(status.routine)){result.setStatus(status);const shouldUpdateRoutineUI=result.hasBlockingFailure();this.hideVerticalLines=shouldUpdateRoutineUI;this.updateRoutineStatus(idx,result.clone());if(shouldUpdateRoutineUI){this.ignoreRoutineStatusUpdates=true;this.updateRoutineUiAfterFailure()}return}if(result instanceof ResultStatusItem){if(status.routine===result.routine){this.updateRoutineStatus(idx,status);return}}}))}shouldHideVerticalLines({value:value}){return this.hideVerticalLines||value===this.results[this.results.length-1]}updateRoutineUiAfterFailure(){assert(this.usingRoutineGroups);this.results.forEach(((routineGroup,i)=>{assert(routineGroup instanceof RoutineGroup);if(routineGroup.progress===ExecutionProgress.NOT_STARTED){routineGroup.progress=ExecutionProgress.SKIPPED;this.updateRoutineStatus(i,routineGroup.clone())}}))}resetIgnoreStatusUpdatesFlag(){this.ignoreRoutineStatusUpdates=false}}customElements.define(RoutineResultListElement.is,RoutineResultListElement);