// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import{mojo}from"//resources/mojo/mojo/public/js/bindings.js";export const RoutineTypeSpec={$:mojo.internal.Enum()};export var RoutineType;(function(RoutineType){RoutineType[RoutineType["MIN_VALUE"]=0]="MIN_VALUE";RoutineType[RoutineType["MAX_VALUE"]=20]="MAX_VALUE";RoutineType[RoutineType["kBatteryCharge"]=0]="kBatteryCharge";RoutineType[RoutineType["kBatteryDischarge"]=1]="kBatteryDischarge";RoutineType[RoutineType["kCpuCache"]=2]="kCpuCache";RoutineType[RoutineType["kCpuStress"]=3]="kCpuStress";RoutineType[RoutineType["kCpuFloatingPoint"]=4]="kCpuFloatingPoint";RoutineType[RoutineType["kCpuPrime"]=5]="kCpuPrime";RoutineType[RoutineType["kMemory"]=6]="kMemory";RoutineType[RoutineType["kLanConnectivity"]=7]="kLanConnectivity";RoutineType[RoutineType["kSignalStrength"]=8]="kSignalStrength";RoutineType[RoutineType["kGatewayCanBePinged"]=9]="kGatewayCanBePinged";RoutineType[RoutineType["kHasSecureWiFiConnection"]=10]="kHasSecureWiFiConnection";RoutineType[RoutineType["kDnsResolverPresent"]=11]="kDnsResolverPresent";RoutineType[RoutineType["kDnsLatency"]=12]="kDnsLatency";RoutineType[RoutineType["kDnsResolution"]=13]="kDnsResolution";RoutineType[RoutineType["kCaptivePortal"]=14]="kCaptivePortal";RoutineType[RoutineType["kHttpFirewall"]=15]="kHttpFirewall";RoutineType[RoutineType["kHttpsFirewall"]=16]="kHttpsFirewall";RoutineType[RoutineType["kHttpsLatency"]=17]="kHttpsLatency";RoutineType[RoutineType["kArcHttp"]=18]="kArcHttp";RoutineType[RoutineType["kArcPing"]=19]="kArcPing";RoutineType[RoutineType["kArcDnsResolution"]=20]="kArcDnsResolution"})(RoutineType||(RoutineType={}));export const StandardRoutineResultSpec={$:mojo.internal.Enum()};export var StandardRoutineResult;(function(StandardRoutineResult){StandardRoutineResult[StandardRoutineResult["MIN_VALUE"]=0]="MIN_VALUE";StandardRoutineResult[StandardRoutineResult["MAX_VALUE"]=3]="MAX_VALUE";StandardRoutineResult[StandardRoutineResult["kTestPassed"]=0]="kTestPassed";StandardRoutineResult[StandardRoutineResult["kTestFailed"]=1]="kTestFailed";StandardRoutineResult[StandardRoutineResult["kExecutionError"]=2]="kExecutionError";StandardRoutineResult[StandardRoutineResult["kUnableToRun"]=3]="kUnableToRun"})(StandardRoutineResult||(StandardRoutineResult={}));export class RoutineRunnerPendingReceiver{constructor(handle){this.handle=mojo.internal.interfaceSupport.getEndpointForReceiver(handle)}bindInBrowser(scope="context"){mojo.internal.interfaceSupport.bind(this.handle,"ash.diagnostics.mojom.RoutineRunner",scope)}}export class RoutineRunnerRemote{constructor(handle){this.proxy=new mojo.internal.interfaceSupport.InterfaceRemoteBase(RoutineRunnerPendingReceiver,handle);this.$=new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);this.onConnectionError=this.proxy.getConnectionErrorEventRouter()}onRoutineResult(info){this.proxy.sendMessage(0,RoutineRunner_OnRoutineResult_ParamsSpec.$,null,[info],false)}}export class RoutineRunnerReceiver{constructor(impl){this.helper_internal_=new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(RoutineRunnerRemote);this.$=new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);this.helper_internal_.registerHandler(0,RoutineRunner_OnRoutineResult_ParamsSpec.$,null,impl.onRoutineResult.bind(impl),false);this.onConnectionError=this.helper_internal_.getConnectionErrorEventRouter()}}export class RoutineRunner{static get $interfaceName(){return"ash.diagnostics.mojom.RoutineRunner"}static getRemote(){let remote=new RoutineRunnerRemote;remote.$.bindNewPipeAndPassReceiver().bindInBrowser();return remote}}export class RoutineRunnerCallbackRouter{constructor(){this.helper_internal_=new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(RoutineRunnerRemote);this.$=new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);this.router_=new mojo.internal.interfaceSupport.CallbackRouter;this.onRoutineResult=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(0,RoutineRunner_OnRoutineResult_ParamsSpec.$,null,this.onRoutineResult.createReceiverHandler(false),false);this.onConnectionError=this.helper_internal_.getConnectionErrorEventRouter()}removeListener(id){return this.router_.removeListener(id)}}export class SystemRoutineControllerPendingReceiver{constructor(handle){this.handle=mojo.internal.interfaceSupport.getEndpointForReceiver(handle)}bindInBrowser(scope="context"){mojo.internal.interfaceSupport.bind(this.handle,"ash.diagnostics.mojom.SystemRoutineController",scope)}}export class SystemRoutineControllerRemote{constructor(handle){this.proxy=new mojo.internal.interfaceSupport.InterfaceRemoteBase(SystemRoutineControllerPendingReceiver,handle);this.$=new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);this.onConnectionError=this.proxy.getConnectionErrorEventRouter()}getSupportedRoutines(){return this.proxy.sendMessage(0,SystemRoutineController_GetSupportedRoutines_ParamsSpec.$,SystemRoutineController_GetSupportedRoutines_ResponseParamsSpec.$,[],false)}runRoutine(type,runner){this.proxy.sendMessage(1,SystemRoutineController_RunRoutine_ParamsSpec.$,null,[type,runner],false)}}export class SystemRoutineControllerReceiver{constructor(impl){this.helper_internal_=new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(SystemRoutineControllerRemote);this.$=new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);this.helper_internal_.registerHandler(0,SystemRoutineController_GetSupportedRoutines_ParamsSpec.$,SystemRoutineController_GetSupportedRoutines_ResponseParamsSpec.$,impl.getSupportedRoutines.bind(impl),false);this.helper_internal_.registerHandler(1,SystemRoutineController_RunRoutine_ParamsSpec.$,null,impl.runRoutine.bind(impl),false);this.onConnectionError=this.helper_internal_.getConnectionErrorEventRouter()}}export class SystemRoutineController{static get $interfaceName(){return"ash.diagnostics.mojom.SystemRoutineController"}static getRemote(){let remote=new SystemRoutineControllerRemote;remote.$.bindNewPipeAndPassReceiver().bindInBrowser();return remote}}export class SystemRoutineControllerCallbackRouter{constructor(){this.helper_internal_=new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(SystemRoutineControllerRemote);this.$=new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);this.router_=new mojo.internal.interfaceSupport.CallbackRouter;this.getSupportedRoutines=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(0,SystemRoutineController_GetSupportedRoutines_ParamsSpec.$,SystemRoutineController_GetSupportedRoutines_ResponseParamsSpec.$,this.getSupportedRoutines.createReceiverHandler(true),false);this.runRoutine=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(1,SystemRoutineController_RunRoutine_ParamsSpec.$,null,this.runRoutine.createReceiverHandler(false),false);this.onConnectionError=this.helper_internal_.getConnectionErrorEventRouter()}removeListener(id){return this.router_.removeListener(id)}}export const PowerRoutineResultSpec={$:{}};export const RoutineResultInfoSpec={$:{}};export const RoutineRunner_OnRoutineResult_ParamsSpec={$:{}};export const SystemRoutineController_GetSupportedRoutines_ParamsSpec={$:{}};export const SystemRoutineController_GetSupportedRoutines_ResponseParamsSpec={$:{}};export const SystemRoutineController_RunRoutine_ParamsSpec={$:{}};export const RoutineResultSpec={$:{}};mojo.internal.Struct(PowerRoutineResultSpec.$,"PowerRoutineResult",[mojo.internal.StructField("simpleResult",0,0,StandardRoutineResultSpec.$,0,false,0,undefined,undefined),mojo.internal.StructField("percentChange",8,0,mojo.internal.Double,0,false,0,undefined,undefined),mojo.internal.StructField("timeElapsedSeconds",4,0,mojo.internal.Uint32,0,false,0,undefined,undefined)],[[0,24]]);mojo.internal.Struct(RoutineResultInfoSpec.$,"RoutineResultInfo",[mojo.internal.StructField("type",0,0,RoutineTypeSpec.$,0,false,0,undefined,undefined),mojo.internal.StructField("result",8,0,RoutineResultSpec.$,null,false,0,undefined,undefined)],[[0,32]]);mojo.internal.Struct(RoutineRunner_OnRoutineResult_ParamsSpec.$,"RoutineRunner_OnRoutineResult_Params",[mojo.internal.StructField("info",0,0,RoutineResultInfoSpec.$,null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(SystemRoutineController_GetSupportedRoutines_ParamsSpec.$,"SystemRoutineController_GetSupportedRoutines_Params",[],[[0,8]]);mojo.internal.Struct(SystemRoutineController_GetSupportedRoutines_ResponseParamsSpec.$,"SystemRoutineController_GetSupportedRoutines_ResponseParams",[mojo.internal.StructField("routines",0,0,mojo.internal.Array(RoutineTypeSpec.$,false),null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(SystemRoutineController_RunRoutine_ParamsSpec.$,"SystemRoutineController_RunRoutine_Params",[mojo.internal.StructField("type",0,0,RoutineTypeSpec.$,0,false,0,undefined,undefined),mojo.internal.StructField("runner",4,0,mojo.internal.InterfaceProxy(RoutineRunnerRemote),null,false,0,undefined,undefined)],[[0,24]]);mojo.internal.Union(RoutineResultSpec.$,"RoutineResult",{simpleResult:{ordinal:0,type:StandardRoutineResultSpec.$},powerResult:{ordinal:1,type:PowerRoutineResultSpec.$}});export var RoutineResultFieldTags;(function(RoutineResultFieldTags){RoutineResultFieldTags[RoutineResultFieldTags["SIMPLE_RESULT"]=0]="SIMPLE_RESULT";RoutineResultFieldTags[RoutineResultFieldTags["POWER_RESULT"]=1]="POWER_RESULT"})(RoutineResultFieldTags||(RoutineResultFieldTags={}));export function whichRoutineResult(u){if(u.simpleResult!==null&&u.simpleResult!==undefined){return RoutineResultFieldTags.SIMPLE_RESULT}if(u.powerResult!==null&&u.powerResult!==undefined){return RoutineResultFieldTags.POWER_RESULT}throw new Error("no union field has been set, this is an illegal state")}